Program DelUdLog;

Uses
      Crt,Dos;

Var
      Log1, Log2                              : Text;
      PceDir, x                               : String;
      y, m, d, dow, y2, m2, d2                : Word;
      f                                       : Byte;
      Days, MaxDays                           : LongInt;
      MsgBuf                                  : Array[0..127] of Char;

Function IntStr(R : LongInt): String;
Var
    S   : String[12];
  Begin
    Str(R,S);
    IntStr:=s;
  End;

Function StrInt(S : String): LongInt;
Var
   C    : Integer;
   R    : LongInt;
  Begin
    Val(S,R,C);
    If C=0 then StrInt:=r
           else StrInt:=0;
  End;

Function GEnv(S : String): String;
Var skrap : String;
  Begin
    skrap:=getenv(S);
    If (length(skrap)<>0) and (skrap[length(skrap)]<>'\') then skrap:=skrap+'\';
    GEnv:=Skrap;
  End;

Function Jul(mo,da,yr:Integer): LongInt;
  Begin
   jul:=(da-32075+(1461*(yr+4800+((mo-14)div(12))))div(4))+
    + (367*(mo-2-(((mo-14)div(12)))*12)div(12))-(3*((yr+4900+
      (((mo-14)div(12))))div(100))div(4));
  End;

Function DaysBetween(Mo1,Da1,Yr1,Mo2,Da2,Yr2:Integer):LongInt;
  Begin
    DaysBetween :=(Jul(Mo1,Da1,Yr1)-Jul(Mo2,Da2,Yr2));
  End;

Function fExist(FileName: String): Boolean;
Var F: File;
  Begin
    Assign(F,FileName);
    {$I-}
    Reset(F);
    Close(F);
    {$I+}
    fExist :=(IOResult=0) and (FileName<>'');
  End;

Function OpenUdLog(f1Name : String; f2Name : String) : Boolean;
  Begin
    If fExist(f1Name) then Begin
      Assign(Log1,f1Name);
      {$I-}
      Reset(Log1);
      {$I+}
      If IOResult=0 then Begin
        Assign(Log2,f2Name);
        {$I-}
        Rewrite(Log2);
        {$I+}
        If IOResult<>0 then OpenUdlog:=False
                       else OpenUdlog:=True;
      End Else OpenUdlog:=False;
    End Else OpenUdlog:=False;
  End;

Procedure CloseUdLog(f1Name : String; f2Name : String);
  Begin
    {$I-}
    Close(Log1);
    Close(Log2);
    {$I+}
    If IOResult=0 then Begin
      {$I-}
      Erase(Log1);
      Rename(Log2,f1Name);
      {$I+}
    End;
  End;

Const Sign=' DelUdLog ۲ v.1.0 (c) Nov. ''95 by MuHaDiB of AylA-BBs';

Procedure Help;
  Begin
    WriteLn('  Uses   : DELUDLOG.EXE <Max. older in UDLOGx.TXT>');
    WriteLn;
    WriteLn('  Example: DELUDLOG.EXE 10');
    WriteLn('            Delete all lines that older than 10 Days ');
    WriteLn;
    Halt;
  End;

Begin
  DirectVideo:=False;
  WriteLn;
  TextColor(Cyan);
  WriteLn(Sign);
  NormVideo;
  WriteLn;
  If (ParamCount>1) or (ParamCount=0) or (Pos('?',ParamStr(1))<>0) then Help;
  PceDir:=GEnv('PCEXPRESS');
  MaxDays:=StrInt(ParamStr(1));
  If MaxDays=0 then MaxDays:=10;
  GetDate(y,m,d,dow);
  For f:=0 to 9 do Begin
    WriteLn('  Scanning UDLOG',f,'.TXT .... ');
    If OpenUdLog(PceDir+'UDLOG'+IntStr(f)+'.TXT',PceDir+'UDLOG'+IntStr(f)+'.BAK') Then Begin
      Write('   Read/Write UDLOG',f,'.TXT .... ');
      While not eof(Log1) do Begin
        ReadLn(Log1,x);
        y2:=StrInt(Copy(x,1,4));
        m2:=StrInt(Copy(x,6,2));
        d2:=StrInt(Copy(x,9,2));
        If MaxDays>DaysBetween(m,d,y,m2,d2,y2) then WriteLn(Log2,x);
      End;
      WriteLn('Done!');
      CloseUdLog(PceDir+'UDLOG'+IntStr(f)+'.TXT',PceDir+'UDLOG'+IntStr(f)+'.BAK')
    End;
  End;
End.

