Program Chatter;

{*********************************************************}
{*                    CHATTER.PAS 1.00                   *}
{*   FreeWare, released by Creative Team in PCE-MAG #8   *}
{*      Demonstration program for the pkWINDOW unit      *}
{*********************************************************}

uses pkWINDOW,
     pkMISC,
     CRT;

procedure MyWriteProc(output : string);
begin
 write(output);
end;

procedure MyGotoXYProc(x,y : byte);
begin
 gotoxy(x,y);
end;

var Init : InitRecord;
    i    : byte;
    ch   : char;

begin
 {clear the screen}
 clrscr;

 {draw 2 chat windows}
 writeln(''+pkdup('',77)+'');
 writeln(''+pkdup(' ',77)+'');
 writeln(''+pkdup(' ',77)+'');
 writeln(''+pkdup('',77)+'');
 writeln(''+pkdup(' ',77)+'');
 writeln(''+pkdup(' ',77)+'');
 writeln(''+pkdup('',77)+'');

 {define the procs...}
 SetWriteProc(MyWriteProc);
 SetGotoXYProc(MyGotoXYProc);

 {define chat window 1}
 with init do
 begin
  maxlines      :=  2;
  startx[1]     :=  2;
  startx[2]     :=  3;
  starty[1]     :=  2;
  starty[2]     :=  2;
  maxchars[1]   := 77;
  maxchars[2]   := 77;
 end;

 {Allocate memory for chat window 1 on the heap and initialize the window}
 pkInitWindow(1,Init);

 {define chat window 2}
 with init do
 begin
  maxlines      :=  2;
  startx[1]     :=  5;
  startx[2]     :=  6;
  starty[1]     :=  2;
  starty[2]     :=  2;
  maxchars[1]   := 77;
  maxchars[2]   := 77;
 end;

 {Allocate memory for chat window 2 on the heap and initialize the window}
 pkInitWindow(2,Init);

 gotoxy(2,2);
 {this is all you will have to code...}
 repeat
  ch:=readkey;
  if ch in [#8,#13,#32..#255] then
   begin
    if upcase(ch) in ['A','Z'] then pkWindowPutChar(1,ch)
    else pkWindowPutChar(2,ch);
   end;
 until ch=#27;

 {deallocate the memory in use by the 2 windows}
 pkDoneWindow(1);
 pkDoneWindow(2);

 {ezy?!??}
end.