Unit DirXUnit;          {Coded by The WHiTE KNiGHT. Released as PD.}

{$O+,F+,X+}             {Allows you to overlay the unit. I used it for my doorkit, which is 100% overlayed.}

Interface

Uses Dos,Struc119;

Const
    MAX_ID_LINES        = 100;

Type
    Id_Line             = String[45];
    FileRec             = Record
      Conf,
      Area              : Byte;
      Name              : String[8];
      Ext               : String[3];
      Exists            : Boolean; {Does it really exist or just in dirfile?}
      Size              : LongInt;
      DirDate,
      RealDate          : String[8];
      Pay               : Boolean; {Pay or for free (P|F)}
      File_Id           : Array[1..MAX_ID_LINES] of Id_Line;{filled with empty lines}
    End;

Var
   ConfRec              : ConRec;       {Conference info}
   CurConf,                             {For DirX_FindNext}
   CurArea              : Byte;         {For DirX_FindNext}
   ConfAxx              : Array [1..MaxConf] of Boolean; {Conferences to scan}
   LoadFILE_ID          : Boolean;


Function DirX_Result:Byte; {Not all specified errorcodes are used yet :) }
{0=Ok
 1=Conf not exist
 2=Area not exist
 3=file io
 4=mem
 5=tomany
 6=nomore (like doserror 18)
 7=file not found
 8=environment error (SET PCEXPRESS missing)}

Procedure DirX_Init;
{
  Before using this unit, it would be smart to check if DirX_Result return 0!
  If it's not (means it'll be 8!), the PCEXPRESS environment variable is NOT set!
  All operation afterwards will return errors, since GetConfInfo will fail!
  It's automatically called at program startup, so don't call it from your
  program. Hmmm, wonder why I included in the Interface part...
}

Procedure DirX_FindFile( Conf:Byte; FileName:String; Var FileI:FileRec );
{
  Search for the specified file in the conference #<conf>. if <conf> is 0,
  it will search for the file in ALL conferences. If it's NOT found,
  DirX_Result will return 7, else it'll be 0 (Ok).
}

Procedure DirX_FindFirst( Conf,Area:Byte; Var FileI:FileRec );
{
  Acts same as FindFirst of the Dos unit, only now you have to pass some
  other parameters. With the parameters <Conf> and <Area> you can specify
  in which conference and filearea DIRXUNIT should search. The first file
  is returned in FileI. Call this ones, then call DirX_FindNext.
  DirX_Result returns 6 if no more files where found.
}

Procedure DirX_FindNext( Var FileI:FileRec );
{
  Find next file in conference and area as specified when calling
  DirX_FindFirst. The file that is (is not) found, is returned in FileI.
  DirX_Result returns 6 if no more files where found.

  FUTURE ENHANCEMENT:
  Make it read the FILE_ID.DIZ also, cause it's not read yet (used by
  DirX_FindFirst, DirX_FindNext(duh!) and DirX_FindFile!)
  I can do it now, but that would mean it reads one line too far.
  I would have to read it back from the beginning of the file, and that
  would be MUCH too slow!
}

Procedure DirX_AddFile( Conf,Area:Byte; FileI:FileRec );
{
  With this routine you can add files to the dirfile! The location can be
  specified with <Conf> and <Area>. Filedata should be passed with FileI.
  Only the following fields are used in the dirfile:
    - Name
    - Ext
    - DirDate
    - Pay
    - File_Id (All lines, until empty)
}

Procedure DirX_DelFile( Conf:Byte; FileName:String );
{
  Use this routine to delete files from the dirfile. Conf should be the
  conference and may NOT be equal to zero!
}

Function  GetConfInfo(ConfNo:Byte):Boolean;
{
  This routine will supply information about a specified conference.
}


Implementation

Const
   ConfCfg      = 'CONFER.CFG';

Var
   Exit_Save    : Pointer;

Var
   F            : Text;
   FileOpen     : Boolean;
   DirX_Error   : Byte;
   BBSPath      : String;
   FileName     : String;




Function FExt(filename:string):String;
Var epos:byte;
Begin
  epos := Pos('.',filename);
  If epos = 0 then
    FExt := ''
  else
    FExt := Copy(FileName,epos+1,Length(filename)-epos);
End;

Function FName(filename:string):String;
Var epos:byte;
Begin
  epos := Pos('.',filename);
  If epos = 0 then
    FName := filename
  else
    FName := Copy(FileName,1,epos-1);
End;



Function  GetConfInfo(ConfNo:Byte):Boolean;
var f:file;
Begin
  Assign(f,BBSPath+ConfCfg);
  {$I-}
  Reset(f,1);
  Seek(f,(ConfNo-1)*SizeOf(ConRec));
  BlockRead(f,ConfRec,SizeOf(ConRec));
  Close(f);
  {$I+}
  GetConfInfo := (IOResult=0);
End;


{$F+}
Procedure DeInit;
Begin
     ExitProc := Exit_Save;
     If FileOpen
     then begin
       FileOpen := False;
       Close(f);
     end;
End;
{$F-}


Function DirX_Result:Byte;
Begin
  DirX_Result := DirX_Error;
  DirX_Error := 0;
End;


Procedure DirX_Init;
var
   b                    : byte;
Begin
     FileOpen := False;
     CurConf := 0;
     CurArea := 0;
     for b := 1 to MaxConf
     do
       ConfAxx[b] := True;
     LoadFILE_ID := True;
     DirX_Error := 0;

     BBSPath := GetEnv('PCEXPRESS');
     If BBSPath <> ''
     then begin
       if BBSPath[Length(BBSPath)] <> '\'
       then
         BBSPath := BBSPath + '\';
     end
     else
       DirX_Error := 8;
End;



function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;


Function UCase(str:string):String;
var i:Byte;
Begin
 For i := 1 to Length(str) do
   str[i] := Upcase(Str[i]);
 UCase := str;
End;


Procedure DirX_FindNext( Var FileI:FileRec );
Var
   St,Line              : String;
   B                    : Byte;
   SRec                 : SearchRec;
   DT                   : DateTime;
Begin
  if FileOpen
  then begin
    Line := '.';
    While (NOT Eof(f)) AND ((Line[1] in [' ','.']) OR (Line = ''))  do
      System.Readln(f,Line);
    If NOT ((Line[1] in [' ','.']) OR (Line = ''))
    then begin
      St := '';
      B := 1;
      While (Line[b] <> ' ') AND (b < Length(Line))
      do begin
        St := St + Line[b];
        Inc(b);
      end;
      FileI.Conf := CurConf;
      FileI.Area := CurArea;
      FileI.Name := FName(St);
      FileI.Ext := FExt(St);
      FileI.Pay := Upcase(Line[b+1])='P';
      St := Copy(Line,b+3,Length(Line)-(b+2));
      FileI.DirDate := Copy(St,1,2)+'-'+Copy(St,3,2)+'-'+Copy(St,5,2);
      Dos.FindFirst(ConfRec.ConfFiles[CurArea]+FileI.Name+'.'+FileI.Ext,$3F,SRec);
      If DosError = 0 then begin
        FileI.Exists := True;
        FileI.Size := SRec.Size;
        UnPackTime(SRec.Time,Dt);
        FileI.RealDate := LeadingZero(Dt.Day)+'-'+LeadingZero(Dt.Month)+'-'+LeadingZero(Dt.Year);
      end
      else begin
        FileI.Exists := False;
        FileI.RealDate := '  -  -  ';
        FileI.Size := 0;
        FileI.File_Id[1] := '';
      end;
      if LoadFILE_ID
      then begin
        b := 0;
        Repeat
          System.Readln(f,Line);
          Inc(b);
          FileI.File_Id[b] := Copy(Line,2,Length(Line)-1);
        Until (B = MAX_ID_LINES) OR (Line[1] <> ' ') OR (Eof(f));
        For B := B to MAX_ID_LINES do
          FileI.File_Id[b] := '';
      end;

      (*

      I have no idea how to fix the above mentioned problem. If you think
      you can fix it, please contact me about it. You can reach me at
      Chronicle, Nuclear Climate or Planet Groove!.

      *)

    end
    else
      DirX_Error := 6;
    if Eof(f)
    then begin
      Close(f);
      FileOpen := False;
    end;
  end
  else
    DirX_Error := 3;
End;


Procedure DirX_FindFirst( Conf,Area:Byte; Var FileI:FileRec );
Begin
  If FileOpen
  then begin
    FileOpen := False;
    Close(f);
  end;
  if GetConfInfo(Conf)
  then begin
    Assign(f,ConfRec.ConfFiles[Area]+'DIR'+Char(Area+48)+'.TXT');
    {$I-}
    Reset(f);
    {$I+}
    if IOResult = 0
    then begin
      FileOpen := True;
      CurConf := Conf;
      CurArea := Area;
      DirX_FindNext(FileI);
    end
    else
      DirX_Error := 2;
  end
  else
    DirX_Error := 1;
End;


Procedure DirX_FindFile( Conf:Byte; FileName:String; Var FileI:FileRec );
var
   b,b2                 : Byte;
   Found                : Boolean;
begin

  Found := False;

  if Conf=0
  then begin
    b := 1;
    while (NOT Found) AND (b <= MaxConf) do
    begin
      if ConfAxx[b]
      then begin
        b2 := 1;
        while (NOT Found) AND (b2 <= 9) do
        begin
          DirX_FindFirst(b,b2,FileI);
          While (NOT Found) AND (DirX_Result=0)
          do begin
            if (FileI.Name+'.'+FileI.Ext = UCase(FileName))
            then
              Found := True
            else
              DirX_FindNext(FileI);
          end;
          Inc(b2);
        end;
      end;
      Inc(b);
    end;
  end
  else begin
    b2 := 1;
    while (NOT Found) AND (b2 <= 9) do
    begin
      DirX_FindFirst(Conf,b2,FileI);
      While (NOT Found) AND (DirX_Result=0)
      do begin
        if (FileI.Name+'.'+FileI.Ext = UCase(FileName))
        then
          Found := True
        else
          DirX_FindNext(FileI);
      end;
      Inc(b2);
    end;
  end;
  if FileOpen
  then begin
    Close(f);
    FileOpen := False;
  end;
  if Found
  then
    DirX_Error := 0
  else
    DirX_Error := 7;
end;



Procedure DirX_DelFile( Conf:Byte; FileName:String );
var
   b,b2                 : Byte;
   Found                : Boolean;
   FI                   : FileRec;
   f,f2                 : Text;
   St,
   Line                 : String;
begin
  DirX_FindFile(Conf,Filename,FI);
  if DirX_Error = 0
  then begin
    Assign(f,ConfRec.ConfFiles[FI.Area]+'DIR'+Char(FI.Area+48)+'.TXT');
    {$I-}
    Reset(f);
    {$I+}
    if IOResult = 0
    then begin
      Assign(f2,ConfRec.ConfFiles[FI.Area]+'DIR'+Char(FI.Area+48)+'.NEW');
      Rewrite(f2);
      Found := False;
      While not eof(f)
      do begin
        System.Readln(f,Line);
        if Line=''
        then
          Writeln(f2,'')
        else begin
          If NOT (Line[1] in [' ','.'])
          then begin
            St := Copy(Line,1,Pos(' ',Line)-1);
            if St = (FI.Name+'.'+FI.Ext)
            then begin
              Found := True;
              repeat
                System.Readln(f,Line);
              until eof(f) OR (Line[1] <> ' ');
              if Line[1] <> ' '
              then
                System.Writeln(f2,Line);
            end
            else
              System.Writeln(f2,Line);
          end
          else
            System.Writeln(f2,Line);
        end;
      end;
      Close(f2);
      Close(f);
      Erase(f);
      Rename(f2,ConfRec.ConfFiles[FI.Area]+'DIR'+Char(FI.Area+48)+'.TXT');
      if NOT Found
      then
        DirX_Error := 7
    end
    else
      DirX_Error := 3;
  end;
end;


Procedure DirX_AddFile( Conf,Area : Byte; FileI:FileRec );
var
   St                   : String;
   b                    : Byte;
begin

  If FileOpen
  then begin
    FileOpen := False;
    Close(f);
  end;
  if GetConfInfo(Conf)
  then begin
    Assign(f,ConfRec.ConfFiles[Area]+'DIR'+Char(Area+48)+'.TXT');
    {$I-}
    Append(f);
    {$I+}
    if IOResult = 0
    then begin
      FileOpen := True;
      CurConf := Conf;
      CurArea := Area;
      St := #13#10+FileI.Name+'.'+FileI.Ext+' ';
      if FileI.Pay
      then
        St := St + 'P'
      else
        St := St + 'F';
      St := St + ' '+ Copy(FileI.DirDate,1,2)+Copy(FileI.DirDate,4,2)+Copy(FileI.DirDate,7,2);
      System.Writeln(f,St);
      b := 1;
      While (FileI.File_Id[b] <> '') AND (b <= MAX_ID_LINES)
      do begin
        System.Writeln(f,' '+FileI.File_Id[b]);
        Inc(b);
      end;
      System.Writeln(f,'');
      Close(f);
      FileOpen := False;
    end
    else
      DirX_Error := 2;
  end
  else
    DirX_Error := 1;
end;


begin
  DirX_Init;
end.
