program checksum;

uses crt,dos;

Procedure Upstring(var st:string);
  var
    t : byte;
    begin
      for t:=1 to length(st) do st[t]:=Upcase(st[t]);
    end;

procedure Error(nr:byte);
 begin
   write(#7);
    case nr of
      3   : writeln('Path not found!');
      5   : writeln('Access denied!');
      15  : writeln('Invalid driveletter specified!');
      100 : writeln('Disk read error!');
      101 : writeln('Disk write error!');
      150 : writeln('Disk is write protected!');
      152 : writeln('Drive not ready!');
      153 : writeln('CRC read error!');
      156 : writeln('Disk seek error!');
      158 : writeln('Sector not found!');
      162 : writeln('Drive failure!');
      else writeln('Unknown error!');
    end;
   writeln;
   halt(1);
 end;

procedure Swrite(st:string);
var
   t : byte;
 begin
   for t:=1 to length(st) do
    begin
      if st[t]='{' then highvideo;
      if st[t]='}' then normvideo;
      if (st[t]<>'{') AND (st[t]<>'}') then write(st[t]);
    end;
 end;

var
    f        : file;
    ff       : text;
    size     : longint;
    status   : integer;
    filename : string;
    t        : word;
    data     : array[1..10240] of byte;
    lpntr    : array[0..3] of byte absolute size;
    sr       : searchrec;
    IOerror  : word;
 begin
   if paramcount=1 then
    begin
      filename:=paramstr(1);
      Upstring(filename);
      findfirst(filename,$3f,sr);
      if doserror=18 then
       begin
         writeln(#7,'File not found!');
         writeln;
         halt;
       end;
      if doserror>0 then Error(doserror);
      Swrite('Processing file : {'+filename+'} >');
      assign(f,paramstr(1));
      reset(f,1);
      size:=0;
      status:=10240;
      while status=10240 do
       begin
       {$I-}
         blockread(f,data,10240,status);
       {$I+}
         IOerror:=IOresult;
         write('.');
         if IOerror>0 then error(IOerror);
         for t:=1 to status do size:=size+data[t];
       end;
      close(f);
      writeln;
      writeln;
      status:=0;
      Swrite('Checksum completed, writing number {');
      write(size);
      Swrite('} into EXE file..');
      assign(ff,paramstr(1));
      append(ff);
      for t:=0 to 3 do write(ff,chr(lpntr[t] XOR 38));
      close(ff);
      writeln;
      writeln;
      writeln('Operation complete..');
    end
   else
    begin
      Swrite(#7+'  USAGE : {CHECKSUM [filename]}.');
      writeln;
    end;
 end.