Unit pkWINDOW;

{*********************************************************}
{*                   pkWINDOW.PAS 1.00                   *}
{*   FreeWare, released by Creative Team in PCE-MAG #8   *}
{*   Author: Alexander ten Bruggencate / Creative Team   *}
{*********************************************************}

{*

 if you make any modifications then please send the code to
 me so I can check your code and then repost it!

*}

interface

uses pkASYNC;

const MaxLinesInWindow = 12;
      MaxWindows       = 10;

type InitRecord   = Record
      startx      : array [1..MaxLinesInWindow] of byte;
      starty      : array [1..MaxLinesInWindow] of byte;
      maxchars    : array [1..MaxLinesInWindow] of byte;
      maxlines    : byte;
     end;

     GotoXYProc = procedure(x,y : byte);
     WriteProc  = procedure(str : string);

procedure SetGotoXYProc(NewProc : GotoXYProc);
procedure SetWriteProc(NewProc : WriteProc);
function  pkInitWindow(nr : byte; Init : InitRecord) : boolean;
function  pkDoneWindow(nr : byte) : boolean;
function  pkWindowPutChar(nr : byte; ch : char) : boolean;
function  pkGetLastPos(nr : byte; var lastx,lasty : byte) : boolean;
function  pkWindowActive(nr : byte) : boolean;

implementation

type WinRecPtr    = ^WindowRecord;
     WindowRecord = Record
      startx      : array [1..MaxLinesInWindow] of byte;
      starty      : array [1..MaxLinesInWindow] of byte;
      maxchars    : array [1..MaxLinesInWindow] of byte;
      windowline  : array [1..MaxLinesInWindow] of string[80];
      maxlines,
      lastx,lasty : byte;
     end;

var  glGotoXYProc : GotoXYProc;
     glWriteProc  : WriteProc;
     window       : array[1..MaxWindows] of WinRecPtr;

procedure SetGotoXYProc(NewProc : GotoXYProc);
begin
 glGotoXYProc:=NewProc;
end;

procedure SetWriteProc(NewProc : WriteProc);
begin
 glWriteProc:=NewProc;
end;

function pkInitWindow(nr : byte; Init : InitRecord) : boolean;
var i : longint;

procedure clearrec(var WinRec : WinRecPtr);
var i : longint;
begin
   with winrec^ do
   begin
    for i:=1 to MaxLinesInWindow do begin
                                     startx[i]     := 0;
                                     starty[i]     := 0;
                                     maxchars[i]   := 0;
                                     windowline[i] := '';
                                    end;
    maxlines := 0;
    lastx    := 0;
    lasty    := 0;
   end;
end;

begin
 pkInitWindow:=false;
 if window[nr] <> Nil then exit;
 GetMemCheck(window[nr],SizeOf(WindowRecord));
 clearrec(window[nr]);

 with window[nr]^ do
 begin
  for i:=1 to MaxLinesInWindow do
  begin
   startx[i]:=init.startx[i];
   starty[i]:=init.starty[i];
   maxchars[i]:=init.maxchars[i];
  end;
  maxlines:=init.maxlines;
  lastx:=1;
  lasty:=0;
 end;

 pkInitWindow:=true;
end;

function pkDoneWindow(nr : byte) : boolean;
begin
 pkDoneWindow:=false;
 if window[nr] = Nil then exit
 else FreeMemCheck(window[nr],SizeOf(WindowRecord));
 pkDoneWindow:=true;
end;

function  pkGetLastPos(nr : byte; var lastx,lasty : byte) : boolean;
begin
 pkGetLastPos:=false;
 if window[nr]=Nil then exit;
 lastx:=window[nr]^.lastx;
 lasty:=window[nr]^.lasty;
 pkGetLastPos:=false;
end;

function pkWindowActive(nr : byte): boolean;
begin
 pkWindowActive:=false;
 if nr > maxwindows then exit;
 if window[nr]=Nil then exit;
 pkWindowActive:=true;
end;

procedure WordWrap(var curline,output : string; cutoff : byte);
var i,lastspace : word;

begin
 lastspace:=0;
 for i:=1 to length(curline) do if curline[i]=' ' then lastspace:=i;
 if lastspace=0 then lastspace:=cutoff;
 output:=copy(curline,lastspace+1,length(curline));
 delete(curline,lastspace+1,length(curline));
end;

function pkWindowPutChar(nr : byte; ch : char) : boolean;

function Dup(Ch: Char; Nr: byte) : string;
var s: string;
begin
 FillChar(s,sizeOf(s),ch);
 s[0] := chr(nr);
 dup := s;
end;

var   tmp    : string[80];
      i      : byte;

begin
 pkWindowPutChar:=false;
 if window[nr]=Nil then exit;

 glGotoXYProc(window[nr]^.starty[window[nr]^.lastx]+window[nr]^.lasty,
              window[nr]^.startx[window[nr]^.lastx]);

 case ch of
  #13 : begin
         if window[nr]^.lastx=window[nr]^.maxlines then
         begin
          window[nr]^.lastx:=1;
          window[nr]^.lasty:=0;
          for i:=1 to window[nr]^.maxlines do
          begin
           window[nr]^.windowline[i]:='';
           glGotoXYProc(window[nr]^.starty[i],window[nr]^.startx[i]);
           glWriteProc(dup(' ',77));
          end;
          glGotoXYProc(window[nr]^.starty[1],window[nr]^.startx[1]);
         end
         else
         begin
          inc(window[nr]^.lastx);
          window[nr]^.lasty:=0;

          glGotoXYProc(window[nr]^.starty[window[nr]^.lastx],
                       window[nr]^.startx[window[nr]^.lastx]);
         end;
        end;
  #8  : begin
         if window[nr]^.lasty > 0 then
          begin
           glWriteProc(#8+#32+#8);
           delete(window[nr]^.windowline[window[nr]^.lastx],
                  length(window[nr]^.windowline[window[nr]^.lastx])-1,1);
           dec(window[nr]^.lasty);
          end
          else if window[nr]^.lastx > 1 then
          begin
           dec(window[nr]^.lastx);
           window[nr]^.lasty:=length(window[nr]^.windowline[window[nr]^.lastx]);
           glGotoXYProc(window[nr]^.starty[window[nr]^.lastx]
                        +window[nr]^.lasty,
                        window[nr]^.startx[window[nr]^.lastx]);

           glWriteProc(#8+#32+#8);
           delete(window[nr]^.windowline[window[nr]^.lastx],
                  length(window[nr]^.windowline[window[nr]^.lastx])-1,1);
           dec(window[nr]^.lasty);
          end;
        end;
   else begin
         if length(window[nr]^.windowline[window[nr]^.lastx]) <
                   window[nr]^.maxchars[window[nr]^.lastx] then
         begin
          window[nr]^.windowline[window[nr]^.lastx]:=
                      window[nr]^.windowline[window[nr]^.lastx]+ch;
          glWriteProc(ch);
          inc(window[nr]^.lasty);
         end
         else if (length(window[nr]^.windowline[window[nr]^.lastx]) =
                 window[nr]^.maxchars[window[nr]^.lastx]) and
                 (window[nr]^.lastx < window[nr]^.maxlines) then
         begin
          wordwrap(window[nr]^.windowline[window[nr]^.lastx],tmp,
                   window[nr]^.maxchars[window[nr]^.lastx]);
          glGotoXYProc(window[nr]^.starty[window[nr]^.lastx],
                       window[nr]^.startx[window[nr]^.lastx]);
          glWriteProc(window[nr]^.windowline[window[nr]^.lastx]);

          for i:=1 to window[nr]^.maxchars[window[nr]^.lastx]-
              length(window[nr]^.windowline[window[nr]^.lastx]) do
              glWriteProc(' ');

          inc(window[nr]^.lastx);
          window[nr]^.windowline[window[nr]^.lastx]:=tmp+ch;

          glGotoXYProc(window[nr]^.starty[window[nr]^.lastx],
                       window[nr]^.startx[window[nr]^.lastx]);

          glWriteProc(window[nr]^.windowline[window[nr]^.lastx]);
          window[nr]^.lasty:=length(window[nr]^.windowline[window[nr]^.lastx]);
         end
        else
        begin
         wordwrap(window[nr]^.windowline[window[nr]^.lastx],tmp,
                  window[nr]^.maxchars[window[nr]^.lastx]);
         for i:=1 to window[nr]^.maxlines do
         begin
          window[nr]^.windowline[i]:='';
          glGotoXYProc(window[nr]^.starty[i],window[nr]^.startx[i]);
          glWriteProc(dup(' ',77));
         end;
         tmp:=tmp+ch;
         window[nr]^.lastx:=1;
         window[nr]^.lasty:=length(tmp);
         glGotoXYProc(window[nr]^.starty[1],window[nr]^.startx[1]);
         window[nr]^.windowline[1]:=tmp;
         glWriteProc(tmp);
        end;
        end;
  end;
 pkWindowPutChar:=true;
end;

begin
 glGotoXYProc := Nil;
 glWriteProc  := Nil;
end.