Program DoCount;

{$S 65520 }

Uses
      Crt, Dos, TFile, Misc;

Type
      DownloadCounter = Record
                    FileName  : String[12];
      End;

      Temp            = Record
                    ConfNumber: Byte;
                    ConfPath  : String[70];
                    FileName  : String[12];
      End;

      Index           = Record
                    FileName  : String[12];
                    FilePos   : LongInt;
      End;

Var
      PceDir, UpDoLog, CounterFile           : String[80];
      LogPath                                : String[80];
      ZeroCounter                            : LongInt;
      cFiles,Zaehler                         : LongInt;
      Count,Endf                             : Boolean;
      Zeile, CountConfNumber                 : String;
      FileList,FileListTmp                   : Text;
      ConfPath                               : String[80];
      FileListe                              : Integer;
      Idxf                                   : File of Index;
      Idxr                                   : Index;
      LineNumber                             : LongInt;
      Tmpf                                   : File of Temp;
      Tmpr                                   : Temp;
      dcf                                    : File of DownloadCounter;
      dcr                                    : DownloadCounter;
      Node                                   : String[1];
      MsgBuf                                 : Array[1..30000] of Char;
      MsgBuf2                                : Array[1..30000] of Char;

{---------------------------------------------------------------------------------}

Function FindConf( f : String ) :Byte;
Type  ConRec = Record
                  ConfName      : String[16];
                  ConfPath      : String[66];
                  ConfFiles     : Array[1..9] of String[66];
                  ConfFHigh     : Integer;
                  ConfFreeDown  : Boolean;
                  ConfFileArea  : Boolean;
                  ConfMsgArea   : Boolean;
                  ConfNetMail   : Boolean;
                  CdRom         : Array[1..9] of Boolean;
                  ConfPwd       : String[15];
      End;
Var
  cf            : File of ConRec;
  cr            : ConRec;
  x,y,r         : Byte;
  Found         : Boolean;

Const MaxConf=200;
  Begin
    FileMode:=64;
    Assign(cf,PceDir+'CONFER.CFG');
    r:=0;
    Repeat
      {$I-}
      Reset(cf);
      {$I+}
      Inc(r);
    Until (IOResult=0) or (r>40);
    ConfPath:='';
    FileListe:=0;
    FindConf:=0;
    Found:=False;
    x:=0;
    Repeat
      Inc(x);
      Read(cf,cr);
      If cr.ConfName<>'' then Begin
        y:=10;
        Repeat
          Dec(y);
          If fExist(cr.ConfFiles[y]+f) then Begin
            If cr.cdrom[y] then ConfPath:=cr.ConfPath
                           Else ConfPath:=cr.ConfFiles[y];
            Found:=True;
          End;
        Until (y=1) or (Found);
      End;
    Until (MaxConf=x) or (Found);
    If Found then Begin
      FindConf:=x;
      FileListe:=y;
    End;
    {$I-}
    Close(cf);
    {$I+}
  End;

{---------------------------------------------------------------------------------}

Function Parse(X : String) : String;
Var  n           : Byte;
  Begin
    Repeat
      n:=Pos('@X',x);
      If n<>0 then Delete(x,n,4);
    Until n=0;
    Parse:=x;
  End;

{---------------------------------------------------------------------------------}

Procedure CheckLine;
Var p            : String;
    FileCounter  : LongInt;
    Color        : String[4];
    Tmpfs,fs     : LongInt;
  Begin

    If Zeile[1]<>' ' then If (Zeile[1]<>'.')  then Begin
      Count:=False;
      If not endf then Begin
        Reset(tmpf);
        Repeat
          Read(tmpf,tmpr);
          If ConfPath=tmpr.ConfPath then If tmpr.Filename<>'' then
            If Copy(Zeile,1,Length(tmpr.FileName)+1)=tmpr.FileName+' ' Then Begin
              {$I-}
              tmpfs:=FilePos(tmpf);
              fs:=FileSize(tmpf);
              If FileSize(tmpf)>1 then Begin
                Seek(tmpf,fs-1);
                Read(tmpf,tmpr);

                Seek(tmpf,tmpfs-1);
                Write(tmpf,tmpr);

                Seek(tmpf,fs-1);
                Truncate(tmpf);
                Reset(tmpf);
              End Else Begin
                Rewrite(tmpf);
                Endf:=True;
              End;
              {$I+}
              tmpr.Filename:='';
              If IOResult<>0 then WriteLn('Fehler bei Seek!');
              Count:=True;
              Write('_');
            End;
        Until (Eof(tmpf)) or (Count);
      End;
    End;
    If Count then Begin
      p:=Upper(Parse(Zeile));
      If Pos('[DL:',p)=2 then Begin
        FileCounter:=StrInt(Trim(Copy(p,7,Pos(']',p)-7)));
        Inc(FileCounter);
        Color:='';
        If Copy(Zeile,2,2)='@X' then Color:=Copy(Zeile,2,4);
        WriteLn(FileListTmp,' ',Color+'[DL: '+dZero(FileCounter,ZeroCounter)+']'+Copy(Zeile,Pos(']',Zeile)+1,255));
        Count:=False;
        Write(chr(8)+'');
      End Else WriteLn(FileListTmp,Zeile);
    End Else Begin
      WriteLn(FileListTmp,Zeile);
    End;
  End;

{---------------------------------------------------------------------------------}

Function ReadDir : Boolean;
Var fs         : LongInt;
    cok        : Boolean;
    IOR        : Integer;

  Begin

    cok:=False;
    fs:=fSize(tmpr.ConfPath+'.TXT');
    SetFileMode(readWriteMode,denyNone,inherit);
    AssignFile(Filelist,tmpr.ConfPath+'.TXT');
    {$i-}
    Reset(filelist);
    SetTextBuf(filelist,msgbuf);
    {$i+}
    If IOResult<>0 then Begin
      WriteLn('  Can''t open : '+tmpr.ConfPath+'.TXT');
      Exit;
    End;

    SetFileMode(readWriteMode,denyNone,inherit);
    AssignFile(Filelisttmp,tmpr.ConfPath+'.TMP');
    {$i-}
    Rewrite(filelisttmp);
    SetTextBuf(filelisttmp,msgbuf2);
    {$i+}


    If IOResult<>0 then Begin
      WriteLn('  Can''t open : '+tmpr.ConfPath+'.TMP');
      Exit;
    End;



    Count:=False;
    ConfPath:=tmpr.ConfPath;
    While not eof(filelist) do Begin
      ReadLn(FileList,Zeile);
      CheckLine
    End;

    Close(FileListTmp);
    Close(FileList);

    (* Falls sich das DIR in der Zwischenzeit gendert hat dann stop!!! *)
    If fs=fSize(ConfPath+'.TXT') then Begin
      fErase(ConfPath+'.TXT');
      {$I-}
      Rename(FileListTmp,ConfPath+'.TXT');
      {$I+}
      If IOResult=0 then cok:=True;
    End;
    ReadDir:=cok;
  End;

{---------------------------------------------------------------------------------}

Begin
  WriteLn;
  TextColor(Cyan);
  WriteLn(' DownLoad Counter ۲ v.1.03 (c) Febr. ''95 by MuHaDiB of AylA-BBs');
  NormVideo;
  WriteLn;
  If (ParamCount<1) or (Pos('?',ParamStr(1))<>0) then Begin
    TextColor(Cyan);
    WriteLn('  Uses   : DoCount.Exe <NodeNumber> <CounterChars> <not at Conf>');
    WriteLn;
    WriteLn('  Example: DoCount.Exe 1 3 3,5,7');
    WriteLn('           DoCount.Exe 1 4 12,110,15,19,20,21');
    WriteLn;
    NormVideo;
    Halt;
  End;
  PceDir:=GEnv('PCEXPRESS');
  Node:=ParamStr(1);
  LogPath:=GEnv('LOG');

  If LogPath='\' then LogPath:=PceDir;
  LogPath:=LogPath+'DOCOUNT'+Node+'.LOG';
  CounterFile:=PceDir+'DOCOUNT'+Node+'.DAT';
  ZeroCounter:=StrInt(ParamStr(2));  (* Anzahl der Stellen fuer den FileCounter *)
  CountConfNumber:=ParamStr(3); (* Conferncen die nicht abgearbeitet werden sollen! *)
  CountConfNumber:=','+CountConfNumber+',';
  If ZeroCounter>10 then ZeroCounter:=10;
  If ZeroCounter=0 then ZeroCounter:=3;
  FileMode:=2;
  Assign(dcf,CounterFile);
  Assign(tmpf,'DoCount'+node+'.$$$');
  {$I-}
  Rewrite(tmpf);
  {$I+}
  If IOResult<>0 then Halt;




  If (fExist(CounterFile)) and (fSize(CounterFile)>0) then Begin
    Reset (dcf);
    WriteLn;
    CurAus;
    TextColor(Cyan);
    Write(' Indexing  : ');
    cFiles:=0;
    Endf:=False;
    While not eof(dcf) do Begin

      Read(dcf,dcr);
      If dcr.FileName<>'' then Begin
        Inc(cFiles);
        tmpr.ConfNumber:=FindConf(dcr.FileName);
        tmpr.ConfPath  :=(ConfPath+'DIR'+IntStr(FileListe));
        tmpr.FileName  :=dcr.FileName;
        If (tmpr.ConfNumber<>0) and (FileListe<>0) and (Pos(','+IntStr(tmpr.ConfNumber)+',',CountConfNumber)<>0)
          Then  Dec(cFiles) else Begin
          Write('');
          Write(tmpf,tmpr);
        End;
      End;
    End;
    Close(dcf);


    Reset(tmpf);

    WriteLn;
    Write(' Read/Write: ');
    zaehler:=0;
    While not eof(tmpf) do Begin
      Inc(zaehler);
      Read(tmpf,tmpr);
      If tmpr.ConfPath<>'' then Begin
        ConfPath:=tmpr.ConfPath;
        ReadDir;
        Reset(tmpf);
      End;
      If zaehler+1>=cfiles then Rewrite(tmpf);
    End;
    Close(tmpf);
    WriteLn;
  End;
  fErase(PceDir+'DOCOUNT'+Node+'.DAT');
  fErase('DoCount'+node+'.$$$');
  CurEin;
End.

