; CHAOSE Menu System Library
; (c) 1996 BM&TMD!
 
DECLARE PROCEDURE MENUSYSTEM(VAR INT LINE, VAR INT COLUMN)     

; The procedure which calls the interface and executes the command chosen...

DECLARE PROCEDURE LIGHTBARINTERFACE(VAR INT LINE, VAR INT COLUMN)

; The interface procedure. Initiates the loop and refreshes the display
; until the user presses the enter key

DECLARE PROCEDURE SCANKEYS(VAR INT LINE, VAR BOOLEAN DECIDED, VAR INT COLUMN)

; The procedure which reads the keyboard and acts consecuently, calling the
; corresponding procedures.

DECLARE PROCEDURE MOVEUP(VAR INT LINE, VAR INT COLUMN)
DECLARE PROCEDURE MOVEDOWN(VAR INT LINE, VAR INT COLUMN)
DECLARE PROCEDURE MOVELEFT(VAR INT LINE, VAR INT COLUMN)
DECLARE PROCEDURE MOVERIGHT(VAR INT LINE, VAR INT COLUMN)

; These four are obvious, aren't they?

;-----------------------------------------------------------------


PROCEDURE MENUSYSTEM(VAR INT LINE, VAR INT COLUMN)

INT A,B,C                       ; Three dummy vars, for use in FORs and so...
STRING  COMMFILE                ; Command definition files. 

A=RANDOM(READLINE(PPEPATH()+PPENAME()+".CFG",1))        

; This gives A a random value between the number of display files available.

IF (A=0) A=1

; The RANDOM() proc generates a number between 0 and the nimber specified.
; As there can't be a line number 0 in a file, if the program has to
; display the file 0 of the displays, it just puts a black screen, which
; isn't very cute...


CLS                     ; Clears the screen.

DISPFILE (READLINE(PPEPATH()+PPENAME()+".DSP",A)),0     ; Shows the display
LIGHTBARINTERFACE(LINE, COLUMN)                         ; Calls the interface
IF (COLUMN=1) COMMFILE="COMM1"
IF (COLUMN=2) COMMFILE="COMM2"
IF (COLUMN=3) COMMFILE="COMM3"
IF (COLUMN=4) COMMFILE="COMM4"

; These four refresh the column in use, to update the commands available.

COMMAND 1, (READLINE(PPEPATH()+COMMFILE,LINE))  ; This executes the command
                                                ; chosen by the user.

MENUSYSTEM(LINE, COLUMN)                        ; And the mess starts again.

ENDPROC

;-----------------------------------------------------------------

PROCEDURE LIGHTBARINTERFACE(VAR INT LINE, VAR INT COLUMN)

; Variables

INT     A,B,C           ; DUMMYVARS!!!
STRING  OPTIONS(6)      ; Menu options
INT     XSTART          ; X start position of the options
INT     YSTART          ; Y start position of the options
STRING  COLOROP         ; Options' colour when unselected
STRING  COLORBAR        ; Explanation bar colour
STRING  COLORHI         ; Options' highlighted colour
STRING  USERKEY         ; Just a dummy var to store the user input
BOOLEAN DECIDED         ; A boolean to know if the user has pressed ENTER
STRING  COLFILE         ; The column file in use

; Init Variables

WHILE (DECIDED!="TRUE") DO

; While the user hasn't pressed the enter key, repeat this loop

XSTART=READLINE(PPEPATH()+PPENAME()+".CFG",2) 
YSTART=READLINE(PPEPATH()+PPENAME()+".CFG",3)
COLOROP=READLINE(PPEPATH()+PPENAME()+".CFG",4)
COLORBAR=READLINE(PPEPATH()+PPENAME()+".CFG",5)
COLORHI=READLINE(PPEPATH()+PPENAME()+".CFG",6)
DECIDED=FALSE

; Initiatilzes the variables reading the cfg file and setting the boolean to
; false

IF (COLUMN=1) COLFILE="COLUMN1"
IF (COLUMN=2) COLFILE="COLUMN2"
IF (COLUMN=3) COLFILE="COLUMN3"
IF (COLUMN=4) COLFILE="COLUMN4"

; State the column file in use. Messy but necessary

ANSIPOS 1,1
PRINT (READLINE(PPEPATH()+PPENAME()+".COL",COLUMN))

; Prints the menu bar on top of the screen.

FOR A=1 TO 6

        OPTIONS(A)=READLINE(PPEPATH()+COLFILE,A)

NEXT A

; Stores the options of the menu in the options array

FOR A=0 TO 5
        ANSIPOS XSTART,YSTART+A
        PRINT "               "
        ANSIPOS XSTART,YSTART+A
        PRINT COLOROP+OPTIONS(A+1)
NEXT A

; Prints the options in their box.


ANSIPOS XSTART,YSTART+LINE-1
PRINT COLORHI+OPTIONS(LINE)

; Prints the highlighted option.

        ANSIPOS 1,20
        CLREOL
        PRINT COLORBAR+(READLINE(PPEPATH()+COLFILE+".EXP",LINE))

; Prints the explanation bar.

SCANKEYS(LINE, DECIDED, COLUMN)

; Calls the keyboard scanning procedure.

ENDWHILE
 
ENDPROC
 
 
;-----------------------------------------------------------------

PROCEDURE SCANKEYS(VAR INT LINE, VAR BOOLEAN DECIDED, VAR INT COLUMN)

STRING  USERKEY         ; The user input key. I think it isn't needed above,
                        ; but I'll leave it there, as I don't want now to
                        ; trace the code and really see if it is useful


WHILE (USERKEY<CHR(13)) DO

; While the user doesn't press the enter key do:

USERKEY=INKEY()                 ; Read the keyboard
 
IF ((USERKEY="DOWN")|(USERKEY="2")) MOVEDOWN(LINE, COLUMN)
IF ((USERKEY="UP")|(USERKEY="8")) MOVEUP(LINE, COLUMN)
IF ((USERKEY="LEFT")|(USERKEY="4")) MOVELEFT(LINE, COLUMN)
IF ((USERKEY="RIGHT")|(USERKEY="6")) MOVERIGHT(LINE, COLUMN)

; If the user presses any cursor keys, go to the corresponding proc.

IF (USERKEY=CHR(13)) DECIDED=TRUE       ; If the user presses enter, exit.

ENDWHILE

ENDPROC
 

;-----------------------------------------------------------------
 
PROCEDURE MOVEDOWN(VAR INT LINE, VAR INT COLUMN)
 
STRING  COLORBAR        ; Explanation bar colour
STRING  COLFILE         ; Column file in use

COLORBAR=READLINE(PPEPATH()+PPENAME()+".CFG",5)         ; Initialize COLORBAR

IF (COLUMN=1) COLFILE="COLUMN1"
IF (COLUMN=2) COLFILE="COLUMN2"
IF (COLUMN=3) COLFILE="COLUMN3"
IF (COLUMN=4) COLFILE="COLUMN4"

; Get the column file to use.

IF (LINE<6) THEN
        LINE=LINE+1
        ANSIPOS 1,20
        CLREOL
        PRINT COLORBAR+(READLINE(PPEPATH()+COLFILE+".EXP",LINE))

; if the line is lower than six, it increases in one, and updates the
; explanation bar.

ELSE
        LINE=1
        ANSIPOS 1,20
        CLREOL
        PRINT COLORBAR+(READLINE(PPEPATH()+COLFILE+".EXP",LINE))

; If it is six or more (impossible, by the way), it is set to one and the
; explanation bar is equally updated.

ENDIF

ENDPROC
 

;-----------------------------------------------------------------

PROCEDURE MOVEUP(VAR INT LINE, VAR INT COLUMN)

STRING  COLORBAR        ; Explanation bar colour
STRING  COLFILE         ; Column file in use

COLORBAR=READLINE(PPEPATH()+PPENAME()+".CFG",5)         ; Initialize COLORBAR

IF (COLUMN=1) COLFILE="COLUMN1"
IF (COLUMN=2) COLFILE="COLUMN2"
IF (COLUMN=3) COLFILE="COLUMN3"
IF (COLUMN=4) COLFILE="COLUMN4"

; Get the column file to use.


IF (LINE>1) THEN
        LINE=LINE-1
        ANSIPOS 1,20
        CLREOL
        PRINT COLORBAR+(READLINE(PPEPATH()+COLFILE+".EXP",LINE))

; If the line is greater than one, it decreaeses in one and updates the
; explanation bar

ELSE

LINE=6
        ANSIPOS 1,20
        CLREOL
        PRINT COLORBAR+(READLINE(PPEPATH()+COLFILE+".EXP",LINE))

; Else it is set to one, and the explanation bar is updated too.

ENDIF

ENDPROC
 

;-----------------------------------------------------------------

PROCEDURE MOVELEFT(VAR INT LINE, VAR INT COLUMN)

IF (COLUMN>1) THEN
        COLUMN=COLUMN-1

; If the column is greater than one, it is decreased in one...

ELSE


COLUMN=4

; Else it is set to four

ENDIF

ENDPROC
 
 
;-----------------------------------------------------------------

PROCEDURE MOVERIGHT(VAR INT LINE, VAR INT COLUMN)
 
IF (COLUMN<4) THEN
        COLUMN=COLUMN+1

; If the column is lower than four, it increases in one.

ELSE

COLUMN=1

; Else it is set to one.

ENDIF

ENDPROC


;----------------------------------------------------------------------
