
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Doors Engine Example Program                    }
{                                                       }
{       Copyright (c) 1995 by Solar Designer            }
{                                                       }
{*******************************************************}

{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V+,X+}
{$M 1024,4000,4000}
program Door;

uses
   DOS,
   InitPort, Fossil, SendANSI;

procedure Last16; assembler;
asm
   dd   0
   dw   0
end;

procedure Int16; assembler;
asm
   cmp  byte ptr cs:Last16+6,0
   jz   @@JmpLast

   or   ah,ah
   jnz  @@Fn1

   mov  byte ptr cs:Last16+6,0

   push ds
   push es
   pusha
   push seg @DATA
   pop  ds

   call GetEvent
   mov  word ptr cs:Last16+4,ax

   popa
   pop  es
   pop  ds
   mov  ax,word ptr cs:Last16+4

   not  byte ptr cs:Last16+6
   iret

@@Fn1:
   cmp  ah,1
   jne  @@JmpLast

   pushf
   call dword ptr cs:Last16
   jnz  @@DoneFn1

   push ds
   push es
   pusha
   push seg @DATA
   pop  ds

   cmp  LocalMode,0
   jnz  @@SkipRemote

   push seg Port
   push offset Port
   call TFossilPort.CharAvail
   or   al,al
   jnz  @@DoneRemote

   call UpdateSendANSI

@@SkipRemote:
   xor  ax,ax

@@DoneRemote:
   popa
   pop  es
   pop  ds

@@DoneFn1:
   retf 2

@@JmpLast:
   jmp  dword ptr cs:Last16
end;

begin
   if ParamCount<2 then
      Abort(#1'Specify program name on the command line (second parameter)'#13#10'$');

   TimeLimit:=30*(182*6)-1;

   GetIntVec($16, Pointer(@Last16^));
   SetIntVec($16, @Int16);

   SwapVectors;
   Exec(GetEnv('COMSPEC'), '/C '+ParamStr(2));
   SwapVectors;

   SetIntVec($16, Pointer(@Last16^));
end.
