/* prm19.h								*/
/*----------------------------------------------------------------------*/
/*									*/
/*               The Opus Computer-Based Conversation System		*/
/*    (c) Copyright 1986-1992, Wynn Wagner III, All Rights Reserved	*/
/*									*/
/*									*/
/*                   YOOHOO is a trademark of Wynn Wagner III		*/
/*									*/
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are			*/
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved	*/
/*									*/
/*									*/
/* This material is available for use by anybody with no strings and	*/
/* no guarantees.							*/
/*									*/
/*									*/
/*----------------------------------------------------------------------*/
/*									*/
/* OPUS 1.80 .prm file structures.					*/
/* Copyright 1991-1992 Wynn Wagner III, Doug Boone and John Valentyn.	*/
/*									*/
/*----------------------------------------------------------------------*/

#define  THIS_CTL_VERSION  18	/* PRM structure version number		*/

#if   COMPILER
#	define CTLSIZE 0x7fff	/* Only used when compiling OPUS_CTL	*/
#	define OFS     int
#elif UTILS
#	define CTLSIZE 1	/* Only used when compiling Utilities	*/
#	define OFS     int
#else
#	define CTLSIZE 1
#	define OFS     char*
#endif


#define MAX_EXTERN	16	/* max. number of external programs     */
#define MAXCLASS	12	/* number of possible priv levels       */
#define ALIAS_CNT	15	/* number of matrix addresses           */

#define MAX_LANG	12	/* max no of languages supported (v 18) */
#define MAX_A_BITS	16	/* message attribute priv bits */
#define MAX_FOSREGS	10	/* total # of F-key fossil definitions */
#define MAX_FDIAL	4	/* total # of special dial strings */
#define MAX_TASK_NO	16	/* max # of tasks supported */
 
#define MAX_Name	16	/* max length for area name */
#define MAX_Tag		16	/* max length for echo tag */
#define MAX_addr	26	/* max string length to hold 4d address */
#define MAX_Text	79	/* max length for misc[80] strings */
#define MPATH		59	/* max path[60] supported by Opus */
#define MAX_SysPath	39	/* max path len for file + msg areas */
#define MAX_Sname	49	/* max system[50] name and origin line */
#define MAX_Sysop	35	/* max sysop[36] name */
#define MAX_Lang	60	/* max len for language name */
#define MAX_domain	29	/* max len for domain[30] names */
#define MAX_appl	512	/* max len of application strings */
#define MAX_area_no	32767	/* highest valid area number */

#define MAXPATH		80	/* max DOS path */
#define MAXDIR		66	/* max DOS directory */
#define MAX_STACK	10	/* stack level for ^ox ^oy */
 
#define  _TWIT		0x10
#define  _DISGRACE	0x30
#define  _LIMITED	0x40
#define  _NORMAL	0x50
#define  _WORTHY	0x60
#define  _PRIVEL	0x70
#define  _FAVORED	0x80
#define  _EXTRA		0x90
#define  _CLERK		0xA0
#define  _ASSTSYSOP	0xB0
#define  _SYSOP		0xD0
#define  _HIDDEN	0xE0

#define  Twit		_TWIT
#define  Disgrace	_DISGRACE
#define  Limited	_LIMITED
#define  Normal		_NORMAL
#define  Worthy		_WORTHY
#define  Privil		_PRIVEL
#define  Favored	_FAVORED
#define  Extra		_EXTRA
#define  Clerk		_CLERK
#define  AsstSysop	_ASSTSYSOP
#define  Sysop		_SYSOP
#define  Hidden		_HIDDEN



struct   class_rec
{
	BYTE  ClassPriv;
	BYTE  class_fill;
	int   max_time;      /* max cume time per day         */
	int   max_call;      /* max time for one call         */
	WORD  max_dl;        /* max dl bytes per day          */
	BYTE  ratio_down;
	BYTE  ratio_up;
	WORD  min_baud;      /* speed needed for logon        */
	WORD  min_file_baud; /* speed needed for file xfer    */
};

struct _FOSREGS
{
	WORD  ax;
	WORD  bx;
	WORD  cx;
	WORD  dx;
};


/*--------------------------------------------------------------------------*/
/* The format of the PRM file, VERSION 18                                   */
/*                                                                          */
/* THIS IS AN EXPLOSIVE STRUCTURE.  IT IS SUBJECT TO CHANGE WITH NO NOTICE. */
/*                                                                          */
/* Offsets to the following item(s) are guaranteed:                         */
/*                                                                          */
/*      BYTE   version;           OFFSET 0, all versions                    */
/*      BYTE   task_num;          OFFSET 1, 16+                             */
/*                                                                          */
/*--------------------------------------------------------------------------*/
struct _PRM
{
	/*-----------------------------------------------------------*/
	/* DATA                                                      */
	/*-----------------------------------------------------------*/
	BYTE  version;        /* for safety                          STABLE*/
	BYTE  task_num;       /* for multi-tasking systems           STABLE*/
	ADDR  alias[ALIAS_CNT];

	BYTE  video;          /* 0=Dos, 1=Fossil 2=IBM                     */
	BYTE  testmode;       /* input from keyboard, not modem            */

	WORD  carrier_mask;
	WORD  handshake_mask;
	WORD  max_baud;       /* fastest speed we can use                  */
	WORD  com_port;       /* Com1=0, Com2=1, FF=keyboard               */

	BYTE  multitasker;    /* flag for which multitasker (see opus.h) */
	BYTE  mailer_type;    /* 0=Opus, 1=load external, 2=call external  */

	BYTE  ModemFlag;      /* (See MODEM FLAG below)                    */
	BYTE  LogFlag;        /* (See LOG FLAG below)                      */

	BYTE  StyleFlag;      /* (See STYLE FLAG below)                    */
	BYTE  FWDflag;        /* Bits to control IN TRANSIT messages       */

	BYTE  Flags;          /* See "FLAGS" below                         */
	BYTE  Flags2;         /* See "FLAGS 2" below                       */

	BYTE  edit_exit;      /* ERRORLEVEL to use if Matrix area changed  */
	BYTE  exit_val;       /* ERRORLEVEL to use after caller            */

	BYTE  crashexit;      /* non-zero= ErrorLevel exit                 */
	BYTE  arc_exit;       /* ErrorLevel for after incomming ARCmail    */

	BYTE  echo_exit;      /* ERRORLEVEL for after inbound echomail     */
	BYTE  UDB_Flags;      /* User data base flags                      */

	WORD  min_baud;       /* minimum baud to get on-line               */
	WORD  color_baud;     /* min baud for graphics                     */
	WORD  date_style;     /* Used for FILES.BBS display                */

	BYTE  logon_priv;     /* Access level for new users                */
	BYTE  seenby_priv;    /* Min priv to see SEEN_BY line              */

	BYTE  ctla_priv;      /* Priv to see CONTROL-A lines in messages   */
	BYTE  Interline_Flags;  /* Flags relating to interline systems     */

	BYTE  AskPrivs[MAX_A_BITS];   /* Array of privs. for message attr ask's    */
	BYTE  AssumePrivs[MAX_A_BITS];	/* Array of privs for message attr assume's */

	WORD  logon_time;	/* time to give for logons */

	WORD  matrix_mask;	/* Z-window matrix behavior mask */

	WORD  MinNetBaud;	/* minimum baud rate for remote netmail */
	BYTE  exit_mailer;	/* Exit when mailer is running */
	BYTE  num_crashes;	/* Number of tries when sending crash */

	struct class_rec Class[MAXCLASS];
	struct _FOSREGS FosRegs[MAX_FOSREGS];

	WORD  F_Reward;       /* File upload time reward percentage        */
	WORD  last_area;      /* Highest msg area presumed to exist        */
	WORD  last_farea;     /* Highest file area presumed to exist       */

	BYTE  return_secure;  /* 0=ignore LASTUSER, >1 re-read LASTUSER    */

	/*  New for Version 17 */

	BYTE  xuflags;		/* ExtUser Flags: 1=Alias, 2=UserTel       */
	WORD  xlmin;		/* Lead mins for expiry warning            */
	char  xlday;		/* Lead days for expiry warning            */
	BYTE  expriv;		/* Expiry privilege                        */
	BYTE  totlang;		/* Total languages present (1-12)          */
	BYTE  sylno;		/* Def Sysop Language no.  (0-5)           */
	BYTE  uslno;		/* Def User Language no.   (0-5)           */
	BYTE  relog_exit;	/* Exit after -o relog                     */
	WORD  Scrn_Size;	/* Local monitor's size, high byte = len   */

	/* New for version 18 */

	WORD  default_expire_days;    	/* Number of days before new users  */
	WORD  default_expire_mins;    	/* Number of days before new users  */
	ULONG default_keys;	/* New user's default keys                  */
	ULONG default_section; 	/* New user's default section               */
	WORD  Point_Net;	/* My point net                             */
	WORD  Boss_Node;	/* My point net                             */
	BYTE  NoPwd_Priv;	/* Priv if you want to allow users without password */
	BYTE  Local_Exit;	/* Exit after local messages                */
	BYTE  Upload_Exit;	/* Exit after an upload for checking  */
	BYTE  ExtMail_Exit;	/* Exit for externmail                */
	BYTE  Max_Echo;		/* Longest echomail message to handle 3-60k */
	BYTE  WhoPriv;		/* Priv to see who uploaded a file          */

	ADDR  GUUCP;		/* Where to send gated UUCP messages       */
	ULONG making_section;	/* section to use while users make section */
	BYTE  ListSysop;	/* Privilege neeeded to see sysops in net list */
	BYTE  rawpriv;		/* Privilege needed to see/download files not listed */
	BYTE  uucp_priv;	/* Privilege needed to turn off uucp addresses */
	BYTE  Flags3;		/* More flags.                               */
	BYTE  Mail_Exit;	/* Exit after mail connect                   */
	BYTE  byte_fill;	/* RFU */
 
	/* new for version 19 */

	BYTE  file_ver;		/* version no for file database */
	BYTE  msg_ver;		/* version no for msg database */
	BYTE  tlt_ver;		/* version no for translation tables */
 
	BYTE  filler2;		/* RFU */
	/* color configuration selections */
	BYTE	c01;	/* Color Console Header */
	BYTE	c02;	/* Color Console Time */
	BYTE	c03;	/* Color Console Prompt */
	BYTE	c04;	/* Color Console Ptext */
	BYTE	c05;	/* Color Console Log */
	BYTE	c06;	/* Color Console Error */
	BYTE	c07;	/* Color Console Xstat */
	BYTE	c08;	/* Color Menu Header */
	BYTE	c09;	/* Color Menu Prompt */
	BYTE	c10;	/* Color Menu Ptext */
	BYTE	c11;	/* Color Menu Select */
	BYTE	c12;	/* Color Menu Stext */
	BYTE	c13;	/* Color Prompt More */
	BYTE	c14;	/* Color */
	BYTE	c15;	/* Color */
	BYTE	c16;	/* Color */
	BYTE	c17;	/* Color */
	BYTE	c18;	/* Color */
	BYTE	c19;	/* Color */
	BYTE	c20;	/* Color */
	BYTE	c21;	/* Color */
	BYTE	c22;	/* Color */
	BYTE	c23;	/* Color */
	BYTE	c24;	/* Color */
	BYTE	c25;	/* Color */
	BYTE	c26;	/* Color */
	BYTE	c27;	/* Color */
	BYTE	c28;	/* Color */
	BYTE	c29;	/* Color */
	BYTE	c30;	/* Color */
	BYTE	c31;	/* Color */
	BYTE	c32;	/* Color */



		/*-----------------------------------------------------------*/
		/* OFFSETS                                                   */
		/*-----------------------------------------------------------*/

			/*-------------------------------------------*/
			/* MODEM COMMAND STRINGS                     */
			/*-------------------------------------------*/
	OFS   MDM_Init;       /* modem initialization string               */
	OFS   MDM_PreDial;    /* modem dial command sent before number     */
	OFS   MDM_PostDial;   /* modem command sent after dialed number    */
	OFS   MDM_LookBusy;   /* mdm cmd to take modem off hook            */

			/*-------------------------------------------*/
			/* PRIMROSE PATHS                            */
			/*-------------------------------------------*/
	OFS   misc_path;      /* path to BBS/GBS files                     */
	OFS   sys_path;       /* path to SYSTEM?.BBS files                 */
	OFS   temppath;       /* place to put temporary files              */
	OFS   net_info;       /* path to NODELIST files                    */
	OFS   mailpath;       /* place to put received netmail bundles     */
	OFS   filepath;       /* place to put received netmail files       */
	OFS   hold_area;      /* path to pending outbound matrix traffic   */

			/*-------------------------------------------*/
			/* DATA FILE NAMES                           */
			/*-------------------------------------------*/
	OFS   user_file;      /* path/filename of User.Bbs                 */
	OFS   sched_name;     /* name of file with _sched array            */
	OFS   langdir;        /* Langauge file dir. (Was Syl in v16)       */
	OFS   spcldir;        /* Spcl Ann Text dir. (Was Usl in v16)       */

			/*-------------------------------------------*/
			/* MISCELLANEOUS TEXT                        */
			/*-------------------------------------------*/
	OFS   system_name;    /* board's name                              */
	OFS   sysop;          /* sysop's name                              */
	OFS   timeformat;
	OFS   dateformat;
	OFS   OFS_Filler1[8];	/* RFU */

			/*-------------------------------------------*/
			/* BBS/GBS SUPPORT FILES                     */
			/*-------------------------------------------*/
	OFS   logo;           /* first file shown to a caller              */
	OFS   welcome;        /* shown after logon                         */
	OFS   newuser1;		/* first file shown to new users */
	OFS   newuser2;		/* second file shown to new users */
	OFS   rookie;		/* special welcome for 'rookie' users */

	OFS   HLP_Editor;     /* Intro to msg editor for novices.          */
	OFS   HLP_Replace;    /* Explain the Msg.Editor E)dit command      */
	OFS   HLP_Inquire;    /* Explain the Msg. I)nquire command         */
	OFS   HLP_Locate;     /* Explain the Files L)ocate command         */
	OFS   HLP_Contents;   /* Explain the Files C)ontents command       */
	OFS   HLP_OPed;       /* help file for the full-screen editor      */
	OFS   OUT_Leaving;    /* Bon Voyage                                */
	OFS   OUT_Return;     /* Welcome back from O)utside                */
	OFS   ERR_DayLimit;   /* Sorry, you've been on too long...         */
	OFS   ERR_TimeWarn;   /* warning about forced hangup               */
	OFS   ERR_TooSlow;    /* explains minimum logon baud rate          */
	OFS   ERR_XferBaud;   /* explains minimum file transfer baud rate  */
	OFS   LIST_MsgAreas;  /* dump file... used instead of Dir.Bbs      */
	OFS   LIST_FileAreas; /* dump file... used instead of Dir.Bbs      */

	OFS   FREQ_MyFiles;   /* file to send when FILES is file requested */
	OFS   FREQ_OKList;    /* list of files approved for file requests  */
	OFS   FREQ_About;     /* File Request: ABOUT file                  */

	OFS   OEC_Quotes;	/* quotes shown by using imbedded commands */
	OFS   byebye;         /* file displayed at logoff                  */
	OFS   local_editor;   /* text editor to use in keyboard mode       */
	OFS   barricade;	/* file to show when entering barricaded area */
	OFS   STATUS_dir;     /* Where to find INMAIL/ACTIVE/LASTUSER      */
	OFS   mailer;         /* full external mailer command              */
	OFS   common;         /* File with data common to all tasks        */

	/*  New for Version 17 */
 
	OFS   xdwarn;         /* Date Warning OEC BBS                      */
	OFS   xtwarn;         /* Time Warning OEC BBS                      */
	OFS   xdexpd;         /* Expired due-to-Date OEC BBS               */
	OFS   xtexpd;         /* Expired due-to-Time used OEC BBS          */
	OFS   lang[MAX_LANG];	/* 12 Language File Root Name pointers     */
	OFS   badpath; 		/* Path for unrecognized echo names         */

	/*  New for version 18 */

	OFS   ConfHelp;		/* Help file for newuser configure          */
	OFS   Mainmenu;		/* ASCII menu at MAIN                       */
	OFS   Confmenu;		/* ASCII menu at Config                     */
	OFS   Sectmenu;		/* ASCII menu at Section menu               */
	OFS   Sysopmenu;	/* ASCII menu at Sysop menu                 */
	OFS   Echotoss;		/* Where to find EchoToss.Log               */
	OFS   MDM_Answer;	/* String to force autoanswer               */
	OFS   BAD_PWD;		/* File shown to users who've forgottent thiers */
	OFS   Charset;		/* File that contains character translation tables */
	OFS   DL_Log;		/* Who's downloaded what                    */
	OFS   UL_Log;		/* Who uploaded what                        */
	OFS   Name_Filter;	/* Old USERNAME.TXT                         */
	OFS   Bad_Name;		/* What to show user if filter catches them */
	OFS   CUSTOM1_menu;	/* What to show before CUSTOM1 menu         */
	OFS   CUSTOM2_menu;	/* What to show before CUSTOM2 menu         */
	OFS   CUSTOM3_menu;	/* What to show before CUSTOM3 menu         */
	OFS   CUSTOM4_menu;	/* What to show before CUSTOM4 menu         */
	OFS   CUSTOM5_menu;	/* What to show before CUSTOM5 menu         */
	OFS   CUSTOM6_menu;	/* What to show before CUSTOM6 menu         */
	OFS   EXT_mail_string;	/* What we see when UUCP is coming    */
	OFS   MaybeNew;		/* File shown if didn't find user name       */
	OFS   Histmenu;		/* ASCII menu at History                     */
	OFS   My_Question;	/* Sysop configured question             */
	OFS   HLP_make;		/* How to make a section                     */
	OFS   MDM_FDial[MAX_FDIAL];		/* Special dialing instructions          */
	OFS   Yell;		/* Yell OEC                                 */
	OFS   HLP_Macro;	/* Help for macro menu                       */
	OFS   UUCP_list;	/* Address list for UUCP                     */
	OFS   HLP_IChat;	/* Interline chat help                       */
	OFS   protocols[MAX_EXTERN]; /* external file protocol programs    */
/* new for v19 */
	OFS   secure_inbound;	/* secure filepath */

	OFS   OFS_Filler[6];

		/*-----------------------------------------------------------*/
		/* Log_Name must always be the last offset in this struct    */
		/* because Bbs_Init uses that symbol to flag the end of      */
		/* the offsets.                                              */
		/*-----------------------------------------------------------*/
	OFS   log_name;       /* name of the log file                      */


		/*-----------------------------------------------------------*/
		/* Big blob of stuff                                         */
		/* It's a sequence of null-terminated character arrays...    */
		/* pointed-to by the offsets (above).                        */
		/*-----------------------------------------------------------*/
	char  buf[CTLSIZE];
};

#define ASK_PHONE       0x01		/* Used with xuflags                  */
#define ASK_ALIAS       0x02		/* Used with xuflags                  */
#define ASK_REAL        0x04		/* Used with xuflags                  */
#define ASK_CITY        0x08		/* Used with xuflags                  */
#define CAN_ALIAS       0x10		/* Allow ALIAS' in some situations    */
#define ASK_BDAY        0x20		/* Ask user for birthday              */
#define ASK_ADDRESS     0x40		/* Ask user for street address        */

	/* Means no privilege level is set and/or applicable At LOGON,     */
	/* for example, it means system is for PRE-REGISTERED users only.  */
#define  NO_PRIV  0xFF

struct _common_data {

	char  Opus[16];		/* "OPUS-CBCS 1.80"		*/
	long  QuotePosition;	/* Quote file position		*/
	long  CallerCount;	/* Number of callers		*/
	ULONG Caller_ID;	/* ID of current newest user	*/
	long  MSG_ID;		/* Last used MSGID		*/
	WORD  FILLER[15];	/* RESERVED - do not use	*/
	WORD  MAX_task;		/* Highest task number		*/
};

/* Explanation of _common_data:

   Opus will EXPECT to find "OPUS-CBCS 1.80" at the beginning of this file.
   If it does not find it, Opus will assume the file belongs to someone
   else and will ignore the file.

   File ctl.common is optional. It should be used only by systems that
   multitask. Its purpose is to allow separate schedule files for each
   task. If the file does not exist, Last quote pointer and Caller count
   are read from and updated in the scheduler.

   On the other hand, if this file exists the quote pointer is only updated
   in this file. Caller Count is updated separately both in the scheduler
   and this file, to allow separate statistics for each task, plus total
   statistics.

   MAX_task is informative only and should be set by the sysop. Its purpose
   is to help external intertask programs figure out how many tasks there
   exist. Its purpose is defeated if task numbers are not consecutive.

   More data may be added in the future. If so, either the FILLER field
   will be used, or the data will be appended. Existing definitions will
   remain it their respective places. Any FILLER bytes will be set to 0.
									*/



/*----------------------------------------------------------------------*/
/* MATRIX_STATUS flags							*/
/*----------------------------------------------------------------------*/
#define MATRIX_CHANGED	0x0001	/* Changed matrix area. Scan		*/
#define LOCAL_CHANGED	0x0002	/* Changed Local area.			*/
#define GOT_BUNDLE	0x0100	/* Received a PKT file			*/
#define GOT_ARCMAIL	0x0200	/* Received an archived file		*/
#define GOT_REQUESTS	0x0400	/* Got file requests to handle		*/
#define GOT_ECHOMAIL	0x1000	/* Received Echomail			*/
#define	NOTHING_2_SEND	0x2000	/* nothing to send to this node		*/
#define GOT_NOTHING	0x4000	/* received nothing from this node	*/

/*----------------------------------------------------------------------*/
/* INTERLINE FLAGS							*/
/*----------------------------------------------------------------------*/
#define CAN_CHAT	0x01	/* Multiline systems can do chats	*/

/* prm19.h */
