/* opus.h                                                                   */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*               The Opus Computer-Based Conversation System                */
/*    (c) Copyright 1986-1992, Wynn Wagner III, All Rights Reserved         */
/*                                                                          */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are                     */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/* This material is available for use by anybody with no strings and        */
/* no guarantees.                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------*/
/* OPUS CONTROL DEFINITIONS                                                 */
/*--------------------------------------------------------------------------*/

#define MAXEXPAND 30          /* max download files (wildcard expansion)    */
#define CMDLEN    80          /* size of the command typeahead buffer       */
#define CARRYLEN  20          /* LORE editor's carry buffer                 */
#define MAXLEN    85          /* size of primary line-input buffer          */
#define MAX_USEC  80          /* Maximum number of areas in "user" section  */
 
/*--------------------------------------------------------------------------*/
/* LEGIBLE SECTION.  Definitions to make "C" look like Wynn's language.     */
/*--------------------------------------------------------------------------*/
#undef log

#ifndef begin
# define begin        {
# define end          }
# define true         (-1)
# define false        0
# define Procedure    void
# define SHL          <<
# define SHR          >>
# define XOR          ^
# define AND          &&
# define OR           ||
# define NOT          !
# define MOD          %
  typedef unsigned      bit;
  typedef unsigned short word;
  typedef unsigned char byte;
  typedef unsigned long ulong;
  typedef const char*   STRING;
# define fallthrough        /* ... for use in switch statements for clarity. */
#endif

#ifndef NEWdefs
typedef unsigned      BIT;
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long ULONG;
typedef BYTE far *FP;
# define NEWdefs
#endif

#ifndef max
#define max(a,b)     ((a)>(b)?(a):(b))
#endif

#ifndef min
#define min(a,b)     ((a)<=(b)?(a):(b))
#endif



/*--------------------------------------------------------------------------*/
/* TIME STAMP                                                               */
/*--------------------------------------------------------------------------*/
struct _stamp
   {
      WORD   date;
      WORD   time;
   };


/*--------------------------------------------------------------------------*/
/* FIDONET ADDRESS STRUCTURE                                                */
/*--------------------------------------------------------------------------*/
typedef struct _ADDRESS
   {
      int  Zone;
      int  Net;
      int  Node;
      int  Point;
   } ADDR;





/*--------------------------------------------------------------------------*/
/* NodeList.Sys                                                             */
/*                                                                          */
/*    NET > 0 and NODE > 0    Normal node                                   */
/*                                                                          */
/*    NET > 0 and NODE <= 0   Host node                                     */
/*                               Net host........node== 0                   */
/*                               Regional host...node==-1                   */
/*                               Country host....node==-2                   */
/*                                                                          */
/*    NET == -1      Nodelist.Sys revision                                  */
/*                                                                          */
/*    NET == -2      Nodelist statement                                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#define MAX_NL_Phone 39
#define MAX_NL_Pwd   8
#define MAX_NL_Bname 33
#define MAX_NL_Cname 29

/*--------------------------------------------------------------------------*/
/* THE VERSION 6 NODELIST                                                   */
/*--------------------------------------------------------------------------*/
struct _node
{
    int  NetNumber;
    int  NodeNumber;
    WORD MsgFee;		/* Amount charged to user for a message */
    BYTE SystemName[MAX_NL_Bname+1];	/* node name */
    BYTE PhoneNumber[MAX_NL_Phone+1];	/* phone number */
    BYTE MiscInfo[MAX_NL_Cname+1];	/* city and state */
    BYTE Password[MAX_NL_Pwd];		/* password */
				/* WARNING: not necessarily nul-terminated */
    WORD CallCost;		/* phone company's charge */
    WORD HubNode;		/* node # of this node's hub or 0 if none */
    BYTE BaudRate;		/* baud rate divided by 300 */
    BYTE ModemType;		/* modem type */
    WORD NodeFlags;		/* set of flags (see below) */
    WORD NodeFiller;		/* RESERVED for future use */
};


#define B_hub    0x0001  /* node is a net hub     0000 0000 0000 0001 */
#define B_host   0x0002  /* node is a net host    0000 0000 0000 0010 */
#define B_region 0x0004  /* node is region coord  0000 0000 0000 0100 */
#define B_zone   0x0008  /* is a zone gateway     0000 0000 0000 1000 */
#define B_CM     0x0010  /* runs continuous mail  0000 0000 0001 0000 */
#define B_res1   0x0020  /* reserved by Opus      0000 0000 0010 0000 */
#define B_res2   0x0040  /* reserved by Opus      0000 0000 0100 0000 */
#define B_res3   0x0080  /* reserved by Opus      0000 0000 1000 0000 */
#define B_res4   0x0100  /* reserved by Opus      0000 0001 0000 0000 */
#define B_res5   0x0200  /* reserved for non-Opus 0000 0010 0000 0000 */
#define B_res6   0x0400  /* reserved for non-Opus 0000 0100 0000 0000 */
#define B_res7   0x0800  /* reserved for non-Opus 0000 1000 0000 0000 */
#define B_point  0x1000  /* node is a point       0001 0000 0000 0000 */
#define B_res9   0x2000  /* reserved for non-Opus 0010 0000 0000 0000 */
#define B_resa   0x4000  /* reserved for non-Opus 0100 0000 0000 0000 */
#define B_resb   0x8000  /* reserved for non-Opus 1000 0000 0000 0000 */



/*--------------------------------------------------------------------------*/
/* Nodelist.Idx                                                             */
/* (File is terminated by EOF)                                              */
/*--------------------------------------------------------------------------*/
struct _ndi
   {
      int  node;          /* node number  */
      int  net;           /* net number   */
   };

/*--------------------------------------------------------------------------*/
/* OPUS CONTROL FILE AND PARM FILE DECLARATIONS                             */
/*--------------------------------------------------------------------------*/
#include "prm19.h"
#include "system19.h"
#include "nfile19.h"


/*--------------------------------------------------------------------------*/
/* Multitaskers (possible values for `ctl.multitasker'                      */
/*              NOTE: 0 means no multitasker in use                         */
/*--------------------------------------------------------------------------*/
#define DoubleDOS 1
#define DesqView  2
#define TopView   3
#define TaskView  3
#define MOS       4
#define MultiLink 5
#define OS_2      6	/* OS/2 DOS box */
#define Windows   7	/* not implemented yet */
#define LAN       0x80

/*--------------------------------------------------------------------------*/
/* Matrix mask                                                              */
/* Undefined bits are reserved by Opus  See EVENT.H                         */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* FLAGS                                                                    */
/*--------------------------------------------------------------------------*/
#define LOGECHO    0x01    /* log echomail areas                  0000 0001 */
#define STEADY     0x02    /* never change baud rate              0000 0010 */
#define ECHOSCAN   0x04    /* automatically scan echo's           0000 0100 */
#define ECHO_GUARD 0x08    /* no toss un-pwd echo arc             0000 1000 */
#define LEAVE_ESCN 0x10	   /* Leave echotoss.log after Scanning   0001 0000 */
#define DO_MSGID   0x20    /* Put MSGID lines into echomail       0010 0000 */
#define F_NOCRASH  0x40    /* Don't accept crash mail             0100 0000 */
#define F_UNPK     0x80    /* Unpack incomming arcmail            1000 0000 */


/*--------------------------------------------------------------------------*/
/* FLAGS 2                                                                  */
/*--------------------------------------------------------------------------*/
#define NO_USRLIST 0x01    /* no user list (enter msg)            0000 0001 */
#define WATCHDOG   0x02    /* Reboot during outside               0000 0010 */
#define F2_TOSS    0x04    /* Toss incomming echomail             0000 0100 */
#define F2_LASTREAD 0x08   /* Uses LASTREAD for Sysop             0000 1000 */
#define F2_DOSFILE 0x10    /* Close stdAUX and stdPRN             0001 0000 */
#define F2_PRIMARY 0x20    /* MultiTasker Primary task            0010 0000 */
#define F2_SECOND  0x40    /* MultiTasker Secondary task          0100 0000 */
#define F2_ECON    0x80    /* Econo Echo handling                 1000 0000 */


/*--------------------------------------------------------------------------*/
/* FLAGS 3                                                                  */
/*--------------------------------------------------------------------------*/
#define F3STEADY   0x01		/* Can do ARQ steady. &B2                    */
#define F3GMENU    0x02		/* Will let users do graphics menus          */
#define F3LOGOFF   0x04		/* Collect logoff messages                   */
#define F3NOALIAS  0x08		/* Don't put alias' in SEEN-BY               */
#define F3HINAMES  0x10		/* Allow users with hi-bit names             */

/*--------------------------------------------------------------------------*/
/* FWDflags (bits to control IN TRANSIT messages)                           */
/*--------------------------------------------------------------------------*/
#define FWD_NONE   0x01    /* No IN TRANSIT netmail               0000 0001 */
#define FWD_PWD    0x02    /* IN TRANSIT by pwd only              0000 0010 */
#define FWD_TONET  0x04    /* Accept IN TRANSIT only to my net    0000 0100 */
#define FWD_NOBITS 0x08    /* No IN TRANSIT if extended bits used 0000 1000 */
#define FWD_HOST   0x10		/* Send mail to host if can't find.          */
#define VERSION6   0x40	/* Use Version 6 nodelist                        */
#define IMAPOINT   0x80	/* This is a point                              */

/*--------------------------------------------------------------------------*/
/* LOG FLAGS                                                                */
/*--------------------------------------------------------------------------*/
#define LOG_TERSE  0x01    /* brief log                           0000 0001 */
#define LOG_WORDY  0x02    /* wordy log                           0000 0010 */
#define LOG_TRACE  0x04    /* very wordy log                      0000 0100 */


/*--------------------------------------------------------------------------*/
/* MODEM FLAGS                                                              */
/*--------------------------------------------------------------------------*/
#define M_SNOOP    0x01    /* sysop display on                    0000 0001 */
#define MOUSE      0x02    /* sysop mouse on                      0000 0010 */
#define M_BRKCLEAR 0x04    /* Use BREAK to clear outbound buffer  0000 0100 */
#define SLOW_MODEM 0x08		/* Slow modem and fast computer                 */

/*--------------------------------------------------------------------------*/
/* STYLE FLAGS                                                              */
/*--------------------------------------------------------------------------*/
#define SF_PATH    0x01    /* use path, not Dir.Bbs               0000 0001 */
#define SF_KILL    0x02    /* Kill rec'd pvt messages             0000 0010 */
#define SF_ASKKILL 0x04    /* ASK about killing msgs              0000 0100 */
#define SF_EUROPE  0x08		/* European date strings */
#define SF_TIME    0x10	/* Show time remaining on menu         0001 0000 */
#define SF_NOFLAG  0x20	/* Don't allow user config at logon    0010 0000 */
#define SF_HANDHOLD 0x40	/* Track user's errors and add help    0100 0000 */
#define SF_NOHIGH  0x80	/* don't allow high ascii characters    0100 0000 */


#define SET_FLAG(x,y)    ((x)|=(y))
#define CLEAR_FLAG(x,y)  ((x)&=(~(y)))
#define isFLAG(x,y)      ((x)&(y))
#define TOGGLE_FLAG(x,y) ((x)^=(y))




/*--------------------------------------------------------------------------*/
/* The rest of this file contains structure definitions similar to those    */
/* used by Fido<tm> version 11w.  No claim is made that Opus will maintain  */
/* compatibility with these structures beyond Opus version 0.               */
/*                                                                          */
/* The original version of the following items can be found in STRUCT.H, an */
/* include file writte (and probably copyrighted by) Tom Jennings.          */
/*--------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------*/
/*   THE USER DATABASE                                                      */
/*--------------------------------------------------------------------------*/


struct   _usr
{
    BYTE   name[36];	/* Caller's first and last names		*/
    BYTE   city[36];	/* Caller's location				*/
    BYTE   pwd[16];	/* Password					*/
    BYTE   usrtel[16];	/* User Tel# for ref or future callback ........*/
    BYTE   alias[32];	/* User alias if ID is not it ..................*/
/* 136 bytes */
    WORD   times;	/* Number of previous calls to this system      */
    BYTE   ClassPriv;	/* User Access Privilege			*/
    BYTE   help;	/* Help level (see below)			*/
    BYTE   tabs;	/* 0=transmit <sp> instead of <tab>		*/
    BYTE   language;	/* 0=english, 1=french				*/
    WORD   nulls;	/* Number of Nulls (delays) after <cr>		*/
    WORD   msg;		/* Last message area visited			*/
    WORD   Bits;	/* see USER OPTIONS BIT WEIGHTS below		*/
/* 148 bytes */
    ULONG  ClassLock;	/* 32 User Keys					*/

    time_t ludate;	/* Last UNIX Date on system			*/
/* 156 bytes */
    int    time;	/* Time on-line so-far today			*/

    WORD   flag;	/* Used to hold User maintainence information	*/
			/* -------1 0x01 Reuse record for next new user	*/
			/* xxxxxxx0 ---- Reserved reserved for opus Mgr	*/

    long   upld;	/* K-bytes uploaded, all calls			*/
    long   dnld;	/* K-bytes downloaded, all calls		*/
    int    dnldl;	/* K-bytes downloaded, today			*/
    WORD   files;	/* Last file area visited			*/
    BYTE   width;	/* Width of the caller's monitor		*/
    BYTE   len;		/* Height of the caller's			*/
    WORD   credit;	/* FidoNet usage credit in cents		*/
    WORD   debit;	/* FidoNet usage in cents			*/

    BYTE   spcoec[8];	/* Special OECC to show after logon ............*/
			/* Good for clubs, stores, user groups .........*/
			/* Eg, "Welcome to the dBase User Group" .......*/

    BYTE   saccnt[5];	/* Array of 5 special announcement cntrs .......*/
			/* If any is > 0 than the user is shown ........*/
			/* a corresponding announcement file & th ......*/
			/* counter is decremented till zero ............*/

    BYTE   exflag;	/* Flag of expiration control bits .............*/
			/* -------- 000 No expiry actions ..............*/
			/* -------1 001 Expire AFTER xdate .............*/
			/* ------1- 002 Expire when dbmin GE crmi ......*/
			/* -----:-- 004 ... Reserved ...  ..............*/
			/* ----:--- 008 ... Reserved ...  ..............*/
			/* ---1---- 016 Demote user priv to (expriv) ...*/
			/* --1----- 032 Axe user when expired  .........*/
			/* -:------ 064 ... Reserved ...  ..............*/
			/* :------- 128 ... Reserved ...  ..............*/


    time_t xdate;	/* Expiry date (UNIX style for math/futr).......*/
    long   crmin;	/* Total minutes given to user .................*/
    long   dbmin;	/* Total minutes used  to user .................*/

    char   u_section[16]; /* String for user current section		*/
    char   ulikes[16];	/* String of user interest keywords ............*/
    time_t fudate;	/* First time user called system in seconds	*/
    ULONG  caller_id;	/* Unique ID for this user. fudate		*/
    ULONG  Section;	/* What "section" of the bbs the user is in.    */
    WORD   menu_mode;	/* What menu the user was at last ..............*/
    WORD   TwoBits;  	/* More user configuration flags		*/
    WORD   After_Externs; /* Any special flags from external?		*/
    BYTE   msecs;	/* Number of message areas in User sections defined */
    BYTE   fsecs;	/* Number of file areas in User sections defined */

/* terminated!! */
#ifdef OLD
    WORD   lastmsg[MAXLREAD];	/* All the last message read stuff .....*/
#else
/* New for Opus 1.70 */
    BYTE   Address[32];		/* User's address			*/
    BYTE   My_Ans[64];		/* Reply to prm.My_Question		*/
    char   Strfill[32];		/* Filler for more strings		*/
    char   bday_mon;   		/* User's birthday/month		*/
    char   bday_day;   		/* User's birthday/day			*/
    int    bday_year;  		/* User's birthday/year			*/
    ULONG  messages_read;	/* Total number of messages read	*/
    long   messages_sent;	/* Number of messages entered by user	*/

    WORD   my_section[MAX_USEC];	/* This is just a block of area	*/
				  	/* numbers in the user's Section */
				  	/* Message areas are first, then */
				  	/* file areas. The first file    */
				  	/* area is at my_section[msecs]  */

    WORD   big_fill[40];	/* Fill out to 512 bytes		*/
    WORD   Opus_Flags;		/* Stores Opus temporary configuration	*/
    BYTE   byte_fill;
    BYTE   Default_Protocol;	/* Default transfer protocol		*/
    BYTE   User_MMacro[16];	/* Message User's keyboard Macro	*/
    BYTE   User_FMacro[16];	/* File User's keyboard Macro		*/
    BYTE   User_DMacro[16];	/* Default User's keyboard Macro	*/
    BYTE   Sysop_Comment[80];	/* Anything you want to say about 'em	*/
#endif
    ULONG OPUS_id;

			/* The next 7 sets of id and inf data are for   */
			/* external programs to use for auxialliary inf.*/
			/* Opus Mgr uses 1st 2 for reamrks about user.  */

    long   extern_id[7];/* LONG ID number for external programs		*/
			/* Must be registered with OpusInfo ....	*/
    BYTE   extern_inf[7][32];	/* 7 32-byte external util data blocks  */

    /* Total record size = 1024b ........................................*/
};


/*--------------------------------------------------------------------------*/
/* USER OPTIONS bit weights (undefined bits are reserved)                   */
/*--------------------------------------------------------------------------*/
#define  FillerBit   0x0001 /* Reserved                                     */
#define  ASKED_LEN   0x0002 /* Asked user for screen length?                */
#define  NO_IBMCHAR  0x0004 /* Cannot receive IBM textmode graphics         */
#define  USE_LORE    0x0008 /* Wants LORE editor instead of OPed            */
#define  MORE_PROMPT 0x0010 /* Wants the page break "MORE?" question        */
#define  ANSI        0x0020 /* Can handle ANSI video                        */
#define  CONFIG_SET  0x0040 /* OPUS logon questions answered                */
#define  FORMFEED    0x0080 /* SET=xmit clearscreen, CLEAR=eat formfeed     */
#define  AVATAR      0x0100 /* Can handle AVATAR (aka "oANSI") video        */
#define  TALKER      0x0200 /* Wants limited graphics for speech            */

#define  USE_PHONE   0x0400 /* Call Back User Modem                         */
#define  USE_ALIAS   0x0800 /* Enable ALIAS searches, message entry, etc    */

#define  NO_NAME    0x1000 /* User List Name                               */
#define  NO_TIME    0x2000 /* User List Time                               */
#define  NO_CITY    0x4000 /* User List City                               */


#define  CURSOR_CONTROL (ANSI|AVATAR)

/*--------------------------------------------------------------------------*/
/* 2Bits flags (More user configuration choices....                         */
/*--------------------------------------------------------------------------*/
#define  HOTKEYS     0x0001 /* Wants HotKeys at all help levels             */
#define  QMENU       0x0002 /* Wants to return to last menu instead of MAIN */
#define  ASKGRAPH    0x0004 /* Wants to be asked about graphics every logon */
#define  ASCIIMENU   0x0008		/* Wants long tedious graphics menus        */
#define  SHOW_TIME   0x0010		/* Show time remaining at prompts        */
#define  BLOCKCHAT   0x4000		/* User doesn't want to be sociable.     */
#define  INCRITAREA  0x8000		/* Opus is in critical area              */


/*--------------------------------------------------------------------------*/
/* eXpiration flags                                                         */
/*--------------------------------------------------------------------------*/
#define BY_DATE     0x0001              /* Zap users by date                        */
#define BY_TIME     0x0002              /* Zap users when they run out of credit    */
#define DEMOTE      0x0010              /* Demote user instead of deleting them     */
#define AXE         0x0020              /* Delete user                              */


/*--------------------------------------------------------------------------*/
/* User help levels                                                         */
/*--------------------------------------------------------------------------*/
#define  HITECH      0x00  /* Lotus style, top-of-screen, menu bars         */
#define  EXPERT      0x02  /* grizzled veteran, no menus at all             */
#define  REGULAR     0x04  /* experienced user, brief menus                 */
#define  NOVICE      0x06  /* Full menus plus additional hand-holding       */
#define  USING_FTB   0xff  /* caller is using the Full-Tilt-Boogie method   */

/*--------------------------------------------------------------------------*/
/* Flags for After_Externs                                                  */
/*--------------------------------------------------------------------------*/
#define NEW_ECHOS   0x0001		/* New Echomail entered by user             */
#define NEW_MATRIX  0x0002		/* New Matrix entered by user               */
#define NEW_LOCAL   0x0004		/* New Local mail entered by user           */
#define UPLOADED    0x0008		/* User uploaded something                  */
#define DUP_UPLOAD  0x0010		/* User uploaded a duplicate file           */

/*--------------------------------------------------------------------------*/
/* LASTUSER.BBS file structure                                              */
/*--------------------------------------------------------------------------*/
/* Struct of LASTUSE#.BBS file that is written everytime a user logons on   */
/* or when Opus does an OUTSIDE exit.  It contains a complete and exact     */
/* copy of the user record, following by extended data for session control. */
/* If PRM is configured to reload user data upon return from an OUTSIDE     */
/* exit, then Opus reloads user record portion, making it the active copy.  */
/*--------------------------------------------------------------------------*/

#ifdef _TM_DEFINED
struct _lu_file
   {
      struct _usr user;    /* Copy of user record                           */
      WORD  baud;          /* Current user's baud (0 == keyboard!)          */
      WORD  port;          /* Current port #                                */
      WORD  task;          /* Active task number                            */
      WORD  mins;          /* User's minutes remaining                      */
      WORD  msgarea;       /* Which message area user is in                 */
      WORD  filearea;      /* Which file area user is in                    */
      long   timeoff;      /* UNIX GMT of latest time user stays on till    */
      struct tm tmoff;     /* MS-C 'tm' struct of above but as local time   */
      char   laston[25];   /* Orig Last Call Date as ASCIIZ string because  */
                           /* same field in user rec now is curr logon time */
   };
#endif


/*-------------------------------------------------------------------------*/
/*                                                                         */
/* MESSAGE AND FILE AREAS                                                  */
/*                                                                         */
/*-------------------------------------------------------------------------*/

/* See SYSTEM.H */



/*--------------------------------------------------------------------------*/
/*                                                                          */
/* MESSAGES                                                                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Message header                                                           */
/*--------------------------------------------------------------------------*/
struct _msg
   {
      BYTE from[36];
      BYTE to[36];
      BYTE subj[72];
      BYTE date[20];       /* Obsolete/unused ASCII date information        */
      WORD times;          /* FIDO<tm>: Number of times read                */
      int  dest;           /* Destination node                              */
      int  orig;           /* Origination node number                       */
      WORD cost;           /* Unit cost charged to send the message         */

      int  orig_net;       /* Origination network number                    */
      int  dest_net;       /* Destination network number                    */

                           /* A TIMESTAMP is a 32-bit integer in the Unix   */
                           /* flavor (ie. the number of seconds since       */
                           /* January 1, 1970).  Timestamps in messages are */
                           /* always Greenwich Mean Time, never local time. */

      struct _stamp date_written;   /* When user wrote the msg              */
      struct _stamp date_arrived;   /* When msg arrived on-line             */

      WORD reply;          /* Current msg is a reply to this msg number     */
      WORD attr;           /* Attribute (behavior) of the message           */
      WORD up;             /* Next message in the thread                    */
   };



/*--------------------------------------------------------------------------*/
/* Message attributes                                                       */
/*--------------------------------------------------------------------------*/
#define MSGPRIVATE 0x0001  /* private message         * 0000 0000 0000 0001 */
#define MSGCRASH   0x0002  /* squirtmail              * 0000 0000 0000 0010 */
#define MSGREAD    0x0004  /* read by addressee       * 0000 0000 0000 0100 */
#define MSGSENT    0x0008  /* sent OK (remote)          0000 0000 0000 1000 */
#define MSGFILE    0x0010  /* file attached to msg    * 0000 0000 0001 0000 */
#define MSGFWD     0x0020  /* in transit                0000 0000 0010 0000 */
#define MSGORPHAN  0x0040  /* unknown dest node         0000 0000 0100 0000 */
#define MSGKILL    0x0080  /* kill after bundling     * 0000 0000 1000 0000 */
#define MSGLOCAL   0x0100  /* FidoNet vs. local         0000 0001 0000 0000 */
#define MSGHOLD    0x0200  /* Hold, don't send        * 0000 0010 0000 0000 */
#define MSGXX2     0x0400  /* <reserved>             X? 0000 0100 0000 0000 */
#define MSGFRQ     0x0800  /* file request            * 0000 1000 0000 0000 */
#define MSGRRQ     0x1000  /* receipt requested      X* 0001 0000 0000 0000 */
#define MSGCPT     0x2000  /* is a return receipt    X* 0010 0000 0000 0000 */
#define MSGARQ     0x4000  /* audit trail requested  X* 0100 0000 0000 0000 */
#define MSGURQ     0x8000  /* update request          * 1000 0000 0000 0000 */
                                                   /*-----------------------*/
                                                   /* ^                     */
                                                   /* |                     */
                                                   /*  * = preserved by     */
                                                   /*      the network      */
                                                   /*  ? = stripped by the  */
                                                   /*      net (FTSC spec)  */
                                                   /*      but preserved    */
                                                   /*      by seadog<tm>    */
                                                   /*  X = not used by Opus */
                                                   /*-----------------------*/




/*--------------------------------------------------------------------------*/
/*                                                                          */
/* EVENTS                                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*  #include <event.h>  */

/*--------------------------------------------------------------------------*/
/* Message bundle header                                                    */
/*--------------------------------------------------------------------------*/

#define PKTVER       2        /* Used for `ver' (below)                     */

struct _pkthdr
   {
      int   orig_node;        /* originating node               */
      int   dest_node;        /* destination node               */
      int   year;             /* 0..99  when packet was created */
      int   month;            /* 1..12  when packet was created */
      int   day;              /* 1..31  when packet was created */
      int   hour;             /* 0..23  when packet was created */
      int   minute;           /* 0..59  when packet was created */
      int   second;           /* 0..59  when packet was created */
      int   rate;             /* destination's baud rate        */
      int   ver;              /* packet version                 */
      int   orig_net;         /* originating network number     */
      int   dest_net;         /* destination network number     */
      char  product;          /* product type                   */
      char  serial;           /* serial number (some systems)   */

                              /* ------------------------------ */
                              /* THE FOLLOWING SECTION IS NOT   */
                              /* THE SAME ACROSS SYSTEM LINES:  */
                              /* ------------------------------ */
      BYTE pktpwd[8];		/* session/pickup password	*/
      int  Orig_Zone;		/* originating zone		*/
      int  Dest_Zone;		/* destination zone		*/
      BYTE B_fill2[16];
      long B_fill3;
};









/*--------------------------------------------------------------------------*/
/* WAZOO                                                                    */
/*--------------------------------------------------------------------------*/

#ifndef ACK
#define ACK    0x06
#endif

#ifndef NAK
#define NAK    0x15
#endif

#ifndef ENQ
#define ENQ    0x05
#endif

#ifndef YOOHOO
#define YOOHOO 0x00f1     /* 241 (a prime number, I think) */
#endif

#ifndef  TSYNC
#define  TSYNC 0x00ae
#endif

struct   _Hello
   {
      WORD     signal;           /* always 'o'     (0x6f)                   */
      WORD     hello_version;    /* currently 1    (0x01)                   */
      WORD     product;          /* product code                            */
      WORD     product_maj;      /* major revision of the product           */
      WORD     product_min;      /* minor revision of the product           */
      char     my_name[60];      /* Other end's name                        */
      char     sysop[20];        /* sysop's name                            */
      ADDR     my_address;
      BYTE     my_password[8];   /* ONLY 6 CHARACTERS ARE SIGNIFICANT !!!!! */
      BYTE     reserved2[8];     /* reserved by Opus                        */
      WORD     capabilities;     /* see below                               */
      BYTE     reserved3[12];    /* available to non-Opus systems by prior  */
                                 /* "approval" of 124/108.                  */
   }; /* size 128 bytes */


/*--------------------------------------------------------------------------*/
/* YOOHOO<tm> CAPABILITY VALUES                                             */
/*--------------------------------------------------------------------------*/
#define Y_DIETIFNA 0x0001  /* Can do LoTek            0000 0000 0000 0001 */
#define FTB_USER   0x0002  /* reserved by Opus        0000 0000 0000 0010 */
#define ZED_ZIPPER 0x0004  /* reserved by Opus        0000 0000 0000 0100 */
#define ZED_ZAPPER 0x0008  /* Can do ZModem/plain     0000 0000 0000 1000 */
#define DOES_IANUS 0x0010  /* Does Opus Janus         0000 0000 0001 0000 */
#define Bit_5      0x0020  /* reserved by Opus        0000 0000 0010 0000 */
#define Bit_6      0x0040  /* reserved by Opus        0000 0000 0100 0000 */
#define Bit_7      0x0080  /* reserved by Opus        0000 0000 1000 0000 */
#define Bit_8      0x0100  /* reserved by Opus        0000 0001 0000 0000 */
#define Bit_9      0x0200  /* reserved by Opus        0000 0010 0000 0000 */
#define Bit_a      0x0400  /* reserved by Opus        0000 0100 0000 0000 */
#define Bit_b      0x0800  /* reserved by Opus        0000 1000 0000 0000 */
#define Bit_c      0x1000  /* reserved by Opus        0001 0000 0000 0000 */
#define Bit_d      0x2000  /* reserved by Opus        0010 0000 0000 0000 */
#define DO_DOMAIN  0x4000  /* reserved by Opus        0100 0000 0000 0000 */
#define WZ_FREQ    0x8000  /* accepts file requests   1000 0000 0000 0000 */


/*

   User Indexing Support Items

   Bit setting of (word) UDB_Flags

   & 1 ... Set ON if user name CRC indexing is expected.  The general
           init func should look for User.Idx and check its size for
           a match to the user file size.  Must be nrecs * sizeof(long).

           Or, can simply be forced on and the first func that finds the
           index to be missing or inconsistent will give a short status
           error and turn the bit off, stopping further index attempts.

   & 2 ... Set ON if user file locking is to be attempted which requires
           SHARE.EXE to be loaded.  This is desired as updates to the
           user file index should be controlled as access to 2 separate
           files in a multitasked scenario can span some time and the
           chance of indexing errors is quite high.  When ON, the 1st byte
           of ONLY the user file is locked to mean that the user database
           is being updated.  There should be no need to lock the index
           as the user file is always accessed first.

           It has to be tested to see if the effect of other read accesses
           to the user file (eg, user listing, searching) will fail if
           the file is locked during an update.  I suspect that other
           activities will be transparent to it and ONLY other LOCKING
           attempts will be foiled.  This would allow compatibility with
           other existing R/O accesses to the file.

           If it proves to be safe, we can force this ON and allow the
           the first function wherein it fails to turn it off with a
           single short message.

*/

#define UsrIdx  1                         /* Says, Attempt CRC indexing     */
#define UsrLok  2                         /* Says, Attempt File Locking     */
#define UsrPwd  4

#define HAS_UF(v)  (ctl.UDB_Flags & v)    /* Check if Ufile feature used    */
#define STOP_UF(v) ctl.UDB_Flags &= ~v    /* Turn off Ufile feature         */

/* END OF FILE: opus.h */
