/* nfile19.h                                                                 */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*               The Opus Computer-Based Conversation System                */
/*    (c) Copyright 1986-1992, Wynn Wagner III, All Rights Reserved         */
/*                                                                          */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are                     */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/* This material is available for use by anybody with no strings and        */
/* no guarantees.                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* OPUS 1.80 FILESBBS database structures.				    */
/* Copyright 1991-1992 Wynn Wagner III, Doug Boone and John Valentyn.       */
/*                                                                          */
/* companion file for prm19.h for Opus 1.80                                 */
/*--------------------------------------------------------------------------*/

 
#define ADX_VERSION 2	/* current version */
#define MAX_DESCR 512	/* max description length allowed */
 
#ifndef NEWdefs
  typedef unsigned      BIT;
  typedef unsigned char BYTE;
  typedef unsigned int  WORD;
  typedef unsigned long ULONG;
# define NEWdefs
#endif
 
/*--------------------------------------------------------------*/
/* structure for FILESBBS.DAT					*/
/*--------------------------------------------------------------*/
typedef struct _afile {		/* define a files info entry */
    WORD    area_number;	/* area number where file resides */
    BYTE    name[13];		/* file name */
    BYTE    dl_priv;		/* Privilege needed to download this file */
    long    size;		/* file size */
    WORD    date;		/* file date */
    WORD    time;		/* file time */
    WORD    aflag;		/* flag (see aflag definitions) */
    ULONG   dl_lock;		/* Lock to download this file */
    WORD    up_date;		/* Datestamp when file was uploaded */
    WORD    up_time;		/* Timestamp when file was uploaded */
    WORD    down_cntr;		/* # of downloads/requests */
    WORD    descr_len;		/* length of file description */
    BYTE    altpath_len;	/* File not in default dir, where is it */
    BYTE    upld_by_len;	/* length of uploader name */
    long    nxt_key;		/* linked list for area */
    long    prior_key;		/* linked list for area */
    BYTE    filler[16];		/* fill to 64 byte block */
} AFILE;
 
/* text strings follow the _afile data in the filesbbs.dat file */
/* in the following order:					*/
/* description      */
/* alternate path   */
/* uploaded-by      */

/*--------------------------------------------------------------*/
/*		 _afile aflag definitions			*/
/*--------------------------------------------------------------*/
#define IS_FILE     0x0001	/* This is a file listing	*/
#define IS_COMMENT  0x0002	/* A comment line		*/
#define EMBEDDED    0x0004	/* This line has embedded cmnds */
#define ORPHAN      0x0008	/* Orphan file (no description)	*/
#define MISSING     0x0010	/* Missing file			*/
#define STAR_NAME   0x0020	/* File name is wildcard name	*/
#define EXPANDED    0x0040	/* expanded from wildcard name	*/
#define DELETED     0x0080	/* this entry has been deleted  */
#define AS_IS       0x0100      /* Don't wrap this line. Used with graphics */
/*		    0x0200	reserved by Opus		*/
#define SAVE_AFLAG  0x03FF	/* mask to save Opus reserved bits	*/
/*		    0x0400	reserved by Opus-FAM		*/
/*		    0x0800	reserved by Opus-FAM		*/
/* the other 4 bits are not designated yet			*/
/* they can be used by applications for such things as:		*/
/*	file checked out by a virus-checker			*/
/*	sysop has checked the file				*/
/*								*/

/*--------------------------------------------------------------*/
/* structure for FILESBBS.ADX					*/
/*--------------------------------------------------------------*/
typedef struct _numb_idx {	/* Structure for FILESBBS.ADX	*/
    WORD    area_number;	/* area no where files reside	*/
    BYTE    area_priv;		/* Access priv			*/
    BYTE    adx_vers;		/* numb_index version		*/
    ULONG   area_lock;		/* Access lock			*/
    long    head_pos;		/* first record pos in data file */
    long    tail_pos;		/* last record pos in data file */
    long    insert_pos;		/* where to insert new files	*/
    WORD    nflag;		/* flags for this area		*/
				/* 22 */
} ANUMB;

/*--------------------------------------------------------------*/
/*		 _numb_idx nflag definitions			*/
/*--------------------------------------------------------------*/
#define HAS_AT      0x0001	/* @ Area hides uploads		*/
#define HAS_GT      0x0002	/* > Area has insert pointer	*/
#define IS_STATIC   0x8000	/* file info is static	*/
 
/*--------------------------------------------------------------*/

#ifdef COMMENTS

/*
   File database structures for OPUS-CBCS 1.80

   The file database consists of three (3) files.
   FILESBBS.DAT contains all the info for a file.
   FILESBBS.ADX is a sequential index by file area for FILESBBS.DAT.
   FILESBBS.NDX is a btree index by file name for FILESBBS.DAT.
*/
/*
          FILE DATABASE LAYOUT
                                               the filesbbs.adx index file
                                               contains one record for
     Ŀ             each file area
         FILESBBS.ADX record    
     ĳ             head_pos points to first
     * head_pos                             record for area
     * tail_pos                   Ŀ
     * insert_pos (optional)      Ŀ      tail_pos points to last
               record for area
                                       
    Ŀ           nxt_key points to next
>       FILESBBS.DAT record               record for area
    Ŀ           0 = end of chain
        FILESBBS.DAT record      <  
 >  Ŀ         prior_key points to prior
        FILESBBS.DAT record             record for area
     ĳ < <     0 = end of chain
 >    * nxt_key                   
        * prior_key                 
       

*/

/* alternate download path
   for use by sysops who have files on CD-ROMS or other storage devices
   where the file directories do not "map" to file area subjects.
   it is also a handy way to have a file listed in more than one area,
   yet have only one copy of the actual file.
   Opus and Opus-FAM look at altpath first to find the file, and if
   there's no altpath, look in the download directory.
*/
 
/* DELETED flag
   is used when an entry (comment or file) is deleted. Rather than rewrite
   the entire file each time an entry is deleted, which can get rather
   time consuming, the re-index function during maintenance will purge
   the deleted records.
*/
 
/* wildcard filenames and descriptions
   are kept in the database with the STAR_NAME and MISSING flags set.
   the filenames that are expanded from the wildcards are flagged
   with IS_FILE and EXPANDED.  The re-index database utility always
   rebuilds from the wilcard name (except in quick mode).
*/
#endif
 
/* nfile19.h */
