/* event.h                                                                  */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*               The Opus Computer-Based Conversation System                */
/*    (c) Copyright 1986-1992, Wynn Wagner III, All Rights Reserved         */
/*                                                                          */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are                     */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/* This material is available for use by anybody with no strings and        */
/* no guarantees.                                                           */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* 02/06/89 */
/* Added E_MAILER event kind                                                */

/* 06/13/88 */

/* EVENT header file for OPUS v1.1                                          */
/* Unused and undefined space in structures is reserved by OPUS.            */
/* IMPORTANT: Some file access methods for the event data file are planned. */
/*            Routines to handle this method (or multitasker convention)    */
/*            will be available in source code form at some point.  Please  */
/*            check for those before you release anything.  In a nutshell,  */
/*            the method involves opening the file as "DENY NONE" at all    */
/*            times when your program is operating under DOS 3+.  This is   */
/*            the convention for WRITING to the event file:                 */
/*                1. If DOS 2, just open/write/close.                       */
/*                   For DOS 3, open as "DENY NONE" sharing mode.           */
/*                2. Lock the first byte of the file, and be prepared to    */
/*                   handle a timeout.                                      */
/*                3. Write to the event file.                               */
/*                4. Unlock the first byte.                                 */
/*                5. Close the file                                         */
/*            No program should keep the file open and locked... so others  */
/*            don't get stuck on step two.  This is a NON-STANDARD use of   */
/*            the DOS locking mechanism.  We cannot use an "open mode" with */
/*            a BBS because that is considered an "ABORT/RETRY" situation.  */
/*            Locking individual records can lead to deadlock.  So, we have */
/*            a CONVENTION, a rule, that says when the first byte of the    */
/*            file is locked, the entire file is to be considered locked.   */
/*            This will work if all programs using the file respect the     */
/*            convention, and if they perform all five steps in rapid fire  */
/*            sequence. You should not open/lock a file and leave it open.  */




/*--------------------------------------------------------------------------*/
/* LEGIBLE SECTION.  Definitions to make "C" look like Wynn's language.     */
/*--------------------------------------------------------------------------*/
#ifndef begin
#define begin        {
#define end          }

#define true         (-1)
#define false        0
#define Procedure    void
#endif

#ifndef max
#define max(a,b)     ((a)>(b)?(a):(b))
#endif

#ifndef min
#define min(a,b)     ((a)<=(b)?(a):(b))
#endif


#ifndef CMDLEN  /* see if Opus.H was included.  If so, don't use these... */
   typedef unsigned      bit;
   typedef unsigned int  WORD;
   typedef unsigned char BYTE;
#endif



/*--------------------------------------------------------------------------*/
/* Matrix mask                                                              */
/* Undefined bits are reserved by Opus                                      */
/*--------------------------------------------------------------------------*/
#define NO_TRAFFIC 0x0001  /* ok to send outbound local 0000 0000 0000 0001 */
#define LOCAL_ONLY 0x0002  /* ok to send outbound local 0000 0000 0000 0010 */
#define OPUS_ONLY  0x0004  /* only send to #CM systems  0000 0000 0000 0100 */
#define NO_LOCAL   0x0008  /* Send only to cost>event[i].cost               */
                           /*                           0000 0000 0000 1000 */
#define NO_REQ     0x1000  /* Don't call out for REQ    0001 0000 0000 0000 */
#define NO_EXITS   0x2000  /* crash/arc exits ignored   0010 0000 0000 0000 */
#define MAIL_ONLY  0x4000  /* no human callers allowed  0100 0000 0000 0000 */
#define TAKE_REQ   0x8000  /* file requests are ok      1000 0000 0000 0000 */





#define E_VERSION  2       /* Current version of the event file structure   */


/*--------------------------------------------------------------------------*/
/* Event file header record                                                 */
/*--------------------------------------------------------------------------*/
struct _e_head
{
   WORD  E_FVersion;	/* Version of the event file			*/
   WORD  E_NumSlots;	/* Total number of event records		*/
   WORD  E_Offset;	/* Absolute offset of first event slot		*/
   ULONG Caller_ID;	/* Last caller id used				*/
   long  MSG_ID;	/* Last MSGID used				*/
   WORD  e_fill1[1];	/* Reserved for other offsets			*/
   long  CallerCount;	/* Number of callers				*/
   long  QuotePosition;	/* Position of next usable byte in Quotes.BBS	*/
   WORD  e_fill2[4];	/* Reserved for other volatile data		*/
};



/*--------------------------------------------------------------------------*/
/* Event structure (schedule file record layout)                            */
/*                                                                          */
/* When creating a new record, it is important that you make sure fields    */
/* marked `reserved' are set to zero.  When copying or modifying an exist-  */
/* int structure, those reserved fields must be preserved.                  */
/*--------------------------------------------------------------------------*/
struct _event
{
    WORD  EventFlag;	/* See EVENT FLAGS (below)                       */
    WORD  start;	/* Number of minutes when event starts           */
    WORD  finis;	/* Number of mins when event ENDS                */
    BYTE  daywk;	/* Execute Day (Bit Mask, See DAYS (below)       */
    BYTE  kind;		/* See KINDs (below)                             */
    WORD  miscinfo;	/* (Behavior) Matrix Mask, daywk bitmask copy    */
			/* to check off as events are executed           */
    BYTE  errorlevel;	/* X errorlevel, Yell bell duration, (Z) offset  */
    BYTE  cost;		/* Cost for "local" calls (local on, max. cost)  */
    BYTE  priority;	/* Adjusts how often OPUS calls (0-9)            */
    BYTE  Days;		/* Checks off as events are executed             */
    BYTE  reqs;		/* Limit on the number of minutes for request    */
    BYTE  fill_2;	/* OPUS: Reserved for Opus                       */
};	/* 16 bytes, nice power-of-two number for easy array access.     */


   /* Event flag is the first field because it's used the most and the      */
   /* address of the first field of a structure is easier to calculate.     */

   /* Utility writers:                                                      */
   /*                                                                       */
   /* When creating a new schedule file, make Days = 0                      */
   /* When modifying daywk of an existing file, make Days = Days and daywk  */




/*--------------------------------------------------------------------------*/
/* EVENT FLAGS (bit weights)                                                */
/*--------------------------------------------------------------------------*/
#define  E_ENABLED   0x01  /* the event is enabled      0000 0000 0000 0001 */
#define  E_LOCAL     0x02  /* event ends as local       0000 0000 0000 0010 */
#define  S_LOCAL     0x04  /* event starts as local     0000 0000 0000 0100 */
#define  E_FORCED    0x10  /* do event                  0000 0000 0001 0000 */
#define  E_INFORMAL  0x20  /* don't force user off      0000 0000 0010 0000 */
#define  E_EXECUTE   0x80  /* Execute immediately and clear                 */
                           /*                           0000 0000 1000 0000 */

/*--------------------------------------------------------------------------*/
/* EVENT `KIND's                                                            */
/* A sequence of contiguous numbers so MsC will generate a nice jump table  */
/* for any switch statement using the KIND field.                           */
/*--------------------------------------------------------------------------*/
#define  E_EXTERNAL  0x01
#define  E_BEHAVIOR  0x02
#define  E_HOLDAREA  0x04
#define  E_SCAN      0x08
#define  E_YELL      0x10
#define  E_MAILER    0x20
#define  E_USER      0x40



/*--------------------------------------------------------------------------*/
/* Day-of-Week FLAGS (bit weights)                                          */
/*--------------------------------------------------------------------------*/
#define  SUNDAY      0x01  /*                         0000 0001 */
#define  MONDAY      0x02  /*                         0000 0010 */
#define  TUESDAY     0x04  /*                         0000 0100 */
#define  WEDNESDAY   0x08  /*                         0000 1000 */
#define  THURSDAY    0x10  /*                         0001 0000 */
#define  FRIDAY      0x20  /*                         0010 0000 */
#define  SATURDAY    0x40  /*                         0100 0000 */

#define MAX_EVENTS   0xff
#define BYTES        (MAX_EVENTS*sizeof(struct _event))

#define is(x)        (event[i].EventFlag&(x))
#define isnt(x)      (!(event[i].EventFlag&(x)))


/* END OF FILE: event.h */
