/*

    jmodem.c:

    Opus 3.07 Jmodem File Transfer Protocol Interface
    written by:

            Brad Smith
            ADS Progressive Link BBS
            Jacksonville, NC 28540
            (919) 455-5972
            9600+ 24hrs.

    This program with source is hereby released to the public domain.

    The following information is an excerpt from Opus 1.10 Prelim Docs:

    .
    .
    .
    Information is passed from Opus just like calls to other
    programs, except the fully qualified program name is passed as
    the final parameter without an extension.

    (NOTE: it appears that this is NOT the case with Opus 1.13.
     Examination of parms passed indicates that this is NOW the
     control file pathname. This program RELIES ON THIS FACT!)

    Program.ext [other parms] -p# -b# -t# -m# -f# -r# Program

    where,

     -p#  Active Port number (0=Com1, 1=Com2, etc.)
     -b#  Active connect speed (i.e. -b2400)
     -t#  Active Task Number 
     -m#  Active message area number 
     -f#  Active file area number 
     -r#  Number of minutes remaining for this user

    All numbers are decimal.  For example, Opus might call Kermit
    with this command:

    C:\OPUS\KERMIT.EXE -p1 -b4800 -t1 -m3 -f16 -r86 C:\OPUS\KERMIT

    which would mean execute KERMIT.EXE for

     Port 1
     4800 cps
     Task 1
     Message area 3
     File area 16
     86 minutes remaining
     C:\OPUS\KERMIT is path\filename for control and log files

    1.4.2.2 PROTOCOL CONTROL FILE

     Opus creates a control file with information in it just
    prior to executing the protocol program.  The control file will
    be located in the same directory as the protocol program.  The
    naming convention for this control file is ProgramName.CTL, where
    ProgramName = Protocol Name, if task number is equal to 0.  If
    task number is greater than 0, then the last two digits of the
    filename are replaced with the hexadecimal task number.  Here are
    some examples.


     Protocol Program            Task  Control File
          
     C:\OPUS\KERMIT.EXE           0    C:\OPUS\KERMIT.CTL

     C:\PROTOCOL\KERMIT.EXE       3    C:\PROTOCOL\KERM03.CTL


    The contents and format of this control file are:

     Port <a>
     Baud <b>
     Modem <c> <d> <e> <f> <g>
     Time <h>
     Log OpusLogName
     Messages MessagePath
     Uploads UploadPath
     Downloads DownloadPath
     Files ListPath (only if declared in Opus control file)
     Get|Send Transferred_Filename    (This line repeated for
                                      each file to transfer)

    where,

     <a>       =    comport (1=com1, 2=com2)
     <b>       =    caller baud
     <c>       =    comport (1=com1, 2=com2)
     <d>       =    If STEADY max_baud else current baud 
     <e>       =    handshake mask
     <f>       =    carrier mask
     <g>       =    caller baud
     <h>       =    time remaining in minutes
     Get|Send  =    `Get' if file is an upload to Opus
                    `Send' if file is a download from Opus

    NOTE: Parameters <c>,<d>,<e>,<f>, and <g> are hexadecimal
          numbers.  All other numbers are decimal.

    An example control file for our KERMIT program might look like

    C:\OPUS\KERM01.CTL for upload:

     Port 2
     Baud 2400
     Modem 2 960 1 80 960
     Time 320
     Log R:\OPUS.LOG
     Messages M:\MEMBERS\
     Uploads F:\UPLOAD\
     Downloads F:\OPUS110\
     Get F:\UPLOAD\OEXE_111.ZIP       (This line repeated for
                                      each file to transfer)

    C:\OPUS\KERM01.CTL for download:

     Port 2
     Baud 2400
     Modem 2 960 1 80 960
     Time 335
     Log R:\OPUS.LOG
     Messages M:\MEMBERS\
     Uploads F:\UPLOAD\
     Downloads f:\opus110\
     Send f:\opus110\OEXE_111.ZIP     (This line repeated for
                                      each file to transfer)


    1.4.2.3 PROTOCOL LOG FILE

         After the file transfer is complete, the protocol program
    must create a log file.  This log file is used by Opus to write
    information to its own log.  The logs are placed in the same
    directory as the control file with the same naming
    convention,i.e., if there is a C:\OPUS\KERM01.CTL file, then
    there should be a corresponding C:\OPUS\KERM01.LOG file.  The log
    file only has one line in it for each file transferred.  It is of
    the form:

     Got|Sent path\filename ####

    where,

     Got|Sent  =    `Got' for an upload to Opus
                    `Sent' for a download from Opus

     ####      =    Size of file in bytes


    For Upload, the log file might look like

         Got f:\upload\OEXE_111.ZIP 138688

    For Download, the log file might look like

         Sent f:\upload\OEXE_111.ZIP 138688

*/

#include <dos.h>
#include <stdio.h>
#include <dir.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <process.h>

typedef char str[60];
#define  ulong   unsigned long

str  ctlfname;          /* control filename         */
str  logfname;          /* log filename             */
str  filename;          /* filename passed to jm.ex */
char port[2];           /* port # to pass to jm.exe */
char rs[3];             /* receive or send          */
char output[100];       /* log file output line     */
FILE *fctl;
FILE *flog;
FILE *temp;

/*-- prototypes --*/
int   read_ctl  (void);
ulong fsize     (void);
int   exec_jmod (void);


main(int argc, char *argv[])
{

    printf("JModem 3.07 Interface for Opus 1.13\n");
    if (argc < 8)
    {
        printf("This program should be run by Opus...\n");
        exit(0);
    }

    /*-- use passed parms to build log filename --*/
    strcpy(ctlfname,argv[7]);
    strcpy(logfname,ctlfname);
    logfname[strlen(logfname)-4] = '\0';
    strcat(logfname,".LOG");

    /*-- now the port number --*/
    itoa(atoi(argv[1]+2)+1,port,10);

#ifdef DEBUG

    printf("CTL File = %s\n",ctlfname);
    printf("LOG File = %s\n",logfname);
    if ((temp = fopen("jmodem.tst","w")) == NULL)
    {
        printf("Could Not Open Test File...\n");
        exit(0);
    }

    while (argc--)
        fprintf(temp,"Arg = %u : %s\n",argc,argv[argc]);

    fprintf(temp,"CTL File = %s\n",ctlfname);
    fprintf(temp,"LOG File = %s\n",logfname);

    fclose(temp);

    exit(0);

#else

    /*-- try to open the necesary files --*/
    if ((fctl = fopen(ctlfname,"r")) == NULL)
    {
        printf("Could Not Open %s Control File...\n",ctlfname);
        exit(1);
    }

    if ((flog = fopen(logfname,"w")) == NULL)
    {
        printf("Could Not Open %s Log File...\n",logfname);
        exit(1);
    }

    /*-- read the ctl file --*/
    if (!read_ctl())
    {
        printf("Could Not Read %s...\n",ctlfname);
        exit(1);
    }

    /*-- now send or receive the file(s) --*/
    if (exec_jmod() == 0)
    {
        sprintf(output,"%s %s %lu\n",(rs[0] == 'S' ? "Sent" : "Got"),
                                     filename,fsize());
        fputs(output,flog);
    }

    fclose(flog);

#endif

} /* main() */

int read_ctl(void)
{

    char line[80];

    /*-- get the last line of the control file --*/
    while (fgets(line,80,fctl) != NULL)
        ;

    fclose(fctl);                           /* done with the file    */

    strcpy(filename,strchr(line,' ')+1);    /* get the filename      */
    filename[strlen(filename)-1] = '\0';    /* trash the trailing \r */
    rs[0] = (line[0] == 'S' ? 'S' : 'R');   /* send or receive ?     */
    strcat(rs,port);                        /* add the port to it    */

    return(1);

} /* read_ctl() */


ulong fsize(void)
{

    struct ffblk fblk;

    if (findfirst(filename,&fblk,0) == -1)
        return(0L);                               /* can't find the file */
    else
        return(fblk.ff_fsize);                    /* return the filesize */

} /* fsize() */


int exec_jmod(void)
{

    char command[61];

    sprintf(command,"JM.EXE %s %s",rs,filename);
    printf("\n%s\n",command);

    return(system(command));

} /* exec_jmod() */

