
/* Quasi-Replacement for ML-UPDATE Copyright 1988, Doug Boone */

/* compiled with Turbo C 2.0  */

#include	<dir.h>
#include	<stdio.h>
#include	<stdlib.h>
#include    <string.h>
#include    <ctype.h>
#include	<time.h>
#include    <alloc.h>
#include	<process.h>
#include	<fcntl.h>
#include    <conio.h>

typedef unsigned int  word;
typedef unsigned char byte;

#include    "nfile.h"

#define     EOS         '\0'
#define     MAX_PATH    82

#define     DIRECT      0x01
#define     HOLD        0x02
#define     CRASH       0x04
#define     SHRINK      0x10
#define     DELETE      0x20

char	*find_parm(char *,int);
void    go_4_it(void);

struct  _list   {
    int     area;
    struct  _list *next;
};

struct  _list   *head;
struct  _list   *current;
struct  _list   *next;

FILE	*output;

main(int argc,char *argv[])
{
	FILE	*config;

    char    one_line[120];
	char    *result;

	char    *conf_path = "MLUPD.CFG";
	char	out_path[MAX_PATH];

    char    address[25];		/* Zone:Net/Node.Point */
    char    add_name[12];
    char    password[16];		/* ML-UPD password */
    char    phone[20];		/* Phone number */
    char    baud[6];		/* baud rate */
    char    name[MAX_PATH];		/* Board name */
    char    comment_1[MAX_PATH];		/* comments for file */
	char    comment_2[MAX_PATH];
	char	outbound[MAX_PATH];
	char	packer[MAX_PATH];
	char	collector[20];
	int 	this_area;
	int     mail = 0;		/* How to mail the output file */
    int     i;
	int     do_head = 0;
	int		infile = 0;
    long    now;
    struct  tm  *timept;


	cputs("MLUPD by Doug Boone, FidoNet 119/5 Copyright 1990, ? for help\n\r");

    head = current = next = NULL;

	if (argc > 1)
		conf_path = argv[1];

	else if ((result = getenv("PENGUIN")) != NULL) {
		conf_path = result;
        infile = 0;
        }

	if (strchr(conf_path,'?')) {
		cputs("\n\r\n\r Build ML-UPD compatible file for ML-COL and ML-FIND. But uses cofiguration\n\r");
		cputs(" file instead of SYSTEM*.BBS files. (makes it QuickBBS compatible) Also expands\n\r");
		cputs(" wildcards for Opus systems.\n\r\n\rUsage:\n\r");
		cputs("MLUPD [config.fil] \n\r\n\r Configuration name is optional, default to 'MLUPD.CFG'\n\r\n\r");
		cputs("Contact Doug Boone at FidoNet 119/5 if you find any problems. (916) 893-9019\n\r");
		cputs(" Copyright 1988\n\r\n\r");
		exit(5);
		}

	if ((config = fopen(conf_path,"rt")) == NULL) {
        perror("Failed to open configuration file ");
        exit(2);
        }

    memset(&comment_2,EOS,MAX_PATH);
	memset(&comment_1,EOS,MAX_PATH);
	memset(&collector,EOS,20);
	memset(&packer,EOS,MAX_PATH);
	memset(&outbound,EOS,MAX_PATH);
	memset(&baud,EOS,6);

	while ((result = fgets(one_line,90,config)) != NULL) {
		if ((result = strrchr(one_line,'\n')) != NULL)	/* get rid of trailing \n */
			*result = EOS;
		if ((result = strchr(one_line,';')) != NULL)		/* get rid of comments */
			*result = EOS;
		if (!(one_line[0]))
			continue;

		if (strnicmp(one_line,"BEGIN",5) == 0) {
			result = find_parm(one_line,5);
			if (strnicmp(result,"MLUPD",5) == 0)
				infile++;
			continue;
			}
		if (infile > 0 ) {			/* we're inside the MLUPD section */
			if (strnicmp(one_line,"ADDRESS",7) == 0) {
                result = find_parm(one_line,7);
                strcpy(address,result);
                if ((result = strchr(address,' ')) != NULL)
                    *result = EOS;
                if ((result = strchr(address,':')) != NULL)
					i = atoi(++result);
                else
                    i = atoi(address);
				result = strchr(address,'/');
				result++;
                sprintf(add_name,"%04X%04X",i,atoi(result));
                sprintf(out_path,"%04X%04X.MLU",i,atoi(result));
                if ((output = fopen(out_path,"wt")) == NULL) {
                    fclose(config);
                    perror("Failed to open output file");
                    exit(3);
                    }
                }

			else if (strnicmp(one_line,"PASSWORD",8) == 0) {
                result = find_parm(one_line,8);
                strcpy(password,result);
                if ((result = strchr(password,' ')) != NULL)
                    *result = EOS;
                }

			else if (strnicmp(one_line,"PHONE",5) == 0) {
                result = find_parm(one_line,5);
                strcpy(phone,result);
                strcpy(one_line,phone);
                memset(&phone,EOS,20);
                i=0;
				result = one_line;
                do {
					if (isdigit(*result)) {
                        phone[i] = *result;
                        i++;
                        }
                    result++;
					} while (*result != NULL && i<20);
                }

			else if (strnicmp(one_line,"BAUD",4) == 0) {
                int i;
                result = find_parm(one_line,4);
                for (i=0;i<6 && *result>' ';i++,result++)
                    baud[i] = *result;
                }

			else if (strnicmp(one_line,"name",4) == 0) {
                result = find_parm(one_line,4);
                strcpy(name,result);
                }

			else if (strnicmp(one_line,"comment:",8) == 0){
				result = one_line + 8*(sizeof(char));
				if (strlen(comment_1) == 0)
                    strcpy(comment_1,result);
                else
                    strcpy(comment_2,result);
                }

			else if (strnicmp(one_line,"scan",4) == 0) {
				result = find_parm(one_line,4);
                if (!head) {
                    head = (struct _list *) malloc(sizeof(struct _list));
                    current = head;
				    }
                else {
                    current->next = (struct _list *) malloc(sizeof(struct _list));
                    current = current->next;
				    }
                current->next = NULL;
                current->area = atoi(result);
                }		/* end of scan */

			else if (strnicmp(one_line,"packer",6) == 0) {
				result = find_parm(one_line,6);
				strcpy(packer,result);
				}
/* Shrink or Delete the outbound file after mailing? */
			else if (strnicmp(one_line,"shrink",6) == 0) {
                mail |= SHRINK;
				}

			else if (strnicmp(one_line,"delete",6) == 0) {
                mail |= DELETE;
				}
/* Decide how to handle outbound mail attach */
			else if (strnicmp(one_line,"hold",4) == 0) {
                mail |= HOLD;
				}
			else if (strnicmp(one_line,"direct",6) == 0) {
                mail |= DIRECT;
				}
			else if (strnicmp(one_line,"crash",5) == 0) {
                mail |= CRASH;
				}

			else if (strnicmp(one_line,"outbound",8) == 0) {
				result = find_parm(one_line,8);
				strcpy(outbound,result);
				if ((result = strchr(outbound,' ')) != NULL)
					*result = EOS;
				i = strlen(outbound) -1;
				if (outbound[i] != '\\')
					strcat(outbound,"\\");
				}

			else if (strnicmp(one_line,"collector",9) == 0) {
				result = find_parm(one_line,9);
				strcpy(collector,result);
				if ((result = strchr(collector,':')) != NULL) {
                    result++;
					strcpy(one_line,result);
					strcpy(collector,one_line);
					}
				if ((result = strchr(collector,' ')) != NULL)
					*result = EOS;
				}
			else if (strnicmp(one_line,"end",3) == 0) {
				result = find_parm(one_line,3);
				if (strnicmp(result,"MLUPD",5) == 0)
					infile = 0;
				}
            }		/* end of parsing configuration lines */
		}; 

    time(&now);
    timept = localtime(&now);
	fprintf(output,"* Created by MLUPD %s",ctime(&now));
	fprintf(output,"%s\n",address);
	fprintf(output,"%02d%02d%02d %s\n",timept->tm_year,
	    (1+timept->tm_mon),timept->tm_mday,password);
	fprintf(output,"%s\n",phone);
	fprintf(output,"%s\n",baud);
	fprintf(output,"%s\n",name);
	fprintf(output,"%s\n",comment_1);
	fprintf(output,"%s\n",comment_2);
	go_4_it();
	fprintf(output,"*EOF");
	flushall();
	fclose(config);
	fclose(output);
	do_head = 0;
    if (strlen(packer) > 0) {
		sprintf(one_line,"%s.MLA",add_name);
        unlink(one_line);
	    if ((result = strchr(packer,' ')) != NULL) {
		    *result = EOS;
			result++;
			if (strnicmp(packer,"arca",4) == 0)
				do_head = spawnlp(P_WAIT,packer,packer,one_line,out_path,result,NULL);
			else
				do_head = spawnlp(P_WAIT,packer,packer,result,one_line,out_path,NULL);
		    }
	    else
			do_head = spawnlp(P_WAIT,packer,packer,one_line,out_path,NULL);
		}

	if (strlen(outbound) > 0 &&
		strlen(collector) > 0) {
        i = atoi(collector);
        result = strchr(collector,'/');
        ++result;
        if (mail & CRASH)
            sprintf(name,"%s%04X%04X.CLO",outbound,i,atoi(result));
        else if (mail & HOLD)
            sprintf(name,"%s%04X%04X.HLO",outbound,i,atoi(result));
        else
            sprintf(name,"%s%04X%04X.DLO",outbound,i,atoi(result));
		if ((output = fopen(name,"at")) != NULL) {
			getcwd(one_line,MAX_PATH);
			strcat(one_line,"\\");
            strcat(one_line,add_name);
			if (do_head == 0)
                strcat(one_line,".MLA");
            else
                strcat(one_line,".MLU");
            if (mail & SHRINK)
    			fprintf(output,"#%s\n",one_line);
            else if (mail & DELETE)
    			fprintf(output,"^%s\n",one_line);
            else
    			fprintf(output,"%s\n",one_line);
            fclose(output);
            }
        else {
            cputs("\n\rFailed to open mail file!\n\r");
            free(one_line);
			exit(5);
			}
        }
	free(one_line);
	exit(do_head);
    return;
}

char    *find_parm(char *line,int  start)
{
    char    *step;

    step = line+start;
    while (isspace(*step) != 0)
        step++;
    return(step);
}


void go_4_it()
{
    struct  _afile  afile;
    struct  _numb_idx   nidx;
    int     datfh;
    int     ndxfh;
	long    next_key;
    long    pos;

    current = head;
    datfh = open("FILESBBS.DAT",O_RDONLY|O_BINARY);
    ndxfh = open("FILESBBS.ADX",O_RDONLY|O_BINARY);

    while (current != NULL) {
        lseek(ndxfh,0L,SEEK_SET);
        printf("\nWorking on area: %d",current->area);
        while (((read(ndxfh,(char *)&nidx,sizeof(struct _numb_idx))) == sizeof(struct _numb_idx)) &&
            (nidx.area_number != current->area));
        if (nidx.area_number == current->area) {
NEXT:       lseek(datfh,nidx.pos,SEEK_SET);
			while ((read(datfh,(char *)&afile,sizeof(struct _afile))) == sizeof(struct _afile)) {
                if (afile.area_number != current->area) {
                    if (next_key != 0L) {
                        nidx.pos = next_key;
                        next_key = 0;
                        goto NEXT;
                        }
                    else
                        goto Change;
                    }
                pos = (long) afile.altpath_len;
                pos += (long) afile.upld_by_len;
                pos += (long) afile.descr_len;
				lseek(datfh,pos,SEEK_CUR);
				if (afile.nxt_key != 0L)
					next_key = afile.nxt_key;
				if ((afile.aflag & IS_FILE) && (!(afile.aflag & (MISSING|DELETED|STAR_NAME))) && (afile.dl_priv < 0x80))
					fprintf(output,"%-12s   %2d  %3d\n",afile.name,afile.area_number,(afile.size/1024L));
				}		/* end of reading datfh */
			}		/* End of one area */
Change:	next = current->next;
		free(current);
		current = next;
		}
	close(datfh);
	close(ndxfh);
	return;
}

