/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*       (c) Copyright 1986, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                            YOOHOO-YOOHOO/2U2 is                          */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*            THIS MODULE HAS BEEN RELEASED TO THE PUBLIC DOMAIN            */
/*                                                                          */
/*                                                                          */
/* Compiler:          MicroSoft C, v4                                       */
/* Compiler switches: /Zp /Ox                                               */
/* Include files:     none                                                  */
/*                                                                          */
/* Origination:       25-May-1987, Wynn                                     */
/*                                                                          */
/* History:                                                                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------*/
/* The following material must be changed by you...                         */
/*--------------------------------------------------------------------------*/

#define PRODUCT_CODE -1    /* your program's FTSC identification            */
#define MAJVERSION   0     /* your program's major version                  */
#define MINVERSION   0     /* your program's minor version                  */
#define no_zapzed    0     /* 1 == can't do zmodem                          */

char   *our_name     = ""; /* system name (same as *ORIGIN line (?))        */
char   *sysop        = ""; /* sysop's name (optional)                       */

int     our_zone     = 0;
int     our_net      = 0;
int     our_node     = 0;



/*--------------------------------------------------------------------------*/
/* The following routines need to be coded by you...                        */
/*--------------------------------------------------------------------------*/

/* Miscellaneous routines... */

void n_init();    /* any init stuff... like zeroing the remoteX vars        */
int seconds();    /* returns the number of seconds from the system clock    */


/* Modem routines... */

extern int  CARRIER();        /* non-zero means carrier is present */
extern void CLEAR_INBOUND();  /* clear the inbound ring buffer */
extern void CLEAR_OUTBOUND(); /* clear the outbound ring buffer */
extern int  MODEM_IN();       /* read a byte from the other system */
extern void mdm_hangup();     /* disconnect */
extern int  PEEKBYTE();       /* non-destructive input */
extern void SENDBYTE();       /* transmit a byte */
extern int  TIMED_READ();     /* read (parm=max.sec. to wait) */
extern void brk_disable();    /* turn off ^C/^K sensitivity */
extern void XON_DISABLE();    /* turn off ^S sensitivity */


/* 16-Bit CRC routines... */

extern unsigned short crc_finish();
extern unsigned short crc_update();


/* MicroSoft C Library routines... */

extern int strncpy();         /* copy a string */
extern int memset();          /* set memory block to a value */
extern int cprintf();         /* display a formatted string */
extern int cputs();           /* display a string */








/*--------------------------------------------------------------------------*/
/* TIMER DEFINITIONS                                                        */
/*--------------------------------------------------------------------------*/
#define  set_timer(x)     ((x+seconds())%60)
#define  time_gone(x)     (seconds()==x)
#define  time_left(x)     (seconds()!=x)


/*--------------------------------------------------------------------------*/
/* LEGIBLE SECTION.  Definitions to make "C" look like a real language.     */
/*--------------------------------------------------------------------------*/
#define begin        {
#define end          }

#define true         (-1)
#define false        0
#define Procedure    void

#define shl          <<
#define shr          >>
#define xor          ^
#define and          &&
#define or           ||
#define not          !
#define mod          %

#ifndef max
#define max(a,b)     ((a)>(b)?(a):(b))
#endif

#ifndef min
#define min(a,b)     ((a)<=(b)?(a):(b))
#endif

typedef unsigned      bit;
typedef unsigned int  word;
typedef unsigned char byte;




/*--------------------------------------------------------------------------*/
/* COMMUNICATIONS DECLARATIONS                                              */
/*--------------------------------------------------------------------------*/
#define ACK    0x06
#define NAK    0x15
#define ENQ    0x05
#define YOOHOO 0xb0
#define TSYNC  0xae



/*--------------------------------------------------------------------------*/
/* THE YOOHOO STRUCTURE                                                     */
/*--------------------------------------------------------------------------*/
struct   _Hello
   begin
      word     signal;           /* always 'o'     (0x6f)                   */
      word     hello_version;    /* currently 1    (0x01)                   */
      word     product;          /* product code                            */
      word     product_maj;      /* major revision of the product           */
      word     product_min;      /* minor revision of the product           */
      char     my_name[60];      /* Other end's name                        */
      char     sysop[20];        /* sysop's name                            */
      word     my_zone;          /* 0== not supported                       */
      word     my_net;           /* out primary net number                  */
      word     my_node;          /* our primary node number                 */
      word     my_point;         /* 0== not supported                       */
      word     my_password[8];   /* currently unused                        */
      word     capabilities;     /* see below */
      word     reserved2[20];
   end; /* size 128 bytes */


/*--------------------------------------------------------------------------*/
/* YOOHOO<tm> CAPABILITY VALUES                                             */
/*--------------------------------------------------------------------------*/
#define Y_DIETIFNA 0x0001  /* Can do LoTek            0000 0000 0000 0001 */
#define Bit_1      0x0002  /* reserved by Opus        0000 0000 0000 0010 */
#define Bit_2      0x0004  /* reserved by Opus        0000 0000 0000 0100 */
#define ZED_ZAPPER 0x0008  /* Can do ZModem/plain     0000 0000 0000 1000 */
#define Bit_4      0x0010  /* reserved by Opus        0000 0000 0001 0000 */
#define Bit_5      0x0020  /* reserved by Opus        0000 0000 0010 0000 */
#define Bit_6      0x0040  /* reserved by Opus        0000 0000 0100 0000 */
#define Bit_7      0x0080  /* reserved by Opus        0000 0000 1000 0000 */
#define Bit_8      0x0100  /* reserved by Opus        0000 0001 0000 0000 */
#define Bit_9      0x0200  /* reserved by Opus        0000 0010 0000 0000 */
#define Bit_a      0x0400  /* reserved by Opus        0000 0100 0000 0000 */
#define Bit_b      0x0800  /* reserved by Opus        0000 1000 0000 0000 */
#define Bit_c      0x1000  /* reserved by Opus        0001 0000 0000 0000 */
#define Bit_d      0x2000  /* reserved by Opus        0010 0000 0000 0000 */
#define Bit_e      0x4000  /* reserved by Opus        0100 0000 0000 0000 */
#define WZ_FREQ    0x8000  /* accepts file requests   1000 0000 0000 0000 */


/*--------------------------------------------------------------------------*/
/* GLOBAL DATA                                                              */
/*--------------------------------------------------------------------------*/
int     remote_zone;
int     remote_net;
int     remote_node;
int     remote_point;
int     remote_capabilities;

char   *CARRIER_msg    = "CARRIER";
char   *SHRT_msg       = "SHORT PACKET";
char   *FUBAR_msg      = "TOO MANY ERRORS";
char   *CRC_msg        = "CRC ERROR";
char   *IDUNNO_msg     = "UNKNOWN ERROR";
char   *TIME_msg       = "TIMEOUT";




/*--------------------------------------------------------------------------*/
/* ROUTINES IN THIS MODULE                                                  */
/*--------------------------------------------------------------------------*/
int   send_YOOHOO(int);
int   get_YOOHOO();
int   send_Hello();





/*--------------------------------------------------------------------------*/
/* SEND HELLO: prepare and transmit the handshake packet                    */
/*                                                                          */
/* RETURNS: 1 ... packet transmitted and ACK'd                              */
/*          0 ... did not transmit the packet                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/
int send_Hello()
   begin
      int            i;
      struct _Hello  Hello;
      byte          *sptr;
      word           crc;
      word           num_errs = 0;


      /*--------------------------------------------------------------------*/
      /* Setup HELLO structure                                              */
      /*--------------------------------------------------------------------*/
      memset( (char *)&Hello, 0, sizeof(struct _Hello) );

      Hello.signal         = 'o';
      Hello.hello_version  =  1;
      Hello.product        = PRODUCT_CODE;
      Hello.product_maj    = MAJVERSION;
      Hello.product_min    = MINVERSION;

      strncpy( Hello.my_name, our_name, 58 );   /* make sure name is short */
      Hello.my_name[59]    = '\0';

      strncpy( Hello.sysop, sysop, 19 );
      Hello.sysop[19]      = '\0';

      Hello.my_zone        = our_zone;
      Hello.my_net         = our_net;
      Hello.my_node        = our_node;

      Hello.capabilities   = (no_zapzed)? Y_DIETIFNA: Y_DIETIFNA|ZED_ZAPPER;

/*
      if (ctl.matrix_mask&TAKE_REQ)
         Hello.capabilities |= WZ_FREQ;
*/


      /*--------------------------------------------------------------------*/
      /* Disable handshaking and ^C/^K handling                             */
      /*--------------------------------------------------------------------*/
      XON_DISABLE();
      brk_disable();

      /*--------------------------------------------------------------------*/
      /* Send the packet.                                                   */
      /* Load outbound buffer quickly, and get modem busy sending.          */
      /*--------------------------------------------------------------------*/
send: 
      SENDBYTE( 0x1f );

      if ( (num_errs++) > 10 )
         begin
         	cputs(FUBAR_msg);
            return 0;
         end

      sptr  = (char *)(&Hello);
      for(i=0; i<128; i++ ) SENDBYTE( sptr[i] );


      /*--------------------------------------------------------------------*/
      /* Clear inbound ring buffer                                          */
      /*--------------------------------------------------------------------*/
      CLEAR_INBOUND();


      /*--------------------------------------------------------------------*/
      /* Calculate CRC while modem is sending its buffer                    */
      /*--------------------------------------------------------------------*/
      for(crc=i=0;i<127;i++)
         crc = crc_update(crc,(byte )sptr[i]);
      crc = crc_finish(crc);

      CLEAR_INBOUND();

      SENDBYTE( crc>>8   );
      SENDBYTE( crc&0xff );

      i  = TIMED_READ(10);
      switch( i )
         begin
         	case ACK :  return 1;

            case '?' :  cputs("\rCRC");
                        goto send;

            default  :  if (i>0) cprintf("\r[%x] ",i);
                        return 0;
         end

   end /* Send Hello */








/*--------------------------------------------------------------------------*/
/* SEND YOOHOO                                                              */
/*                                                                          */
/* instigator==1 ... system originated the call                             */
/*                                                                          */
/* RETURNS: 1... connected with WaZOO system                                */
/*          C... connected with non-WaZOO netmail system                    */
/*          anything else... not connected                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
int send_YOOHOO(instigator)
   int instigator;
   begin
      int   timer_val;
      int   c;
      int   lastchar;

      timer_val   = set_timer(30);

      SENDBYTE(YOOHOO); /* <tm> */
      SENDBYTE(TSYNC);

      do
         begin

            c  = TIMED_READ(3);
            switch( c )
               begin
                  case -1  :  /*--------------------------------------------*/
                              /* TimeOut: Probably not an Opus              */
                              /*--------------------------------------------*/
                              if (lastchar=='C') goto in_progress;
                              goto nope;
      
                  case ENQ :  /*--------------------------------------------*/
                              /* Other end is curious                       */
                              /*--------------------------------------------*/
                              if (!send_Hello()) return 0;

                              if (instigator)
                                 begin
                                    if (TIMED_READ(5)==YOOHOO)
                                       return get_YOOHOO(0);
                                    cputs("\rNo YOOHOO/2U2");
                                    mdm_hangup();
                                 end

                              cputs( IDUNNO_msg );
                              return 0;

                  case 0x00:
                  case 0x01:  /*--------------------------------------------*/
                              /* See if XMODEM is already in progress       */
                              /*--------------------------------------------*/
                              if (lastchar=='C')   goto in_progress;
                              break;

                  case 0xfe:  /*--------------------------------------------*/
                              /* See if XMODEM is already in progress       */
                              /*--------------------------------------------*/
                              if (lastchar==0x01)  goto in_progress;
                              break;

                  case 'C' :  /*--------------------------------------------*/
                              /* See if XMODEM is already in progress       */
                              /*--------------------------------------------*/
                              if (lastchar=='C')   goto in_progress;
                              break;

                  case NAK :  /*--------------------------------------------*/
                              /* See if XMODEM is already in progress       */
                              /*--------------------------------------------*/
                              if (lastchar!=NAK) break;

in_progress:                  cputs( "On-line LoTek" );
                              return 'C';

               end /* switch */
            lastchar = c;
         end
      while( (CARRIER()) and (time_left(timer_val)) );

nope:
      cputs( (CARRIER())? TIME_msg: CARRIER_msg );
      return 0;
                        
   end /* send YooHoo */










/*--------------------------------------------------------------------------*/
/* GET YOOHOO                                                               */
/*                                                                          */
/* plan_to_send_too==1 ... We need to transmit a hello packet after we      */
/*                         receive one.  This normally is set when the      */
/*                         system is receiving the phone call... not by the */
/*                         originating system.                              */
/*                                                                          */
/* RETURN:  1... other system is WaZOO                                      */
/*          0... other system is NOT WaZOO                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
int get_YOOHOO( plan_to_send_too )
   int plan_to_send_too;
   begin
      int            i;
      int            c;
      struct _Hello  Hello;
      byte          *sptr;
      byte           num_errs = 0;
      int            timer_val;
      word           crc;
      word           lsb;
      word           msb;


      /* To get here, Opus has already read the YOOHOO */

      /*--------------------------------------------------------------------*/
      /* Let the other system know we understand and are curious.           */
      /*--------------------------------------------------------------------*/

      CLEAR_OUTBOUND();
      CLEAR_INBOUND();

      SENDBYTE(ENQ);

      /*--------------------------------------------------------------------*/
      /* Disable handshaking and ^C/^K handling                             */
      /*--------------------------------------------------------------------*/
      XON_DISABLE();
      brk_disable();

      /*--------------------------------------------------------------------*/
      /* Get the Hello structure                                            */
      /*--------------------------------------------------------------------*/
recv:
      timer_val   = set_timer(30);
      while(1)
         begin
            if ( (!(CARRIER())) or (time_gone(timer_val)) )
               begin
                  cputs(TIME_msg);
                  mdm_hangup();
                  goto failed;
               end
            else if (PEEKBYTE()>=0)
               begin
               	if (MODEM_IN()==0x1f) goto loop;
               end
         end

loop:
      sptr  = (char *)(&Hello);
      for(i=0; i<128; i++ )
         begin
            if ( (c=TIMED_READ(5)) < 0 ) goto failed;
            else sptr[i] = c;
         end

      if (!CARRIER()) goto failed;


      /*--------------------------------------------------------------------*/
      /* Calculate CRC                                                      */
      /*--------------------------------------------------------------------*/
      begin
         for(crc=i=0;i<127;i++)
            crc = crc_update(crc,(byte )sptr[i]);
         crc = crc_finish(crc);

         msb    = TIMED_READ(3);
         lsb    = TIMED_READ(3);

         if ((lsb<0)||(msb<0))
            begin
               cputs(SHRT_msg);
               goto err;
            end
         else if ( ((msb<<8)|lsb) != crc )
            begin
               cputs(CRC_msg);

err:           SENDBYTE('?');
               if ( (num_errs++) > 10 )
                  begin
                  	cputs(FUBAR_msg);
                     mdm_hangup();
                     goto failed;
                  end
               goto recv;
            end
      end


      CLEAR_INBOUND();

      Hello.my_name[45]    = '\0';
      Hello.sysop[19]      = '\0';
      remote_zone          = Hello.my_zone;
      remote_net           = Hello.my_net;
      remote_node          = Hello.my_node;
      remote_point         = Hello.my_point;
      remote_capabilities  = Hello.capabilities;

      cprintf( "%s (%u:%u/%u.%u)",
               Hello.my_name,
               remote_zone,
               remote_net,
               remote_node,
               remote_point);

      SENDBYTE(ACK);
      SENDBYTE(YOOHOO);

      if (plan_to_send_too)
         begin
            for(i=0; (CARRIER()) and (i<5); i++)
               begin
                  if ((c=TIMED_READ(5))==ENQ)
                     begin
                        return send_Hello()? 1: (n_init(),0);
                     end
                  else
                     begin
                        cprintf("[%x] ",c);
                        CLEAR_INBOUND();
                        SENDBYTE(YOOHOO);
                     end
               end
            goto failed;
         end

      return 1;

failed:
      n_init();
      return 0;

   end /* get_yoohoo */



/* END OF FILE: n_yoohoo.c */

