/* ML.H - headers for Message Library routines	*/
/*	Copyright (c) 1991 John W. Valentyn	*/
/*		all rights reserved		*/
 
/* (10U
                   indicator
                   field
           message        chain
            code          pointer    message text
          
          
              0 
    class           0=parameters in message
   component           1=no parameters in message
   code        message
               number
               (00-ff)                 parameter designator
                                        Ŀ
                                        
                                             
                                    flag         field size
                                     parameter   edit
                                        number 
                                              type
*/
 
#ifndef fallthrough
  typedef unsigned      bit;
  typedef unsigned int  word;
  typedef unsigned char byte;
  typedef unsigned char const * const  STRING;
  typedef unsigned long ulong;
# define fallthrough
#endif
 
/* define offsets for parameter designator */
#define PD_FLAG	0
#define PD_NO	1
#define PD_TYPE	3
#define PD_EDIT	4
#define PD_SIZE	5
 
typedef struct _ml_pd {	/* parameter designator */
	char flag;
	char p_no[2];		/* parameter number */
	char type;		/* parameter type */
	char edit;		/* parameter edit */
	char size[2];		/* field size */
} ML_PD;
 
/* define offsets for message */
#define MSGNO 0
#define IND0  5
#define IND1  6
#define MSGNXT 7
#define TEXT  12
 
typedef struct _ml {
	char msg_no[5];
	char ind_0;
	char indicator;
	char chain[5];
	byte text[240];
	char filler[2];
} ML;
 
#define ML_SIZE sizeof(ML)	/* maximum record length */
#define KEY_SZ 5
 
typedef struct _wml {
word	length;		/* length (in bytes) of message */
word	status;		/* return status */
byte	buffer[82];	/* work buffer for editing parameter */
word	buffsz;		/* size of parameter in work buffer */
word	asize;		/* length of argument string */
word	pno;		/* current parameter number */
word	fsize;		/* size of parameter field in message */
byte	edopt;		/* editing option from parameter descriptor */
byte	ptype;		/* parameter type */
word	inds;		/* local indicators */
} WML;
 
 
/*	error codes	*/
 
#define	err1	0x0870	/* illegal character string pointer */
#define	err2	0x0871	/* illegal number of descriptors in list */
#define	err3	0x0872	/* illegal character string size */
#define	err4	0x0873	/* illegal parameter designator */
#define	err5	0x0874	/* illegal parameter descriptor */
#define	err6	0x0875	/* truncation */
#define	err7	0x0876	/* unbalanced brackets */
#define	err8	0x0877	/* zero length character string after formatting */
#define	err9	0x0878	/* illegal translation record */

/***************  General purpose Symbolic constants:  ****************/
#define TRUE	   1		/* general purpose true truth value   */
#define FALSE	   0		/* general purpose false truth value  */
#define CONTINUOUS 2    	/* continuous screens                 */
#ifndef ERROR
#define ERROR   (-1)
#endif
#ifndef OK
#define OK      1
#endif
 
#define EOS	'\0'		/* standard end of string */
#define ESC	'\x1b'		/* ESCape character */

 /* global storage for message library */
extern byte mlbuf[];
extern byte p_flag;	/* '^'  parameter designator flag */
extern byte p_left;	/* '['  leading delimiter */
extern byte p_right;	/* ']'  trailing delimiter */
 
/* function prototypes for mesage library functions */
int init_ml(byte *);
byte * cdecl rtnmsg(const unsigned, ...);
void cdecl rptmsg(const unsigned, ...);
byte *msgsec(const unsigned, int);
int  cdecl getmsg(char *, va_list);
 
/* ml.h */
