name memshow
title memshow.asm
subttl Copyright (C) 1990 G. Adam Stanislav. All Rights Reserved.
page 66, 132
.radix 16
.model small

comment %

        This is an assembly version of memdisp.c Because of less
        overhead it is much faster. However, because it uses
        int 29 and 79, this program cannot be simply redirected
        to a com port while the C version can.

        Programmed by: G. Adam Stanislav
        Started on: August 13, 1990
        Completed:  August 15, 1990

%

; macros
print   macro   string, stringlen
        local   start

        mov     cx, stringlen
        push    si
        lea     si, string

start:
        lodsb
        int     29
        loop    start
        pop     si

endm

page
.data

hello   db      16, 12          ; ^V ^R = reset the driver
        db      0C              ; ^L    = cls
        db      0Dh             ; carriage return (if no AVT found)
        db      "memshow.exe: "
        db      "Copyright (C) 1990, G. Adam Stanislav. "
        db      "All Rights Reserved.", 0Dh, 0A
hellolen equ    $-hello
        db      "Sorry, this program requires AVATAR console.", 0Dh, 0A, 0A
sorrylen equ    $-hello
query   db      16, 11, 11      ; ^V ^Q ^Q
querylen equ    $-query
buffer  db      80 dup('*')
avt     db      'AVT'
setup   db      16, 08, 15, 01  ; locate 21, 1
        db      "Controls: PgUp and PgDn: offset +/- 100. ^PgUp and ^PgDn: "
        db      "segment +/- 1000.", 0Dh, 0A
        db      "Alt-PgUp and Alt-PgDn: offset +/- 1000 (enhanced keyboard "
        db      "only).", 0Dh, 0A
        db      16, 01, "oPress <ESC> to quit."
        db      16, '=R'        ; switch to raw parser mode
        db      16, 16, 'G'     ; define window 'G'
        db      03, 03, 01, 14, 50      ; attribute: 3, corners: 3, 1, 20, 80
        db      16, 17, 'G'     ; switch to window 'G'
        db      16, 0F          ; turn clockwise mode on
        db      0C9, 19, 0CDh, 09, 0D1h, 19, 0CDh, 44, 0BBh, 19, 0BAh
        db      10, 0BCh, 19, 0CDh, 44, 0CF, 19, 0CDh, 09, 0C8, 19
        db      0BAh, 10        ; draw the frame
        db      16, 1E          ; turn vertical mode on
        db      16, 08, 02, 0Bh ; locate start of thin line
        db      19, 0B3, 10     ; draw the thin line
        db      16, 16, 'G'     ; redefine window 'G'
        db      03, 04, 02, 13, 0A ; attrib.: 3, corners, 4, 2, 19, 10
        db      16, 08, 01, 01  ; locate 1, 1
        db      19, '0', 40     ; print a bunch of zeros
        db      19, ':', 10     ; print 16 colons vertically
        db      19, '0', 20     ; more zeros
hextbl  db      "0123456789ABCDEF"
        db      16, 22          ; turn wrap off
        db      19, '0', 10     ; and even more zeros
        db      16, 16, 01      ; define window 1
        db      07, 04, 0C, 13, 4F ; attr:7, corners: 4, 12, 19, 79
        db      16, 17, 01      ; switch to window 1
        db      16, 27, 02      ; hide the cursor
setuplen equ    $-setup
aline   db      ' 00 00 00 00 00 00 00 00-00 00 00 00 00 00 00 00  '
dots    db      '................', 0Dh, 16, 04
alinelen equ    $-aline
cleanup db      16, 12          ; reset the driver
        db      16, 08, 18, 01  ; locate 24, 1
cleanuplen equ  $-cleanup
newoffs db      16, 17, 'G'     ; switch to window 'G'
        db      16, 08, 01, 06  ; locate 1, 6
        db      19              ; repeat ...
noffs1  db      0               ; high byte of new offset ...
        db      10, 0Dh, 0A     ; 16 times
        db      19              ; repeat ...
noffs2  db      0               ; low byte of new offset ...
        db      10              ; 16 times
        db      16, 17, 01      ; return to window 1
newoffslen equ  $-newoffs
newseg  db      16, 17, 'G'     ; switch to window 'G'
loc11   db      16, 08, 01, 01  ; locate 1, 1
loc11len equ    $-loc11
        db      19              ; repeat ...
nseg1   db      0               ; highest byte of segment ...
        db      10              ; 16 times
        db      16, 17, 01      ; go back to window 1
newseglen equ   $-newseg
beep    db      16, 13, 0A, 00, 02      ; play middle 'F' for .2 sec
        db      16, 13, 04, 00, 04      ; play middle 'C' for .4 sec
beeplen equ     $-beep

even
doffs   dw      0       ; starting offset to display in a window
dseg    dw      0       ; segment to display

page
.code

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;      This is the main routine of the program which displays
;;      the memory contents in window 1
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
show:
        print   loc11, loc11len ; locate 1, 1 in window 1
        push    ds
        mov     ax, doffs
        mov     si, ax          ; starting offset
        mov     ax, dseg
        mov     ds, ax          ; segment
        mov     cx, 10          ; larger counter

outer_loop:
        push    cx
        mov     cx, 10          ; smaller counter
        lea     di, dots
        lea     bx, aline

inner_loop:
        lodsb
        call    printhex
        cmp     al, ' '
        jae     inner_loop_1
        mov     al, '.'

inner_loop_1:
        stosb
        loop    inner_loop
        push    ds
        mov     ax, es
        mov     ds, ax
        push    bx
        print   aline, alinelen
        pop     bx
        pop     ds
        pop     cx
        loop    outer_loop

        pop     ds
        ret

printhex:
        ; convert the byte to a 2-digit hex number
        push    ax
        push    ds

        push    es
        pop     ds
        push    bx
        lea     bx, hextbl
        push    ax
        and     al, 0F
        xlat    hextbl
        mov     dl, al
        pop     ax
        shr     al, 1
        shr     al, 1
        shr     al, 1
        shr     al, 1
        xlat    hextbl
        pop     bx
        inc     bx      ; skip the blank or dash
        mov     [bx], al
        inc     bx
        mov     [bx], dl
        inc     bx      ; point at next blank or dash

        pop     ds
        pop     ax
        ret

begin:
        mov     ax, _data
        mov     ds, ax
        mov     es, ax
        cld

; Check if AVATAR console is loaded by sending a query and reading the reply

        print   query, querylen
        lea     di, buffer

        mov     cx, 80
        sub     bx, bx          ; Count the number of characters
small_loop:
        int     79              ; Read from stdin
        jc      outaloop
        cmp     al, 0Dh         ; Carriage return?
        je      outaloop
        stosb
        inc     bx
        loop    small_loop

outaloop:
        lea     si, buffer
        lea     di, avt
        mov     cx, 3
repe    cmpsb                   ; Compare the two strings
        je      program

        print   hello, sorrylen
        ; quit
        mov     ax, 4C02
        int     21

program:
        print   hello, hellolen
        print   buffer, bx

        ; create necessary windows, print help, etc.
        print   setup, setuplen

bigloop:
        call    show            ; display a window full

keycheck:
        int     79
        jc      bigloop

        ; a key was pressed, see what it was
        cmp     al, 1Bh         ; escape?
        jne     fkey

done:
        print   cleanup, cleanuplen
        ; quit
        mov     ax, 4C00
        int     21

fkey:
        ; check if it was a function key
        or      al, al
        je      findfkey        ; yes, find out what it is
        jmp     badkey          ; beep

findfkey:
        int     79              ; read the function key

        ; it was a function key, see which one
        cmp     al, 49          ; Page Up?
        jne     fkey_1
        sub     doffs, 100

writeoffset:
        mov     ax, doffs
        lea     bx, hextbl
        mov     al, ah
        and     al, 0F
        xlat    hextbl
        mov     noffs2, al
        mov     al, ah
        shr     al, 1
        shr     al, 1
        shr     al, 1
        shr     al, 1
        xlat    hextbl
        mov     noffs1, al
        print   newoffs, newoffslen
        jmp     keycheck        ; maybe the key is being held down

fkey_1:
        cmp     al, 51          ; Page Down?
        jne     fkey_2
        add     doffs, 100
        jmp     short writeoffset

fkey_2:
        cmp     al, 99          ; Alt-PgUp of enhanced keyboard?
        jne     fkey_3
        sub     doffs, 1000
        jmp     writeoffset

fkey_3:
        cmp     al, 0A1         ; Alt-PgDn of enhanced keyboard?
        jne     fkey_4
        add     doffs, 1000
        jmp     writeoffset

fkey_4:
        cmp     al, 84          ; ^PgUp?
        jne     fkey_5
        sub     dseg, 1000

writesegment:
        mov     ax, dseg
        mov     al, ah
        shr     al, 1
        shr     al, 1
        shr     al, 1
        shr     al, 1
        lea     bx, hextbl
        xlat    hextbl
        mov     nseg1, al
        print   newseg, newseglen
        jmp     keycheck        ; maybe the key is being held down

fkey_5:
        cmp     al, 76          ; ^PgDn?
        jne     fkey_6
        add     dseg, 1000
        jmp     writesegment

fkey_6:
        ; invalid key was pressed
badkey:
        print   beep, beeplen
        jmp     keycheck        ; see if another key was pressed

.stack
        db      128 dup('Adam')

end     begin

