/*****************************************************************************

   Program: memdisp.c
   Author: G. Adam Stanislav
   Date started: August 11, 1990
   Date completed:
   Purpose: Read contents of various locations and display them
            using AVATAR console


   Copyright (C) 1990, G. Adam Stanislav
   AVATAR and AVATAR console are trademarks of G. Adam Stanislav and
   Stanislav Publishing.

*****************************************************************************/


#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <memory.h>

#define locate(Xpos,Ypos) printf("\x16\x08%c%c",Xpos,Ypos)

void memdisp(void);
void newsegment(unsigned);
void newoffset(unsigned);
int  usage(void);

static char two_strings[] = "%s%s";
static char hello[] = "\x16\x12"    /* ^V ^R = reset the driver */
                      "\x0C"        /* ^L    = clear the screen */
                      "\b\b\bmemdisp.exe: "
                      "Copyright (C) 1990, G. Adam Stanislav.\n";

static char beep[]  = "\x16\x13\x10\x9A\x10\x80\x02"
                      "\x16\x13\x04\x10\x80\x04";


int main(int argc, char *argv[]) {
   register i, ch;
   char buffer[80];
   int  flag = 0;

   if (argc > 1) {
      if (argc > 2) return (usage());
      if ( ((i = argv[1][0]) != '-') && (i != '/') )
         return(usage());
      if (strnicmp(argv[1] + 1, "nocheck", strlen(argv[1]) - 1) != 0)
         return(usage());
      flag = 1;
      buffer[0] = '\0';
   }

   if (flag == 0) {
      printf("\x16\x11\x11");   /* ^V^Q^Q = query the driver */

      for (i=0; i < 80, kbhit(); i++)
         if ((ch = getch()) == (int)'\r') {
            buffer[i] = '\0';
            break;
         }
         else
            buffer[i] = (char)ch;

      if (strncmp(buffer, "AVT", 3)) {
         printf(two_strings,
                hello+3,
                "AVATAR console not detected. Program aborting.");
         return 2;
      }
   }

   printf(two_strings, hello, buffer);
   locate(21, 1);
   printf("Controls: PgUp and PgDn offset +/- 100. ^PgUp and ^PgDn segment"
           " +/- 1000.\n"
          "Alt-PgUp and Alt-PgDn offset +/- 1000 (enhanced keyboard only).\n"
          "\x16\x01oPress <ESC> to quit.");

   memdisp();
   printf("\x16\x12");       /* reset the driver */
   locate(24, 1);

   return 0;
}

void memdisp(void) {

   unsigned int    register  i;  
   unsigned char   register *ptr;
   char     far   *address;
   unsigned        segment, offset;
   unsigned        bsegment, boffset;
   unsigned char   buffer[256];
   char            userhit;

   printf("\x16\x16G"      /* define window 'G' */
          "\x03\x03\x01\x14\x50"  /* attrib: 3, corners: 3, 1, 20, 80 */
          "\x16\x17G"      /* switch to window 'G' */
          "\x16\x0F"       /* turn clockwise mode on */
          "\xC9\x19\xCD\x10\x89\xD1\x19\xCD\x44\xBB\x19\xBA\x10\x90\xBC"
          "\x19\xCD\x44\xCF\x19\xCD\x10\x89\xC8\x19\xBA\x10\x90"/* frame */
          "\x16\x1E"       /* turn vertical mode on */
          "\x16\x08\x02\x0B"  /* locate start of thin line */
          "\x19\xB3\x10\x90"  /* draw the thin line */
          "\x16\x16G"      /* redefine window 'G' */
          "\x03\04\x02\x13\x10\x9A" /* attr: 3, corners: 4, 2, 19, 10 */
          "\x16\x08\x01\x01"  /* locate 1, 1 */
          "\x19\x30\x40"      /* print 0's */
          "\x19\:\x10\x90"      /* print 16 colons vertically */
          "\x19\x30\x20"      /* print 0's */
          "0123456789ABCDEF"
          "\x16\x22"          /* turn wrap off */
          "\x19\x30\x10\x90"      /* print 0's */
          "\x16\x16\x01"      /* define window 1 */
          "\x07\x04\x0C\x13\x4F" /* attr: 7, corners: 4, 12, 19, 79 */
          "\x16\x17\x01"      /* switch to window 1 */
          );

   segment = offset = 0;

   address = (void far *)buffer;
   bsegment = FP_SEG(address);
   boffset  = FP_OFF(address);

   for (;;) {
      do {
         locate(1, 1);
         movedata(segment, offset, bsegment, boffset, 256);

         for (i = 0; i < 256; i += 16) {
            ptr = buffer + i+15;
            printf(" %.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X"
                   "-%.2X %.2X %.2X %.2X %.2X %.2X %.2X %.2X",
                   *ptr--, *ptr--, *ptr--, *ptr--,
                   *ptr--, *ptr--, *ptr--, *ptr--,
                   *ptr--, *ptr--, *ptr--, *ptr--,
                   *ptr--, *ptr--, *ptr--, *ptr--);
            ptr = buffer + i+15;
            printf("  %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c\r\x16\x04",
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.',
                   (*ptr-- >= ' ') ? ptr[1] : '.');

         }
      } while (!kbhit());

      if ((userhit = getch()) == '\x1b')
         return;

      if (userhit == '\0')
         switch (getch()) {

            case 0x49:        /* Page Up */
               newoffset(offset -= 0x100);
               break;
            case 0x51:        /* Page Down */
               newoffset(offset += 0x100);
               break;
            case 0x84:        /* ^Page Up */
               newsegment(segment -= 0x1000);
               break;
            case 0x76:        /* ^Page Down */
               newsegment(segment += 0x1000);
               break;
            case 0x99:        /* Alt-Page Up - enhanced kbd only */
               newoffset(offset -=0x1000);
               break;
            case 0xA1:           /* Alt-Page Down - same restrcition */
               newoffset(offset +=0x1000);
               break;
            default:
               printf(beep);
         }
      else printf(beep);
   }
}

void newoffset(unsigned offset) {

   printf("\x16\x17G"   /* switch to window 'G' */
          "\x16\x08\x01\x06" /* locate 1,6 */
          "\x19%X\x10\x90\n" /* print the high byte 16 times */
          "\x19%X\x10\x90"   /* print the low byte 16 times */
          "\x16\x17\x01",    /* return to window 1 */
          offset >> 12,      /* the new offset */
          ((offset >> 8) & 0x0f));

}

void newsegment(unsigned segment) {

   printf("\x16\x17G"   /* switch to window 'G' */
          "\x16\x08\x01\x01" /* locate 1,1 */
          "\x19%X\x10\x90"   /* print the new segment 16 times */
          "\x16\x17\x01",    /* return to window 1 */
          segment >> 12);    /* the new segment */

}

int usage(void) {

   printf("\nUsage:\n\n\tmemdisp [-nocheck]\n\n");
   return 2;
}

