{$O+,I-} unit V7_Eng;

interface

uses
 {Unitname   Description                                 Available }
  Use32,     {16/32 bit types (used in the os/2 version) N         }
  BpUtils,   {Basic tools                                N         }
  Strings;   {Basic library borland pascal               N(Library)}

const
  {Values for the NodeFlag field }
  nfHub    = $0001;  { node is a net hub     00000000 00000001}
  nfHost   = $0002;  { node is a net host    00000000 00000010}
  nfRegion = $0004;  { node is region coord  00000000 00000100}
  nfZone   = $0008;  { node is a zone coord  00000000 00001000}
  nfCM     = $0010;  { runs continuous mail  00000000 00010000}
  nfPoint  = $1000;  { node is a point       00010000 00000000}

type
  V7Indexes = (NodexNdx,SysopNdx,NodexDat);

  { some typo's you'll need
  (byte      = 8 bit unsigned)
  (char      = 8 bit unsigned)
  (Smallword = 16 bit unsigned)
  (integer   = 16 bit signed)
  (longint   = 32 bit signed)

  TPthStr      = array[0..079] of char;
  TStr64       = array[0..063] of char;
  TStr256      = array[0..255] of char;
  TStr512      = array[0..511] of char;

  PAddress = ^TAddress;
  TAddress = record
    zone   : SmallWord;
    net    : SmallWord;
    node   : SmallWord;
    point  : SmallWord);
  end;}

  V7Rec          = record                     { Unpacked V7 record        }
    Address      : Taddress;                  { Address                   }
    CallCost     : SmallWord;                 { Cost to sysop to send     }
    MsgFee       : SmallWord;                 { Cost to user to send      }
    NodeFlags    : SmallWord;                 { Node flags                }
    ModemType    : byte;                      { Modem type                }
    {------------------- Equals until here -------------------------------}
    Baud         : SmallWord;                 { Highest Baud Rate         }
    RecSize      : SmallWord;                 { Size of the node on file  }
    Phone        : TStr64;                    { Phone Number              }
    PassW        : TStr64;                    { PassWord                  }
    BName        : TStr64;                    { Board Name                }
    SName        : TStr64;                    { Sysop Name                }
    CName        : TStr64;                    { City/State Name           }
  end;


  V7Dat          = record                     { Packed V7 record          }
    Address      : Taddress;                  { Address (Hub routed)      }
    CallCost     : SmallWord;                 { Cost to sysop to send     }
    MsgFee       : SmallWord;                 { Cost to user to send      }
    NodeFlags    : SmallWord;                 { Node flags                }
    ModemType    : byte;                      { Modem type                }
    {------------------- Equals until here -------------------------------}
    PhoneLen     : byte;                      { Length of Phone Number    }
    PassWLen     : byte;                      { Length of PassWord        }
    BNameLen     : byte;                      { Length of Board Name      }
    SNameLen     : byte;                      { Length of Sysop Name      }
    CNameLen     : byte;                      { Length of City/State Name }
    PackLen      : byte;                      { Length of Packed String   }
    Baud         : byte;                      { Highest Baud Rate         }
    Pack         : TStr256;                   { Packed String             }
  end;


  V7Idx          = record                     { structure index files     }
    case byte of                              { 512 bytes                 }
    0:(CtlBlkSize    : SmallWord;             { Blk Size                  }
       CtlRoot       : LongInt;               { Blk number of Root        }
       CtlHiBlock    : LongInt;               { Blk number of Last blk    }
       CtlLoLeaf     : LongInt;               { Blk number of First leaf  }
       CtlHiLeaf     : LongInt;               { Blk number of Last leaf   }
       CtlFree       : LongInt;               { Head of freelist   (?)    }
       CtlLevels     : SmallWord;             { Number of index levels    }
       CtlParity     : SmallWord);            { XOR of above fields       }
    1:(IdxFirst      : LongInt;               { Blk number of lower level }
       IdxPrev       : LongInt;               { Blk number of prev link   }
       IdxNext       : LongInt;               { Blk number of next link   }
       IdxCnt        : SmallWord;             { Cnt of Items in block     }
       IdxStr        : SmallWord;             { Ofs in block of 1e str    }
       case byte of
       0:(IndexRef   : array[0..40] of record { if idxfirst <> -1         }
            StrOfs   : SmallWord;             { Ofs into StrBuf[]         }
            StrLen   : SmallWord;             { Len of str                }
            DatPtr   : LongInt;               { Ptr into nodex.dat        }
            Child    : LongInt;               { Child blk nr (lower index)}
          end);
       1:(LeaveRef   : array[0..61] of record { if idxfirst == -1         }
            StrOfs   : SmallWord;             { Ofs into StrBuf[]         }
            StrLen   : SmallWord;             { Len of str                }
            DatPtr   : LongInt;               { Ptr into nodex.dat        }
          end));
    2:(StrBuf        : TStr512);
  end;


  {!!!!!!!!!!!!!!!!!!!exprimental!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
  V8Dat          = record                     { Packed V8 record          }
    Address      : tAddress;                  { Address (Hub routed)      }
    CallCost     : SmallWord;                 { Cost to sysop to send     }
    MsgFee       : SmallWord;                 { Cost to user to send      }
    NodeFlags    : Longint;                   { Node flags                }
    ModemType    : Longint;                   { Modem type                }
    Pack         : TStr512;                   { Packed String             }
  end;



function Btree(var f:File;var CurIdx:integer;desired:pchar;Index:V7Indexes):longInt;

function GetV7Data(var F:File;SL:LongInt;var Pack:V7Dat;var Unp:V7Rec):Boolean;
function GetV7Parity(NodeP:V7Idx):SmallWord;

function WrapName(Dst,Src:pchar):pchar;
function MakeProp(Src:pchar):pchar;


function CompAddr(A,B:pointer;Cnt:Word):integer;
function CompName(A,B:pointer;Cnt:Word):integer;


implementation


function CompName(A,B:pointer;Cnt:Word):Integer;
begin
  CompName:=StrLiComp(@A^,@B^,Cnt);
end;

{$ifdef dos}
function CompAddr(A,B:pointer;Cnt:Word):integer;
assembler;asm
        cld
        xor     ax,ax
        MOV     BX,DS
        LDS     SI,A
        LES     DI,B
        MOV     CX,Cnt
        SHR     CX,1
@C:     cmpsw
        jb      @B
        ja      @G
        loop    @C
        je      @X
  @G:   inc     ax
        jmp     @X  {A>B}
  @B:   dec     ax  {A<B}
  @X:   MOV     DS,BX
end;
{$else}
function CompAddr(A,B:pointer;Cnt:Word):integer;
assembler;{$USES EBX,esi,EDI} {$FRAME-}asm
        CLD
        MOV     ESI,A
        MOV     EDI,B
        XOR     EAX,EAX
        MOV     ECX,Cnt
        SHR     ECX,1
@C:     cmpsw
        jb      @B
        ja      @G
        loop    @C
        je      @X
  @G:   inc     EAX
        jmp     @X  {A>B}
  @B:   DEC     EAX {A<B}
  @X:
end;
{$endif}

function GetV7Parity(NodeP:V7Idx):SmallWord;
{Calculate Control parity}
var x,par:smallword;
  p:psmallword;
begin
  par:=0; p:=@NodeP;
  for x:=1 to 12 do begin
    par := par xor p^;
    inc(p);
  end;
  GetV7Parity:=par;
end;



{$ifdef dos}
function MakeProp(Src:pchar):pchar;
{MARIUS ELLEN -> Marius Ellen}
assembler;asm
        push    ds
        lds     si,Src
        mov     cx,si
        mov     dx,$2041
        mov     bx,$1961
        dec     si
@Vs:    mov     AH,1      {AL!=karakter}
@Vr:    inc     si
        mov     al,[si]
        and     al,al
        je      @V3
        sub     al,bl     {AL in [a..z]?}
        Cmp     al,bh
        ja      @V1
        shr     AH,1      {to upper?}
        jnc     @Vr
        sub     [si],dh
        jmp     @Vr
@V1:    add     al,dh     {AL in [A..Z]?}
        CMP     al,bh
        ja      @Vs
@V2:    shr     AH,1      {to lower?}
        jc      @Vr
        add     [si],dh
        jmp     @Vr
@V3:    mov     ax,cx
        mov     dx,ds
        pop     ds
end;
{$else}
function MakeProp(Src:pchar):pchar;
{MARIUS ELLEN -> Marius Ellen}
assembler;{$USES EBX,ESI} {$FRAME-}asm
        MOV     ESI,Src
        mov     ECX,ESI
        mov     dx,$2041
        mov     bx,$1961
        dec     ESI
@Vs:    mov     AH,1      {AL!=karakter}
@Vr:    inc     ESI
        mov     al,[ESI]
        and     al,al
        je      @V3
        sub     al,bl     {AL in [a..z]?}
        CMP     al,bh
        ja      @V1
        shr     AH,1      {to upper?}
        jnc     @Vr
        sub     [ESI],dh
        jmp     @Vr
@V1:    add     al,dh     {AL in [A..Z]?}
        Cmp     al,bh
        ja      @Vs
@V2:    shr     AH,1      {to lower?}
        jc      @Vr
        add     [ESI],dh
        jmp     @Vr
@V3:    mov     eax,ecx
end;
{$endif}

function WrapName(Dst,Src:pchar):pchar;
{Marius Ellen -> Ellen, Marius}
var p:pchar;
begin
  StrTrim(Src); WrapName:=Dst;
  Dst[0]:=#0; P:=StrRScan(Src,' ');
  if P=nil then StrCopy(Dst,Src) else begin
    StrCopy(StrECopy(Dst,P+1),', ');
    P^:=#0; StrCat(Dst,StrTrim(Src));
  end;
end;

{$ifdef dos}
procedure UnPackPoly40(dst,src:pchar;cnt:SmallWord);
{GetV7Data decompress Bname, Cname and Sname}
assembler;asm
        cld
        push    ds
        lds     si,src
        les     di,dst
        mov     cx,cnt
        shr     cx,1
        je      @Exit
        jmp     @Rep

@Table: db ' EANROSTILCHBDMUGPKYWFVJXZQ-''0123456789';
           {01234567890123456789012345678 9012345678}

@rep:   lodsw
        add     di,2
        xor     dx,dx
        mov     bx,40
        div     bx
        mov     bx,dx
        mov     DL,byte ptr @Table[bx]
        mov     es:[di],DL
        DEC     DI

        xor     dx,dx
        mov     bx,40
        div     bx
        mov     bx,dx
        mov     DL,byte ptr @Table[bx]
        mov     es:[di],DL
        DEC     DI

        xor     dx,dx
        mov     bx,40
        div     bx
        mov     bx,dx
        mov     DL,byte ptr @Table[bx]
        mov     es:[di],DL
        add     di,3

        loop    @rep
@Exit:  pop     ds
end;
{$else}
procedure UnPackPoly40(dst,src:pchar;cnt:SmallWord);
{GetV7Data Bname, Cname and Sname}
assembler; {$USES EBX,esi,EDI} {$FRAME-} asm
        cld
        mov     esi,src
        mov     EDI,dst
        xor     ecx,ecx
        mov     cx,cnt
        shr     ecx,1
        je      @Exit
        jmp     @Rep

@Table: db ' EANROSTILCHBDMUGPKYWFVJXZQ-''0123456789';
           {01234567890123456789012345678 9012345678}

@rep:   xor     EAX,EAX
        lodsw
        add     EDI,2
        xor     EDX,EDX
        mov     EBX,40
        div     EBX
        mov     EBX,EDX
        mov     DL,byte ptr @Table[EBX]
        mov     [EDI],DL
        DEC     EDI

        xor     EDX,EDX
        mov     EBX,40
        div     EBX
        mov     EBX,EDX
        mov     DL,byte ptr @Table[EBX]
        mov     [EDI],DL
        DEC     EDI

        xor     EDX,EDX
        mov     EBX,40
        div     EBX
        mov     EBX,EDX
        mov     DL,byte ptr @Table[EBX]
        mov     [EDI],DL
        add     EDI,3

        loop    @rep
@Exit:
end;
{$endif}


function GetV7Data(var F:File;SL:LongInt;var Pack:V7Dat;var Unp:V7Rec):Boolean;
var Buffer:TStr256;
  Len,Rd:Word;
  Bd:longint;
  P:pchar;
begin
  Seek(F,SL);
  BlockRead(F, Pack, SizeOf(Pack),Rd);
  Len:=SmallWord(22)+Pack.PhoneLen+Pack.PassWLen+Pack.PackLen;
  fillchar(Unp,SizeOf(Unp),#0);
  if (IOResult<>0) or (Rd<22) or (Wordrec(Len).hi<>0)
  then GetV7Data:=false
  else begin
    Move(Pack,Unp,15);

    P:=Pack.Pack;
    Move(P^,Unp.Phone,Pack.PhoneLen); Inc(P,Pack.PhoneLen);
    Move(P^,Unp.Passw,Pack.PassWLen); Inc(P,Pack.PassWLen);

    UnPackPoly40(Buffer,P,Pack.PackLen);

    P:=Buffer;
    Move(P^,Unp.Bname,Pack.BNameLen); Inc(P,Pack.BNameLen);
    Move(P^,Unp.Sname,Pack.SNameLen); Inc(P,Pack.SNameLen);
    Move(P^,Unp.Cname,Pack.CNameLen); Inc(P,Pack.CNameLen);

    StrTrim(UnP.Bname);
    StrTrim(UnP.Sname);
    StrTrim(UnP.Cname);

    {trouble with hi baudrate}
    Bd:=Pack.Baud*longint(300);
    if Bd<65536
    then Unp.Baud       :=Bd
    else Unp.Baud       :=65535;
    Unp.RecSize :=Len;
    GetV7Data   :=true;
  end;
end;




function Btree(var f:File;var CurIdx:Integer;Desired:pchar;Index:V7Indexes):longInt;
{Search in index file to desired string. (starts always at the root)}
label Return;
var Rec,Loc:longInt;
  Node,Ctrl:V7Idx;
  Cnt,Idx,Cmp,Len,Pos,Lvl:Integer;
  Ad:Taddress;
  ap:paddress;
  pc:pchar absolute ap;

  function CompItem:SmallInt;
  begin
    if Node.IdxFirst<>-1 then begin
      Pos:=Node.IndexRef[Idx].StrOfs;
      Len:=Node.IndexRef[Idx].StrLen;
    end else begin
      Pos:=Node.LeaveRef[Idx].StrOfs;
      Len:=Node.LeaveRef[Idx].StrLen;
    end;
    Pc:=@Node.StrBuf[Pos];

    if Index=NodexNdx then begin
      {trouble with short addresses}
      Ad:=Ap^; if len=6 then Ad.Point:=0;
      CompItem:=CompAddr(@Ad,Desired,8);
    end
    else CompItem:=CompName(Pc,Desired,Len);
  end;

begin
  Lvl:=0;
  Loc:=-1;
  Seek(F,0); BlockRead(F, Ctrl, SizeOf(Ctrl));
  if IOResult<>0 then goto Return;
  if Ctrl.CTLBlkSize = 0 then goto Return;

  Rec:=Ctrl.CtlRoot;
  Seek(F,Rec*Ctrl.CtlBlkSize);
  BlockRead(F,node,Sizeof(node));
  if IOResult<>0 then goto Return;

  {search in index levels}
  while (Node.IdxFirst <> -1) and (Loc<0) {and (Lvl<Level)} do begin
    Cmp:=-1; Idx:=0; Cnt:=Node.IdxCnt; if Cnt=0 then goto Return;
    while (Idx<Cnt) and (Cmp<0) do begin
      {found=0, >0 go down (to the leaves)}
      Cmp:=CompItem;
      if Cmp=0
      then begin {if lvl<level then inc(idx) else} loc:=Rec end
      else if Cmp<0
      then inc(Idx);
    end;
    if Loc<0 then begin
      {To the left Idx=0, or to the right Idx<>0}
      inc(lvl);
      if Idx = 0
      then Rec:=Node.IdxFirst
      else Rec:=Node.IndexRef[Idx-1].Child;
      Seek(F,Rec*Ctrl.CtlBlkSize);
      BlockRead(F,node,Sizeof(node));
      if IOResult<>0 then goto Return;
    end;
  end;

  {go one backwards (spread over two blocks)}
  if (Loc<0) and (Node.IdxPrev>0)
  then Rec:=Node.IdxPrev;

  {search in leaves}
  Cmp:=-1;
  while (Loc<0) and (Cmp<0) do begin
    Seek(F,Rec*Ctrl.CtlBlkSize);
    BlockRead(F,node,Sizeof(node));
    if IOResult<>0 then goto Return;

    Cmp:=-1; Idx:=0; Cnt:=Node.IdxCnt; if Cnt=0 then goto Return;
    while (Idx<Cnt) and (Loc<0) and (Cmp<0) do begin
      Cmp:=CompItem;
      if Cmp=0
      then Loc:=Rec
      else if Cmp<0
      then inc(Idx);
    end;
    if (Loc<0) and (Cmp<0) then begin
      if Node.IdxNext>0
      then Rec:=Node.IdxNext
      else Loc:=Rec;
    end;
  end;

  Return:
  if Idx<Cnt
  then CurIdx:=Idx
  else CurIdx:=Node.IdxCnt-1;
  if loc=-1
  then Btree:=Rec
  else Btree:=Loc;
end;

end.
