{$i-} unit V7_Brw;

{ General Version7 Browsing by Marius Ellen, 2:282/502.3 }
{ Permission allowed (even encouraged) to use this source}

interface

uses
 {Unitname   Description                                 Available }
  Use32,     {16/32 bit types (Virtual Pascal for OS/2)  N         }
  V7_Eng,    {Basic version7 functions                   Y         }
  BpMenu,    {Basic Dialog & Menu functions              N         }
  BpColor,   {Only color values                          N         }
  BpUtils,   {Basic tools                                N         }
  BpTools,   {Basic tools                                N         }
  BpWin,     {Additional screen handling                 N         }
  Strings,   {Basic library borland pascal               N(Library)}
  WinDos,    {Basic library borland pascal               N(Library)}
  Crt;       {Basic library borland pascal               N(Library)}



procedure ShowVersion7(V7Path,Typed:pchar);



implementation



procedure ShowVersion7(V7Path,Typed:pchar);
{All the data is allocated on the stack}

const
  ScreenTop = 1; {Display records from line 1}
  WholePage = 0;

type
  RecType = record
    Itm      : String[76];
    IndexDat : Longint; {filepos in Nodex.Dat}
    IndexBlk : Longint; {Current index block}
    IndexIdx : byte;    {Current record in index block}
    IndexPrv : Longint; {Prev index block}
    IndexNxt : Longint; {Next index block}
  end;

  SetupBrowserFlags = record
    modemtype : array[1..08] of string[47];
    nodeflags : array[1..16] of string[47];
  end;


var
  Ctrl      : V7Idx;       {Header (root) block index file}
  Node      : V7Idx;       {Block from index file (=CurBlk)}
  CurBlk    : longint;     {current block from indexfile}
  CurIdx    : integer;     {current sub index in block}

  pData     : V7Dat;       {Data from nodex.dat (compressed)}
  uData     : V7rec;       {Data from nodex.dat (decompressed)}

  MaxPage   : integer;     {maximum records on display}
  MaxItem   : integer;     {maximum records on display}
  CurPos    : integer;     {current highlighted record}
  Records   : array[0..50] of RecType; {Collected recs}

  V7Index   : V7Indexes;   {Current index (Nodex.Ndx or Sysop.Ndx)}
  MainIndex : ^File;       {Ptr to the opened index file}

  V7Flags   : SetupBrowserFlags;{from nodex.dat}
  V7Files   : Set of V7Indexes; {Available v7-files}
  fSysopNdx : File;        {obvious}
  fNodexNdx : File;        {obvious}
  fNodexDat : File;        {obvious}



  procedure ReadIndexHeader;
  var Cnt:Word;
  begin
    Seek(MainIndex^,0);
    BlockRead(MainIndex^,Ctrl,Sizeof(Ctrl),Cnt);
    {check the header of the index}
    if Ctrl.CtlParity<>GetV7Parity(Ctrl)
    then Messagebox('The current index file:;;'+
                    Strpas(tfilerec(MainIndex^).Name)+
                    ';;Is corrupted','Warning');
  end;


  procedure ReadIndex(Blk:longint);
  {Read blocknr x from the index file}
  var Cnt:Word;
  begin
    Seek(MainIndex^,Blk*Ctrl.CtlBlkSize);
    BlockRead(MainIndex^,Node,Sizeof(Node),Cnt);
  end;


  procedure ReadFlags;
  {FastV7 stores it flags in the nodex.dat file}
  {The first 7 characters should be "FastV7"}
  var Copyright:TPthStr;
  begin
    Seek(fNodexDat,0);
    Blockread(fNodexDat,CopyRight,Sizeof(CopyRight));
    CopyRight[6]:=#0; {Dont care what version it is}
    if StriComp(CopyRight,'FastV7')=0
    then Blockread(fNodexDat,V7Flags,Sizeof(V7Flags));
  end;


  function ShowInfo(Typed:pchar):SmallWord;
  const bx=7; by=06; pr=10;
  var i,w,RoutNet,RoutNod:SmallWord;
    x1,y1,x2,y2:byte;
    Baud,mFlags,nFlags,ViaAd,addrs,Sname,
    Bname,Cname,Phone,Passw,CallCost,MsgFee:string[50];
    P:pchar;
    Saved:TWindow;
    Addr:Taddress;
    Key:Word;
  begin
    ShowInfo:=0;
    X1:=bx; X2:=bx+69;
    Y1:=by; Y2:=by+10;
    if WinOpen(Saved,X1,Y1,X2,Y2,frDouble+frShadow,'','System info','') then begin

      GetV7Data(fNodexDat,Records[CurPos].IndexDat,pData,uData);
      MakeProp(uData.Sname);
      MakeProp(uData.Bname);
      MakeProp(uData.Cname);

      {Correct Dutch names and BBS names}
      if (uData.Cname[0]='I') and (uData.Cname[1]='j')
      then uData.Cname[1]:='J';
      P:=StrPos(uData.Bname,'Bbs');
      if P<>nil then begin P[1]:='B'; P[2]:='S'; end;

      ViaAd:='';

      if uData.NodeFlags and nfPoint=0
      then uData.Address.Point:=0;
      Addrs:=AddressStr0(uData.Address);
      SName:=left(strpas(uData.Sname),30);
      BName:=left(strpas(uData.Bname),30);
      CName:=left(strpas(uData.Cname),30);
      PassW:=left(strpas(uData.Passw),30);

      w:=1;
      nFlags:='';
      for i:=1 to 16 do begin
        if uData.NodeFlags and w>0 then begin
          if Length(nFlags)>0
          then nFlags:=nFlags+', ';
          nFlags:=nFlags+V7Flags.Nodeflags[i]
        end;
        inc(w,w);
      end;

      w:=1;
      mFlags:='';
      for i:=1 to 8 do begin
        if uData.ModemType and w>0 then begin
          if Length(mFlags)>1
          then mFlags:=mFlags+', ';
          mFlags:=mFlags+V7Flags.Modemtype[i]
        end;
        inc(w,w);
      end;

      if uData.Phone[0]=#0
      then Phone:='-Unpublished-'
      else Phone:=left(strpas(uData.Phone),30);

      if uData.CallCost>0
      then CallCost:=i2Str(uData.CallCost)
      else CallCost:='';

      if uData.MsgFee>0
      then MsgFee:=i2Str(uData.MsgFee)
      else MsgFee:='';
      Baud:=i2Str(uData.Baud);

      fastwrite(ViaAd,01,(X2-X1)-Length(ViaAd)-2,Clr.Prompt);
      fastwrite(padr('Address',     pr)+Addrs   , 01,2,Clr.Prompt);
      fastwrite(padr('Sysop',       pr)+Sname   , 02,2,Clr.Prompt);
      fastwrite(padr('Board',       pr)+Bname   , 03,2,Clr.Prompt);
      fastwrite(padr('City',        pr)+Cname   , 04,2,Clr.Prompt);
      fastwrite(padr('Phone',       pr)+Phone   , 05,2,Clr.Prompt);
      fastwrite(padr('Flags',       pr)+nFlags  , 06,2,Clr.Prompt);
      fastwrite(padr('Modem',       pr)+mFlags  , 07,2,Clr.Prompt);
      fastwrite(padr('Baudrate',    pr)+Baud    , 08,2,Clr.Prompt);
      fastwrite(padr('Cost',        pr)+CallCost, 09,2,Clr.Prompt);
      fastwrite(padr('Msgfee',      pr)+MsgFee  , 10,2,Clr.Prompt);
      fastwrite(padr('Password',    pr)+Passw   , 11,2,Clr.Prompt);

      Key:=readAkey;
      WinClose(Saved);
    end;
  end;

{**********************************************************************}
  procedure DisplayItem(Itm:Integer;Selectable:boolean);
  var Attr:byte;
  begin
    if Selectable and (CurPos=Itm)
    then Attr:=SwapNibble(Clr.Prompt)
    else Attr:=Clr.Prompt;
    FastWrite(padr(Records[itm].Itm,80),1+ScreenTop+Itm,1,Attr);
  end;

  procedure DisplayPage(Action:Integer);
  var Idx:SmallWord;
    Blk:longint;

    procedure FillItem(Nr:SmallWord);
    var tm:string[80];
      ad,nm,ph,st:string[80];
      name:TPthStr;
      Loc:longint;
      Len,Pos:SmallWord;
    begin
      if Node.idxfirst=-1 then begin
        Pos:=Node.LeaveRef[Idx].StrOfs;
        Len:=Node.LeaveRef[Idx].StrLen;
        Loc:=Node.LeaveRef[Idx].DatPtr;
      end else begin
        Pos:=Node.IndexRef[Idx].StrOfs;
        Len:=Node.IndexRef[Idx].StrLen;
        Loc:=Node.IndexRef[Idx].DatPtr;
      end;
      GetV7Data(fNodexDat,Loc,pData,uData);

           if uData.NodeFlags and nfPoint>0  then St:='Point'
      else if uData.NodeFlags and nfHost>0   then St:='Host'
      else if uData.NodeFlags and nfHub>0    then St:='Hub'
      else if uData.NodeFlags and nfZone>0   then St:='Zone'
      else if uData.NodeFlags and nfRegion>0 then St:='Region'
      else st:='';

      if uData.NodeFlags and (1 shl 15)>0
      then st:=st+'!';

      MakeProp(uData.Sname);
      nm:=padr(Strpas(uData.Sname),23);

      if uData.NodeFlags and nfPoint=0
      then uData.Address.Point:=0;
      ad:=Padr(AddressStr0(uData.Address),20);

      if pData.PhoneLen=0
      then ph:='-Unpublished-'
      else ph:=Strpas(uData.Phone);
      ph:=padr(ph,23)+padl(st,7);
      tm:=nm+' '+ad+' '+ph;

      with Records[Nr] do begin
        IndexIdx := Idx;          {Current index in block}
        IndexBlk := Blk;          {Current blocknumber}
        IndexDat := Loc;          {Position in nodex.dat}
        IndexNxt := Node.IdxNext; {Next blocknumber}
        IndexPrv := Node.IdxPrev; {Prev blocknumber}
        Itm      := Padr(tm,75);  {String to display}
      end;
    end;

  begin
    if Action<>WholePage then begin
      if {only screen browse, cursor up/down, pageup/pagedown}
        (inrangei(CurPos+Action,0,MaxItem-1)=CurPos+Action) or
        {first record from file}
        ((Action<0) and (Records[0].IndexPrv=0) and (Records[0].IndexIdx=0)) or
        {last record from file}
        ((Action>0) and (MaxItem<MaxPage))
      then begin
        DisplayItem(CurPos,false);
        CurPos:=inrangei(CurPos+Action,0,MaxItem-1);
        DisplayItem(CurPos,true);
        Exit;
      end;

      {browse; goto requested record}
      ReadIndex(Curblk);
      if Action<>WholePage then begin

        {Simply skip records. Calculation is not possible as
        each index block contains a different amount of records.
        This code will only skip the requested -/+50 records}

        {upwards}
        While Action<0 do begin
          {loop in block}
          if CurIdx>0 then begin
            dec(CurIdx);
            inc(Action);
            Continue;
          end;
          {loop blocks}
          if (Action<0) and (Node.IdxPrev<>0) then begin
            CurBlk:=Node.IdxPrev;
            ReadIndex(CurBlk);
            CurIdx:=Node.IdxCnt;
            Continue;
          end;
          Break;
        end;

        {downwards}
        While Action>0 do begin
          {loop in block}
          if CurIdx<Node.IdxCnt then begin
            inc(CurIdx);
            dec(Action);
            Continue;
          end;
          {loop blocks}
          if (Action>0) and (Node.IdxNext<>0) then begin
            CurBlk:=Node.IdxNext;
            ReadIndex(CurBlk);
            CurIdx:=0;
            Continue;
          end;
          Break;
        end;

      end;
    end;


    {read all items}
    MaxItem:=0; Idx:=CurIdx; Blk:=CurBlk;
    fillchar(Records,sizeof(Records),#0);
    while MaxItem<MaxPage do begin
      ReadIndex(Blk);

      {records from current block}
      while (Idx<Node.IdxCnt) and (MaxItem<MaxPage) do begin
        FillItem(MaxItem);
        inc(MaxItem);
        inc(Idx);
      end;

      {continue on a next block}
      if (Node.IdxNext<>0) and (MaxItem<MaxPage) then begin
        Blk:=Node.IdxNext;
        Idx:=0;
        Continue;
      end;

      {no more records or done}
      break;
    end;
    {make sure higlighted pos is available}
    CurPos:=inrangei(CurPos,0,MaxItem-1);
    for Idx:=0 to MaxPage-1 do DisplayItem(Idx,Idx<MaxItem)
  end;


{local data for the mainprogram}
var Key,Ask:Word;
  Srch:TStr256;
  Addr:tAddress absolute Srch;
begin
  FileMode:= 0;         {Open all files in readOnly mode}
  V7Index := NodexNdx;  {Default index is address index}
  MaxPage := ScreenHeight-ScreenTop-1;  {Obvious}

  {Check files: the nodex.dat is needed }
  if IsFile(PthBld(Srch,V7Path,'Nodex.Dat'))
  then V7Files:=V7Files+[NodexDat]
  else begin
    Messagebox('FastV7 could not open:;;'+StrPas(Srch),'Error');
    exit;
  end;
  Assign(fNodexDat,Srch);


  {Check files: the nodex.ndx is needed }
  if IsFile(PthBld(Srch,V7Path,'Nodex.Ndx'))
  then V7Files:=V7Files+[NodexNdx]
  else begin
    Messagebox('FastV7 could not open:;;'+StrPas(Srch),'Error');
    exit;
  end;
  Assign(fNodexNdx,Srch);


  {Check files: the sysop.ndx is optional}
  if IsFile(PthBld(Srch,V7Path,'Sysop.Ndx'))
  then V7Files:=V7Files+[SysopNdx];
  Assign(fSysopNdx,Srch);


  {Open all available version7 files}
  if NodexDat in V7Files then Reset(fNodexDat,1);
  if NodexNdx in V7Files then Reset(fNodexNdx,1);
  if SysOpNdx in V7Files then Reset(fSysopNdx,1);

  ReadFlags;

  repeat {while not user abort}
    fillchar(Srch,Sizeof(Srch),0);

    if StrTrim(Typed)[0]>#0 then begin
      {valid nodeadres?}
      if ReadNodeAddress(Typed,0,Addr)=1
      then V7Index:=NodexNdx
      {else if names are available}
      else if SysopNdx in V7Files then begin
        V7Index:=SysopNdx;
        {Wrap the sysopname. (not with internet addressing)}
        if (StrScan(Typed,',')=nil) and (StrScan(Typed,'@')=nil)
        then StrCopy(Typed,WrapName(Srch,Typed))
        else StrCopy(Srch,Typed);
        MakeProp(Typed);
      end;
    end;

    if V7Index=NodexNdx
    then MainIndex:=@fNodexNdx
    else MainIndex:=@fSysopNdx;

    CurPos:=0;
    ReadIndexHeader;
    CurBlk:=Btree(MainIndex^,CurIdx,Srch,V7Index);
    DisplayPage(WholePage);

    repeat {while same index}
      Key:=ReadAkey;
      case Key of
        kbEsc:break;
        kbSpace,kbTab,kbCr:ShowInfo(Typed);
        kbUp   : DisplayPage(-1);
        kbDn   : DisplayPage(+1);
        kbPgUp : DisplayPage(-(MaxPage-1));
        kbPgDn : DisplayPage(+(MaxPage-1));
        kbHome:begin
          CurPos:=0;
          CurBlk:=Btree(MainIndex^,CurIdx,#$00#$00,V7Index);
          DisplayPage(WholePage);
        end;
        kbEnd:begin
          CurPos:=MaxPage;
          CurBlk:=Btree(MainIndex^,CurIdx,#$ff#$ff,v7Index);
          DisplayPage(WholePage);
        end;
        kbF5:begin {search}
          Ask:=AskUser('Srch via index on Address or Name',Typed);
          if (Ask<>kbEsc) and (Typed[0]>#0)
          then break;
        end;
        kbF10:begin {switch between indexes}
          case V7Index of
            SysopNdx: if NodexNdx in V7Files then begin
              StrPCopy(Typed,Copy(Records[CurPos].Itm,25,20));
              break;
            end;
            NodexNdx: if SysopNdx in V7Files then begin
              StrPCopy(Typed,Copy(Records[CurPos].Itm,1,23));
              break;
            end;
          end
        end;
      end;
    until Key=kbEsc;

  until Key=kbEsc;

  {Close all opened version7 files}
  if NodexDat in V7Files then Close(fNodexDat);
  if NodexNdx in V7Files then Close(fNodexNdx);
  if SysOpNdx in V7Files then Close(fSysopNdx);
end;



end.
