/* WHEN CONVERTING TO NEW FORMATS,
CHANGE typedefs to use same tags, and
change the naming here -
V2ECHO > ECHO -
ECHO > V1ECHO etc.
*/

#define FALSE 0
#define TRUE !FALSE

#include "dos.h"
#include "dir.h"
#include "ftsc.h"

/* defined in dos.h */
#ifndef __TURBOC__
struct date {
	int   da_year;
	char  da_day;
	char  da_mon;
};
#define MAXPATH   80
#define MAXDRIVE  3
#define MAXDIR    66
#define MAXFILE   9
#define MAXEXT    5
#endif

/* FamilyNet echolist structures */
typedef struct NetAddress {
	unsigned char domain[50];
	unsigned int zone;
	unsigned int net;
	unsigned int node;
	unsigned int point;
} ADDR;

/* NEW!! */
typedef struct Node {
	unsigned char name[36];
	unsigned char domain[24];
	unsigned int zone;
	unsigned int net;
	unsigned int node;
	unsigned int point;
} NODE;

/* NEW!! */
/* New Database records */
typedef struct v2echo {
	char version;
	char areatag[36];
	char ShortDesc[72];
	char Restr[72];
	NODE Msgr;
	NODE Mod[5];
	char RestFlag;    /* 0=none, 1=members only, 2=sysops only,
								4=moderator approval required, 8=Read-only,
								16=Real-names only */
	char ActiveStatus;    	/* 0 = active, 1 = unlisted, 2 = drop  */
									/* RESERVE  3 = unpublished,  4 = proposed */
	char OtherFlag;
	struct date creation;
	struct date update;
	long nodes;
	long traffic;
	char TrafficPeriod;   	/* RESERVED for monthly(0), weekly(1), daily(2) */
	char OrigNetw[36];
	char group[6];
	char distribution[72];
	char gates[72];
	char RuleFile[14];
	char key[9];				/*	UNUSED */
	char password[36];
	struct date deletion;
	char space[32];
	char LongDesc[1111];
} ECHO; /* v2echo */

typedef union colorpair {
	unsigned char fg;
	unsigned char bg;
	int attr;
} COLORPAIR;

typedef struct colorset {
	COLORPAIR text;
	COLORPAIR tag;
	COLORPAIR addr;
} COLORSET;

/* Configuration Structure */
typedef struct v2Config {
	unsigned char version;     /* it's good to know what version of cfg. */
	 /* char ListKeeper[35];       /* Name of person, responder to netmail */
	 /* ADDR KeeperAddr;        /* NetAddress of system (used by mail proc) */
	NODE ListKeeper;
	unsigned char defbit;      /* default behavior of echolist
	* 1  - add new echoes (otherwise inactive)
	* 2  - send reply message
	* 4  - announce new listing
	* 8  - announce update
	* 16 - announce deletion
	* 32 - keep netmail messages
	* 64 - submit to FidoNet/other echolist    */
	unsigned char optionbit;   /* allowable options to submitters
	 2  - allow REPL/NOREP reply
	 4  - allow ANN/NOANN announcements
	 8  - allow update announcements
	 16 - allow moderator delete
	 32 -
	 64 - allow SUB/NOSUB submission to FidoNet/other echolist    */
	unsigned char errorbit;    /* how to handle entries with errors
	 1  - accept new entries with errors
	 2  - accept updates with errors
	 4  - log error in echolist entry (console only)
	 8  - publish error
	 16 - reply to error
	 32 - log password error in echolist entry
	 64 - */
	char replybit;             /* Hold, Crash, Direct, etc.
	 1  - private message 0x0001
	 2  - crash mail 0x0002
	 4  - kill/sent 0x0080
	 8  - Hold 0x0200
	 64 - */

	char purgebit;             /*
	 1  - Net Moderator with notice,
	 2  - Publish but show Inactive in entry,
	 4  - Inactivate old entries; require update before listing,
	 8  - Delete from database */
	unsigned int WarnPeriod;
	unsigned int PurgePeriod;  /* in days, 0 = disable */
	unsigned int UpdatePeriod; /* ECHOMOD only */
	char ruletype;
			/* 1 = Attach,    2 = Include text 		*/
	char otherbit;					/*
	 1  - Touch rule files		*/
	char mailertype;
			/* 1 = FrontDoor, 2 = Binkleyterm, ... */
	char mailpath[MAXDIR];
	char rcvdpath[MAXDIR];
	char secure[MAXDIR];
	char database[MAXPATH];    /* default dir/file for database */
	char logfile[MAXPATH];
	char uplinkfile[MAXPATH];  /* default dir/file (FMLYNET.NA) if missing */
	char upl_hatchcmd[80];     /* command to hatch uplink list */
	char helpfile[MAXPATH];
	char editcmd[80];          /* RESERVED for external editor */
	char listfile[MAXPATH];    /* default dir/file if missing */
	char list_archivecmd[80];  /* command to archive list */
	char list_hatchcmd[80];    /* command to hatch list */
	unsigned char ann_areatag[36];  /* areatag for ann (using mailpath) */
	unsigned int ann_HMB;      /* HMB area # to announce areas */
		 /* bitfield options can be declared in some compilers, but since they
		 are non-standard and not portable ANSI C, I prefer to check bits
		 individually by ANDing with the value of the option. */
	char originline[65];
	char filespath[MAXDIR];
	char rulepath[MAXDIR];

	 /* char OtherListKeeper[35];  /* Name of person, responder to netmail */
	 /* ADDR OtherKeeperAddr;   /* NetAddress of system (used by mail proc) */
	NODE OtherListKeeper;
	/* 93 bytes */
	 /* char SubmitFrom[35];       /* Name of person, responder to netmail */
	 /* ADDR SubmitFromAddr;    /* NetAddress of system (used by mail proc) */
	NODE SubmitFrom;
	char AnnounceFrom[35];
	char process_name[35];		/* reserved for ECHOLIST alternate names */
	char modupd_str[35];       /* reserved for MOD UPD alternate subj */
	char query_str[35];        /* reserved for ECHO QUE alternate subj */
	char cook_str[35];         /* reserved for COOKBOOK alternate subj */
	char deletefile[MAXPATH];  /* default dir/file (FMLYNET.NO) if missing */
	char wings[3];					/* UNUSED */
	ECHO defaults;
	COLORPAIR coloring;
} CFG; /* v2cfg */

/* Group database records */
typedef struct group {
	char abbr[6];
	char ann_areatag[36];
	char listfile[MAXPATH];
	char uplinkfile[MAXPATH];
	char GroupListKeeper[35];
	ADDR GroupKeeperAddr;
	char Contact[36];
	ADDR ContactAddr;
	char network[21];
	int zone;
	char ShortDesc[73];
	char Infofile[13];
	char Adfile[13];
	char ActiveStatus;
} V1GROUP;

/* Group database records */
typedef struct newgroup {
	char version;
	char network[18];
	int zone;
	char ShortDesc[72];
	char LongDesc[1024];
	char Infofile[13];/* zip? */
	char Adfile[13];	/* text */
	NODE Contact[2];
	NODE ListKeeper;
	NODE Empty;
	char password[36];
	char ActiveStatus;

	struct date creation;
	struct date update;
	char OrigNetw[36];
	char abbr[6];
	char distribution[72];
	long nodes;
	char ann_areatag[36];
	char listfile[MAXPATH];
	char uplinkfile[MAXPATH];
	char wings[5];
} GROUP;

/* History log records */
typedef struct activity {
	struct date when;
	char areatag[36];
	char change[10];	/* 0 = added, 1 = updated, 2 = dropped, 3 = activated */
	char by[36];
} ACTION;

typedef struct publication {
	char reportname[80];
	char report[MAXPATH];
	char header[MAXPATH];
	char formatline[36][5];
	char hatchcommand[80];
	char wings[256];
} PUB;


/* THESE ARE THE VERSION 1 STRUCTURES */
/* Database records */
typedef struct echo {
	char areatag[36];
	char ShortDesc[56];
	char LongDesc[1024];
	char Restr[26];
	char Msgr[36];
	ADDR MsgrAddr;
	char Mod[36];
	ADDR ModAddr;
	char CoMod[36];
	ADDR CoModAddr;
	char Mod3[36];
	ADDR Mod3Addr;
	char password[36];
	char ActiveStatus;    	/* 0 = active, 1 = unlisted, 2 = drop  */
									/* RESERVE  3 = unpublished,  4 = proposed */
	struct date creation;
	struct date update;
	long traffic;
	char TrafficPeriod;   	/* RESERVED for monthly(0), weekly(1), daily(2) */
	char OrigNetw[36];
	char group[6];
	char distribution[56];
	char gates[36];
	long nodes;
	char RuleFile[14];
	char key[9];				/*	UNUSED */
	char pwhistory[3][20];	/* RESERVED */
	char hole[59];
	char ForwardListKeeper[35];  /* RESERVED for person to Forward update */
	ADDR ForwardAddr;    /* RESERVED for NetAddress of system to Fwd */
	char RestFlag;    /* 0=none, 1=members only, 2=sysops only,
								4=moderator approval required, 8=Read-only,
								16=Real-names only */
	char wings[58];         /* UNUSED */
} V1ECHO; /* echo */

/* THESE ARE THE VERSION 1 STRUCTURES */
/* Configuration Structure */
typedef struct Config {
	unsigned char version;     /* it's good to know what version of cfg. */
	char ListKeeper[35];       /* Name of person, responder to netmail */
	ADDR KeeperAddr;        /* NetAddress of system (used by mail proc) */
	unsigned char defbit;      /* default behavior of echolist
	* 1  - add new echoes (otherwise inactive)
	* 2  - send reply message
	* 4  - announce new listing
	* 8  - announce update
	* 16 - announce deletion
	* 32 - keep netmail messages
	* 64 - submit to FidoNet/other echolist    */
	unsigned char optionbit;   /* allowable options to submitters
	 2  - allow REPL/NOREP reply
	 4  - allow ANN/NOANN announcements
	 8  - allow update announcements
	 16 - allow moderator delete
	 32 -
	 64 - allow SUB/NOSUB submission to FidoNet/other echolist    */
	unsigned char errorbit;    /* how to handle entries with errors
	 1  - accept new entries with errors
	 2  - accept updates with errors
	 4  - log error in echolist entry (console only)
	 8  - publish error
	 16 - reply to error
	 32 - log password error in echolist entry
	 64 - */
	char replybit;             /* Hold, Crash, Direct, etc.
	 1  - private message 0x0001
	 2  - crash mail 0x0002
	 4  - kill/sent 0x0080
	 8  - Hold 0x0200
	 64 - */

	char purgebit;             /*
	 1  - Net Moderator with notice,
	 2  - Publish but show Inactive in entry,
	 4  - Inactivate old entries; require update before listing,
	 8  - Delete from database */
	unsigned int WarnPeriod;
	unsigned int PurgePeriod;  /* in days, 0 = disable */
	unsigned int UpdatePeriod; /* ECHOMOD only */
	char bools[2];
	char mailertype;
			/* 1 = FrontDoor, 2 = Binkleyterm, ... */
	char mailpath[MAXDIR];
	char rcvdpath[MAXDIR];
	char secure[MAXDIR];
	char database[MAXPATH];    /* default dir/file for database */
	char logfile[MAXPATH];
	char uplinkfile[MAXPATH];  /* default dir/file (FMLYNET.NA) if missing */
	char upl_hatchcmd[80];     /* command to hatch uplink list */
	char helpfile[MAXPATH];
	char editcmd[80];          /* RESERVED for external editor */
	char listfile[MAXPATH];    /* default dir/file if missing */
	char list_archivecmd[80];  /* command to archive list */
	char list_hatchcmd[80];    /* command to hatch list */
	unsigned char ann_areatag[36];  /* areatag for ann (using mailpath) */
	unsigned int ann_HMB;      /* HMB area # to announce areas */
		 /* bitfield options can be declared in some compilers, but since they
		 are non-standard and not portable ANSI C, I prefer to check bits
		 individually by ANDing with the value of the option. */
	char originline[65];
	char filespath[MAXDIR];
	char rulepath[MAXDIR];

	char OtherListKeeper[35];  /* Name of person, responder to netmail */
	ADDR OtherKeeperAddr;   /* NetAddress of system (used by mail proc) */
	/* 93 bytes */
	char SubmitFrom[35];       /* Name of person, responder to netmail */
	ADDR SubmitFromAddr;    /* NetAddress of system (used by mail proc) */
	char process_name[35];		/* reserved for ECHOLIST alternate names */
	char modupd_str[35];       /* reserved for MOD UPD alternate subj */
	char query_str[35];        /* reserved for ECHO QUE alternate subj */
	char cook_str[35];         /* reserved for COOKBOOK alternate subj */
	char wings[13];				/* UNUSED */
	ECHO defaults;
	COLORPAIR coloring;
} V1CFG; /* cfg */

/* THESE ARE THE VERSION 1 STRUCTURES */
