/*--------------------------------------------------------------------------*/
/* CHGAREA.COM:                                                             */
/*                                                                          */
/* This is just a dumb little program to quickly move all the listings      */
/* for one area in FILESBBS.DAT to another area, that is, if you have       */
/* an existing file area 23, and decide you want to move that area to       */
/* area 30, you can just run:                                               */
/*                                                                          */
/*  chgarea 23 30                                                           */
/*                                                                          */
/* And everything that used to be associated with file area 23 in your      */
/* FILESBBS database will now know that its in file area 30. Then all       */
/* you have to do is edit your CTL file to create the new file area 30.     */
/*                                                                          */
/* CHGAREA.COM will only work when it's in the same directory as            */
/* FILESBBS.DAT and FILESBBS.ADX.                                           */
/*                                                                          */
/*                                        Doug Boone FidoNet 1:119/5        */
/*--------------------------------------------------------------------------*/
#include   <stdio.h>
#include   <io.h>
#include   <fcntl.h>
#include   <stdlib.h>
#include   "opus.h"
#include   "system.h"
#include   "nfile.h"

void usage(void);

void cdecl main(int argc,char *argv[])
{
   struct  _afile  afile;
   struct  _numb_idx   numbers;
   long    skip;
   int     fh;
   int     oldarea;
   int     newarea;

   if (argc<3) 
       usage();
   oldarea = atoi(argv[1]);
   newarea = atoi(argv[2]);

   if (oldarea == newarea)
       usage();

   if ((fh = open("FILESBBS.ADX",O_BINARY|O_RDWR)) < 0)
       usage();
   while (read(fh,(char *)&numbers,sizeof(struct _numb_idx)) == sizeof(struct _numb_idx)) {
       if (newarea == numbers.area_number) {		/* Make sure new area doesn't already exist! */
           close(fh);
           usage();
           }
       }
   lseek(fh,0L,SEEK_SET);
   while (read(fh,(char *)&numbers,sizeof(struct _numb_idx)) == sizeof(struct _numb_idx)) {
       if (oldarea == numbers.area_number) {
           numbers.area_number = newarea;		/* Update FILESBBS.ADX */
           lseek(fh,-((long)(sizeof(struct _numb_idx))),SEEK_CUR);
           write(fh,(char *)&numbers,sizeof(struct _numb_idx));
           close(fh);
           fh = open("FILESBBS.DAT",O_BINARY|O_RDWR);
           lseek(fh,numbers.pos,SEEK_SET);
           while (read(fh,(char*)&afile,sizeof(struct _afile)) == sizeof(struct _afile)) {
               if (afile.area_number == oldarea) {
                   afile.area_number = newarea;
                   if (afile.name[0] > ' ')
                       printf("\nMoving %14s from area %d to area %d",afile.name,oldarea,newarea);
                   lseek(fh,-((long)(sizeof(struct _afile))),SEEK_CUR);
                   write(fh,(char*)&afile,sizeof(struct _afile));
                   skip = (long) afile.descr_len;
                   skip += (long) afile.altpath_len;
                   skip += (long) afile.upld_by_len;
                   lseek(fh,skip,SEEK_CUR);
                   }
               }		/* End of FILESBBS.DAT */
           close(fh);
           exit(0);
           }
       }
   printf("\nDidn't find area %d in FILESBBS.ADX!\n",oldarea);
   usage();
}



void usage(void)
{
   printf("\n\nCHGAREA.EXE\n\n\tChanges the area number for all the files in one area of\n");
   printf("\t FILESBBS.DAT to another area. Run as:\n\t\tCHGAREA 30 31\n\tMoves all files from area 30 to area 31.\n\n");
   exit(1);
}

