/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef RESOURCE_H
#define RESOURCE_H

#include <stdio.h>

#include "mmail.h"

#define PM_QWK    0
#define PM_BW     1
#define PM_UNDEF 99

class mmail;

const int	homeDir = 1,
		mmHomeDir = 2,
		bwPacketDir = 3,
		bwWorkDir = 4,
		bwUncompressCommand = 5,
		bwPacketName = 6,
		bwUserName = 7,
		bwBBSName = 8,
		bwSysOpName = 9,
		bwEchoTag=10,
		bwReplyDir = 11,
		bwLoginName = 12,
		bwAliasName = 13,	
		bwCompressCommand = 14,	
		bwUpWorkDir = 15,
		taglineChooseType = 16,
		sendConfirm = 17,
		editor = 18,
		mono = 19,
		bwSaveDir = 20,
		bwReadDir = 21,
		bwAddressBook = 22,			
		bwTaglineFile = 23,
		arjUncompressCommand = 24,
		zipUncompressCommand = 25,
		lhaUncompressCommand = 26,
		unknownUncompressCommand = 27,
		arjCompressCommand = 28,
		zipCompressCommand = 29,
		lhaCompressCommand = 30,
		unknownCompressCommand = 31,
		qwkBBSID = 32,
		packMode = 33,
		sigFile = 34,
		noOfResources = 34;

class resource
{
	mmail *mm;

	FILE *configFile;

	char basedir[80];

	struct resource_struct {
		char *name;	
		int  fromRc; // 0 if cannot be set
		char *value;
		int  val; // value, where appl.
		void  (resource::*init)();
	} resourceData[noOfResources+1];

	void initNull();
	void initHomeDir(); 
	void initBwWorkDir(); 
	void initBwPacketDir(); 
	void initBwUncompressCommand(); 
	void initBwReplyDir(); 
	void initBwSaveDir(); 
	void initBwReadDir(); 
	void initBwCompressCommand(); 
	void initBwUpWorkDir(); 
	void initEditor(); 
	void initMmHomeDir();
	void initBwAddressBook();
	void initBwTaglineFile();
	void initsigFile();

	void initinit();
	void parseConfig(FILE *);
	int checkPath(const char *onepath, const int show);
	int verifyPaths(void);
	int createNewConfig(const char *configname);
			
public:
	resource(mmail *mmA);
	~resource();
	const char *const get(const int ID);
	const char *set(const int ID, const char *newValue);

	int getValue(const int ID);
	void setValue(const int ID, int newValue);
};	
	  
#endif
