/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <string.h>

#include "compress.h"
#include "misc.h"
#include "mmail.h"

bw_read_class::bw_read_class(mmail *mmA, specific_driver *driverA)
{
	mm = mmA;
	driver = driverA;
	init();
};

bw_read_class::~bw_read_class()
{
	cleanUp();
};

void bw_read_class::init()
{
	FILE *readFile;
	char *readFileN;

	readStore = new int *[driver->getNoOfAreas() + 1];
	noOfLetters = new int[driver->getNoOfAreas() + 1];
	readFileN = readFilePath(mm->resourceObject->get(bwPacketName));
	readFile = fopen(readFileN, "r");

	for (int c = 1; c <= driver->getNoOfAreas(); c++) {
		driver->selectArea(c);
		readStore[c] = new int[driver->getNoOfLetters() + 1];
		noOfLetters[c] = driver->getNoOfLetters();
		for (int d = 1; d <= noOfLetters[c]; d++)
			(readStore[c])[d] = readFile ? getc(readFile) : 0;
	};
};

void bw_read_class::cleanUp()
{
	for (int c = 1; c <= driver->getNoOfAreas(); c++)
		delete readStore[c];
	delete readStore;
};

void bw_read_class::setRead(int area, int letter, int value)
{
	(readStore[area])[letter] &= (255 - MS_READ);  // take out the read bit
	if (value)
		(readStore[area])[letter] |= MS_READ;
};

int bw_read_class::getRead(int area, int letter)
{
	return ((readStore[area])[letter]) & MS_READ;
};

void bw_read_class::setStatus(int area, int letter, int value)
{
	(readStore[area])[letter] = value;
};

int bw_read_class::getStatus(int area, int letter)
{
	return (readStore[area])[letter];
};

int bw_read_class::getNoOfUnread(int area)
{
	int tmp = 0;
	for (int c = 1; c <= noOfLetters[area]; c++)
		if (!((readStore[area])[c] & MS_READ))
			tmp++;
	return tmp;
}

void bw_read_class::saveAll()
{
	FILE *readFile;
	char *readFileN;

	readFileN = readFilePath(mm->resourceObject->get(bwPacketName));
	readFile = fopen(readFileN, "w");

	for (int c = 1; c <= driver->getNoOfAreas(); c++) {
		for (int d = 1; d <= noOfLetters[c]; d++)
			putc((readStore[c])[d], readFile);
	};
	fclose(readFile);

	// add the .rep file to the packet
	compressAddFile(mm, (char *) mm->resourceObject->get(bwPacketDir),
			(char *) mm->resourceObject->get(bwPacketName),
			readFilePath(findBaseName(mm->resourceObject->
			get(bwPacketName))));
};

char *bw_read_class::readFilePath(const char *bwFile)
{
	char tmp[255];
	char suffix[] = ".red";

	strcpy(tmp, mm->resourceObject->get(bwWorkDir));
	strcat(tmp, "/");
	strcat(tmp, findBaseName(bwFile));
	strcat(tmp, suffix);

	return strdupplus(tmp);
};
