/*
 * MultiMail offline mail reader
 * 

 Written by John Zero <john@graphisoft.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef QWKREPLY_H
#define QWKREPLY_H

#include "internal.h"
#include "mmail.h"
#include "qwkstruct.h"

class qwkreply : virtual public reply_driver
{
private:

	struct upl_list {
	 char from[26], to[26], subj[26];
	 int areaNo;
	 int msglen;
	 char fname[50]; // reply.001 type fname
//	 netaddress na; // not yet used, but could be!
	 char dtime[8+1+5+1]; // QWK date & time
	 int privat;
	 int replyto;

	 upl_list *nextRecord;
	};
	
	mmail		*mm;
	area_header 	*replyAreaHeader;
	int 		currentLetter;
	int 		noOfLetters;
	char 		*replyPacketName;
	int 		replyExists;
	char 		*replyText;
	net_address 	netAddr;
	
	struct upl_list *uplListHead;
	struct upl_list *uplListCurrent;
	
	void init();
	void cleanup();
	int uncompress();
	void readRep();
	char *repFileName(const char *bwFileName);
	//char *freeFileName();
	int getRep1(FILE *rep, upl_list *l);
	void addRep1(FILE *rep, upl_list *l);

public:
	qwkreply(mmail *mmA);
	~qwkreply();
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int ID);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char *getBody(int ID);
	void enterLetter(letter_header *newLetter, char *newLetterFileName);
	void enterNetDest(net_address netAddress);
	void killLetter(int letterNo);
	area_header *refreshArea();
	void makeReply();
	void setBody(int ID, char *btext);
};

#endif
