/*
 * MultiMail offline mail reader
 * 

 Written by John Zero <john@graphisoft.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "compress.h"
#include "misc.h"
#include "qwk.h"
#include "qwkreply.h"
#include "resource.h"
#include "../interface/mysystem.h"

// current
qwkreply::qwkreply(mmail *mmA)
{
	mm = mmA;
	init();
};

qwkreply::~qwkreply()
{
	if (replyExists)
		cleanup();
};

void qwkreply::init()
{
	replyText = new char[1];
	replyPacketName = repFileName(mm->resourceObject->get(qwkBBSID));
	chdir(mm->resourceObject->get(bwReplyDir));
	if (access(replyPacketName, W_OK) == 0)
		replyExists = 1;
	else
		replyExists = 0;

	//if exists, read the letters

	if (replyExists) {
		uncompress();
		readRep();
		currentLetter = 1;
	} else {
		uplListHead = NULL;
		noOfLetters = 0;
		currentLetter = 0;
	};
};

void qwkreply::cleanup()
{
	upl_list *curr;
	upl_list *next;

	delete replyText;
	delete replyPacketName;

	curr = uplListHead;

	for (int c = 1; c <= noOfLetters; c++) {
		remove(curr->fname);
		next = curr->nextRecord;
		delete curr;
		curr = next;
	};
};

char *qwkreply::repFileName(const char *bwFile)
{
	int c;
	char *tmp;
	char suffix[5];

	if (tolower(bwFile[0]) == bwFile[0])	// lower-case
		strcpy(suffix, ".rep");
	else
		strcpy(suffix, ".REP");

	for (c = 0; (bwFile[c] != '.') && (bwFile[c]); c++);
	tmp = new char[c + 1 + 5];
	for (int d = 0; d < c; tmp[d] = bwFile[d++]);
	strcpy(tmp + c, suffix);

	return tmp;
};

int qwkreply::uncompress()
{
	char fname[255];

	strcpy(fname, mm->resourceObject->get(bwReplyDir));
	strcat(fname, "/");
	strcat(fname, replyPacketName);
	return uncompressFile(mm, fname,
			(char *) mm->resourceObject->get(bwUpWorkDir),
			      "*" /* this is dangerous!!! (rm -f *) */ );
};

#define CUTS(st,num) { strncpy(tmp,st,num); tmp[num]=0; }

int qwkreply::getRep1(FILE *rep, upl_list *l)
{
	qwkmsg_header qh;
	char tmp[255];
	int chunks;
	char *p;
	FILE *replyFile;

	if (fread(&qh, sizeof(qh), 1, rep) <= 0)
		return -1;

	CUTS(qh.msgnum, 7);
	l->areaNo = atoi(tmp);
	CUTS(qh.to, 25);
	strcpy(l->to, tmp);
	CUTS(qh.from, 25);
	strcpy(l->from, tmp);
	CUTS(qh.subject, 25);
	strcpy(l->subj, tmp);
	CUTS(qh.date, 8 + 5);
	strcpy(l->dtime, tmp);
	l->dtime[8] = 0;
	strcat(l->dtime, " ");
	strcat(l->dtime, &tmp[8]);
	CUTS(qh.chunks, 6);
	chunks = atoi(tmp) - 1;
	cropesp(l->from);
	cropesp(l->to);
	cropesp(l->subj);
	l->privat = (qh.status == '*');

	tmpnam(l->fname);

	delete replyText;
	replyFile = fopen(l->fname, "w");	// !! check

	replyText = new char[chunks * 128 + 1];
	fread(replyText, chunks * 128, 1, rep);

	for (p = &replyText[chunks * 128 - 1]; (*p == ' ') &&
		(p > replyText); p--);
	*++p = '\0';

	for (p = replyText; *p; p++)
		if (*p == (char) 227)
			*p = '\n';	// PI-softcr

	l->msglen = p - replyText;	//strlen(replyText);

	fwrite(replyText, 1, l->msglen, replyFile);
	fclose(replyFile);
	delete replyText;
	replyText = new char[1];

	return 0;
}

void qwkreply::readRep()
{
	char repName[14];
	char *tmp;
	int repLength;
	FILE *repFile;

	upl_list *prevUplList;
	upl_list *currUplList;

	chdir(mm->resourceObject->get(bwUpWorkDir));
	tmp = findBaseName(replyPacketName);
	strcpy(repName, tmp);
	strcat(repName, (tmp[strlen(tmp) - 1] == tolower(tmp[strlen(tmp) - 1]))
		? ".msg" : ".MSG");

	delete tmp;

	if (!(repFile = fopen(repName, "rw")))
		fatalError("error opening REP");

	fseek(repFile, 0, SEEK_END);
	repLength = ftell(repFile);
	fseek(repFile, 128, SEEK_SET);

	uplListHead = new upl_list;
	getRep1(repFile, uplListHead);
	noOfLetters = 1;
	uplListHead->nextRecord = NULL;
	prevUplList = uplListHead;

	for (int c = 1; !feof(repFile); c++) {
		currUplList = new upl_list;
		if (getRep1(repFile, currUplList)) {	// ha eof/error
			delete currUplList;
			break;
		}
		noOfLetters++;
		prevUplList->nextRecord = currUplList;
		prevUplList = currUplList;
		currUplList->nextRecord = NULL;
	};
	fclose(repFile);
	remove(repName);
};

int qwkreply::getNoOfAreas()
{
	return 1;
};

void qwkreply::resetAll()
{
	cleanup();
	init();
};

area_header *qwkreply::getNextArea()
{
	resetLetters();
	replyAreaHeader = new area_header(mm, 1, "REPLY", "REPLIES",
		     "Letters written by You", bwrep, noOfLetters, 0, 0, 0);
	return replyAreaHeader;
};

void qwkreply::selectArea(int ID)
{
	if (ID == 1)
		resetLetters();
};

void qwkreply::resetLetters()
{
	currentLetter = 1;
	uplListCurrent = uplListHead;
};

int qwkreply::getNoOfLetters()
{
	return noOfLetters;
};

letter_header *qwkreply::getNextLetter()
{
	letter_header *newLetter;

	newLetter = new letter_header(mm, (char *) uplListCurrent->subj,
	      (char *) uplListCurrent->to, (char *) uplListCurrent->from,
		     (char *) uplListCurrent->dtime, 0, 0, currentLetter,
		    uplListCurrent->areaNo, 0, 0, uplListCurrent->privat,
	     0, 0, uplListCurrent->areaNo, uplListCurrent->msglen, this);

	uplListCurrent = uplListCurrent->nextRecord;

	currentLetter++;
	return newLetter;
};

char *qwkreply::getBody(int ID)
{
	FILE *replyFile;
	upl_list *actUplList;

	delete replyText;

	actUplList = uplListHead;
	for (int c = 1; c <= ID - 1; c++)
		actUplList = actUplList->nextRecord;

	replyFile = fopen(actUplList->fname, "r");  // !! check it !

	// this is to get around a weird bug
	// that appeared under SunOS:
	int msglen = actUplList->msglen;

	replyText = new char[msglen + 1];
	fread(replyText, msglen, 1, replyFile);
	replyText[msglen] = '\0';
	fclose(replyFile);
	return replyText;
};

void qwkreply::setBody(int ID, char *btext)
{
	FILE *replyFile;
	upl_list *actUplList;

	// kene date update is!!

	actUplList = uplListHead;
	for (int c = 1; c <= ID - 1; c++)
		actUplList = actUplList->nextRecord;

	replyFile = fopen(actUplList->fname, "w");  // !! check it !
	actUplList->msglen = strlen(btext);
	fwrite(btext, actUplList->msglen, 1, replyFile);
	fclose(replyFile);
};

void qwkreply::enterLetter(letter_header *newLetter, char *newLetterFileName)
{
	char *dt;
	upl_list *workList;
	upl_list *newList;

	workList = uplListHead;

	for (int c = 1; c < noOfLetters; c++)	//go to last elem
		workList = workList->nextRecord;

	newList = new upl_list;

	memset((void *) newList, 0, sizeof(upl_list));

	strncpy(newList->from, newLetter->getFrom(), 25);
	strncpy(newList->to, newLetter->getTo(), 25);
	newList->areaNo = newLetter->getOriginalID();
	strcpy(newList->fname, newLetterFileName);
	newList->privat = newLetter->getPrivate();
	newList->replyto = newLetter->getReplyTo();

	if (newList->replyto && (strlen(newLetter->getSubject()) < 22)) {
		strcpy(newList->subj, "Re: ");
		strncat(newList->subj, newLetter->getSubject(), 21);
	}
	else
		strncpy(newList->subj, newLetter->getSubject(), 25);

	time_t tt;
	tt = time(NULL);
	dt = ctime(&tt);
	dt[10] = 0;
	dt[16] = 0;
	dt[7] = 0;
	dt[24] = 0;
	sprintf(newList->dtime, "%02d-%02d-%s %s", monthval(&dt[4]),
		atoi(&dt[8]), &dt[22], &dt[11]);
	// 'MM-DD-YY hh:mm'

	newList->msglen = getFileLen(newList->fname);

	if (!workList)
		uplListHead = newList;
	else
		workList->nextRecord = newList;

	newList->nextRecord = NULL;
	noOfLetters++;
	replyExists = 1;
};

void qwkreply::enterNetDest(net_address netAddress)
{
	netAddr = netAddress;
};

void qwkreply::killLetter(int letterNo)
{
	upl_list *actUplList;
	upl_list *tmpUplList;

	if (!noOfLetters || (letterNo < 1) || (letterNo > noOfLetters))
		fatalError(
		" qwkreply::killLetter ::fukka ! roszzat akarsz torolni!: ");

	// deleteing the 1st letter
	if (letterNo == 1) {
		tmpUplList = uplListHead;
		uplListHead = uplListHead->nextRecord;
	} else {
		actUplList = uplListHead;
		for (int c = 1; c <= letterNo - 2; c++)
			actUplList = actUplList->nextRecord;

		//deleting the last letter
		if (letterNo == noOfLetters) {
			tmpUplList = actUplList->nextRecord;
			actUplList->nextRecord = NULL;
		} else {
			// deleting from the middle
			tmpUplList = actUplList->nextRecord;
			actUplList->nextRecord =
			    actUplList->nextRecord->nextRecord;
		};
	}
	noOfLetters--;
	remove(tmpUplList->fname);
	delete tmpUplList;
	resetLetters();
};

area_header *qwkreply::refreshArea()
{
	replyAreaHeader = new area_header(mm, 1, "REPLY", "REPLIES",
		     "Letters written by you", bwrep, noOfLetters, 0, 0, 0);
	resetLetters();
	return replyAreaHeader;
};

#define MX(cur,pref) ((cur>pref)?pref:cur)

void qwkreply::addRep1(FILE *rep, upl_list *l)
{
	char buf[100];
	qwkmsg_header qh;
	int chunks;
	FILE *replyFile;
	char *p;

	memset(&qh, ' ', sizeof(qh));
	chunks = (l->msglen + 127) / 128;

	sprintf(buf, " %-6d", l->areaNo);
	strncpy(qh.msgnum, buf, 7);
	if (l->replyto) {
		sprintf(buf, " %-7d", l->replyto);
		strncpy(qh.refernum, buf, 8);
	}
	strncpy(qh.to, l->to, MX(strlen(l->to), 25));
	strncpy(qh.from, l->from, MX(strlen(l->from), 25));
	strncpy(qh.subject, l->subj, MX(strlen(l->subj), 25));
	qh.alive = (char) 0xE1;
	strncpy(qh.date, l->dtime, 8);
	strncpy(qh.time, &l->dtime[9], 5);
	sprintf(buf, "%-6d", chunks + 1);
	strncpy(qh.chunks, buf, 6);
	if (l->privat)
		qh.status = '*';
	fwrite(&qh, 1, sizeof(qh), rep);

	replyFile = fopen(l->fname, "r");	// !! check it !

	delete replyText;
	replyText = new char[chunks * 128 + 1];

	memset(&replyText[(chunks - 1) * 128], ' ', 128);
	fread(replyText, l->msglen, 1, replyFile);
	// replyText[l->msglen+1]='\0';
	fclose(replyFile);
	replyText[chunks * 128] = 0;
	for (p = replyText; *p; p++)
		if (*p == '\n')
			*p = (char) 227;	// PI-softcr

	fwrite(replyText, 1, chunks * 128, rep);
	delete replyText;
	replyText = new char[1];
}

void qwkreply::makeReply()
{
	upl_list *actUplList;
	FILE *repFile;
	char repFileName[13];
	char *tmp;
	char tmp1[255];

	// cd to upload dir
	if (chdir(mm->resourceObject->get(bwUpWorkDir)))
		fatalError(
		"\n Could not cd to bwupworkdir in qwkreply::makeReply\n\n");

	// Delete old packet
	strcpy(tmp1, mm->resourceObject->get(bwReplyDir));
	strcat(tmp1, "/");
	strcat(tmp1, replyPacketName);
	remove(tmp1);

	if (!noOfLetters)
		return;

	// find out the name of the upl file
	tmp = findBaseName(replyPacketName);
	strcpy(repFileName, tmp);
	strcat(repFileName, (tmp[strlen(tmp) - 1] ==
		tolower(tmp[strlen(tmp) - 1])) ? ".msg" : ".MSG");

	delete tmp;

	// create the new REP file
	repFile = fopen(repFileName, "w");
	//!! no check yet
	char head[128], *p;

	p = (char *) mm->resourceObject->get(qwkBBSID);
	memset(head, ' ', 128);
	strncpy(head, p, strlen(p));	// pont igy jo

	fwrite(head, 128, 1, repFile);

	actUplList = uplListHead;

	for (int c = 0; c < noOfLetters; c++) {
		addRep1(repFile, actUplList);
		actUplList = actUplList->nextRecord;
	};

	fclose(repFile);

	//pack the files

	compressAddFile(mm, (char *) mm->resourceObject->get(bwReplyDir),
			replyPacketName, repFileName);

	// clean up the work area
	//!! danger !!
	mysystem("rm *");
};
