/*
 * MultiMail offline mail reader
 * 

 Written by John Zero <john@graphisoft.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef QWK_H
#define QWK_H

#include <stdio.h>

#include "bw.h"
#include "internal.h"
#include "qwkstruct.h"

struct QWK_INFOs
 {
  char *bbsname,
      *username,
         *sysop,
         *bbsid;
 };

struct AREAs
 {
  int	num;
  char	*name;
  int   nummsgs;
 };

class qwkpack : public specific_driver
{
private:
	mmail		*mm;
	char		*packetBaseName;
	char		*bwDirName;
	char		*packetName;

	QWK_INFOs	*qwkinfo;
	int		maxConf;
	AREAs		*areas;
	int		cMsgNum;
	
	int		currentAreaID;
	int		currentLetter;
	
	FILE		*msgdatFile;
	FILE		*ctrdatFile;
	FILE		*idxFile;

	struct bodytype	**body;
	char		*bodyString;
	
	int		areaSerial;
	int		ID;

	int		openIndex(int num);
	int 		uncompressPacket(const char *packetName);
	void		readControlDat(void);
	void		initMessagesDat(void);

	unsigned long	MSBINtolong(unsigned const char *ms);
	void		init();
	void		cleanup();
	
public:
	qwkpack(mmail *mmA);
	~qwkpack();
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int ID);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char *getBody(int ID);
	void setBody(int ID, char *btext);
};

#endif  
