/*
 * MultiMail offline mail reader
 * 

 Written by John Zero <john@graphisoft.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>
#include <strings.h>
#include <unistd.h>

#include "compress.h"
#include "error.h"
#include "misc.h"
#include "qwk.h"
#include "resource.h"
#include "../interface/mysystem.h"

// ---------------------------------------------------------------------------
// The qwk methods
// ---------------------------------------------------------------------------

unsigned long qwkpack::MSBINtolong(unsigned const char *ms)
{
	return ((((unsigned long) ms[0] + ((unsigned long) ms[1] << 8) +
		  ((unsigned long) ms[2] << 16)) | 0x800000L) >>
			(24 + 0x80 - ms[3]));
}

// the constructor
qwkpack::qwkpack(mmail *mmA)
{
	mm = mmA;
	init();
};

void qwkpack::init()
{
	areaSerial = 0;
	ID = 0;

	// getBody handles this, but for the first time it needs sg to delete  
	bodyString = new char[1];

	qwkinfo = new QWK_INFOs;

	bwDirName = strdupplus(mm->resourceObject->get(bwPacketDir));
	packetName = strdupplus(mm->resourceObject->get(bwPacketName));

	//clean up
	if (chdir(mm->resourceObject->get(bwWorkDir)))
		fatalError("qwk::init: could not cd to tmp");
	mysystem("rm *");

	uncompressPacket(packetName);

	packetBaseName = findBaseName(packetName);

	idxFile = NULL;
	readControlDat();
	body = new struct bodytype *[maxConf + 1];

	initMessagesDat();

	currentAreaID = -1;
	currentLetter = 1;	// ?
};

// the desctructor
qwkpack::~qwkpack()
{
	cleanup();
};

void qwkpack::cleanup()
{
	delete bodyString;
	delete qwkinfo;
	delete areas;		// remelem ez ok lesz...  
	delete bwDirName;
	delete packetName;
	delete packetBaseName;

	if (idxFile)
		fclose(idxFile);
	fclose(msgdatFile);

	if (chdir(mm->resourceObject->get(bwWorkDir)))
		fatalError("qwkpack::cleanup: could not cd to tmp");
	mysystem("rm *");
};

// returns the no Of Active areas in the packet
int qwkpack::getNoOfAreas()
{
	return maxConf;
};

void qwkpack::resetAll()
{
	cleanup();
	init();
};

// returns the next area in an area_header object.
area_header *qwkpack::getNextArea()
{
	area_header *tmp;
	char num[9], name[22], description[129];

	areaSerial++;
	openIndex(areas[areaSerial].num);
	areas[areaSerial].nummsgs = cMsgNum;

	body[++ID] = new struct bodytype[cMsgNum + 1];

	if (areas[areaSerial].num == (-1)) {
		strcpy(num, "PERS");
		strcpy(description, "Letters addressed to You");
	} else {
		sprintf(num, "%d", areas[areaSerial].num);
		strncpy(description, areas[areaSerial].name, 127);
		description[128] = '\0';
	}
	strncpy(name, areas[areaSerial].name, 21);
	name[20] = '\0';

	tmp = new area_header(mm, ID + mm->driverList->getOffset(this),
			      num, name, description, qwk, cMsgNum,
			      0, 0, 0);
	return tmp;
};

// sets the current area
void qwkpack::selectArea(int ID)
{
	currentAreaID = ID;
	openIndex(areas[ID].num);
	areas[ID].nummsgs = cMsgNum;
	resetLetters();
};

// sets the current Letter to 1
void qwkpack::resetLetters()
{
	currentLetter = 1;	//-1;
};

int qwkpack::getNoOfLetters()
{
	return areas[currentAreaID].nummsgs;
};

int qwkpack::openIndex(int num)
{
	char fname[255];

	chdir(mm->resourceObject->get(bwWorkDir));
	if (idxFile)
		fclose(idxFile);

	cMsgNum = 0;
	if (num == (-1))
		sprintf(fname, "personal.ndx");
	else
		sprintf(fname, "%03d.ndx", num);
	if (!(idxFile = ftryopen(fname, "rb")))
		return 0;	// itt 0 msg van, nem error!

	fseek(idxFile, 0, SEEK_END);
	cMsgNum = ftell(idxFile) / ndxRecLen;
	return 1;
};

// returns the next letterheader in a letter_header object
letter_header *qwkpack::getNextLetter()
{
	letter_header *letter;
	ndx_rec nr;
	qwkmsg_header qh;
	long pos;
	int msgLen;
	char from[37], to[37], subject[73], date[21], buf[50];

	//if(currentLetter > mixRecord[currentAreaID].totmsgs)
	//	return NULL;

	fseek(idxFile, (currentLetter - 1) * ndxRecLen, SEEK_SET);
	if (!fread(&nr, 1, ndxRecLen, idxFile)) {
		mm->errorObject->setErrorMsg("Error reading ndx file \n\n");
		mm->errorObject->setErrorType(fatal);
		return NULL;
	};

	pos = (MSBINtolong(nr.posMSB) - 1) << 7;	// * 128

	fseek(msgdatFile, pos, SEEK_SET);
	if (!fread(&qh, 1, qmRecLen, msgdatFile)) {
		mm->errorObject->setErrorMsg("Error reading dat file \n\n");
		mm->errorObject->setErrorType(fatal);
		return NULL;
	};

	strncpy(buf, qh.chunks, 6);
	buf[6] = '\0';
	msgLen = (atoi(buf) - 1) * 128;
	(*(body + currentAreaID))[currentLetter].pointer = pos + 128;
	(*(body + currentAreaID))[currentLetter].msgLength = msgLen;

	strncpy(from, qh.from, 25);
	from[25] = '\0';
	strncpy(to, qh.to, 25);
	to[25] = '\0';
	strncpy(subject, qh.subject, 25);
	subject[25] = '\0';

	strncpy(date, qh.date, 9);
	date[8] = '\0';
	date[2] = '-';
	date[5] = '-';		// To deal with some broken messages
	strcat(date, " ");

	strncpy(buf, qh.time, 5);
	buf[5] = '\0';
	strcat(date, buf);

	cropesp(from);
	cropesp(to);
	cropesp(subject);

	letter = new letter_header(mm, stripre(subject), to, from, date,
			  0 /*ftiRec.replyto */ , 0 /*ftiRec.replyat */ ,
				   currentLetter, currentAreaID,
				0, 0 /*(ftiRec.flags & MSG_RECEIVED) */ ,
				   (qh.status == '*'),
			0, 0, ((int) qh.confMSB << 8) + (int) qh.confLSB,
				   msgLen, this);

	strncpy(buf, qh.msgnum, 7);
	buf[7] = '\0';
	letter->setMsgNum(atoi(buf));

	currentLetter++;

	return letter;
};

// returns the body of the requested letter in the active area
char *qwkpack::getBody(int ID)
{
	int c, kar, lfig;
	unsigned char *p;

	// no check, should do it in areaheader
 	fseek(msgdatFile, (*(body + currentAreaID))[ID].pointer, SEEK_SET);

	delete bodyString;
	bodyString = new char[(*(body + currentAreaID))[ID].msgLength + 1];

	lfig = 0;
	for (c = 0, p = (unsigned char *) bodyString;
	     c < (*(body + currentAreaID))[ID].msgLength; c++) {
		kar = fgetc(msgdatFile);

		// Ctrl-A line filtering (it shouldn't appear in
		// a QWK, but anyway)

		if (kar == 227) {
			*(p++) = '\n';
			if (lfig)
				p--;
			lfig = 0;
		} else if (kar == 1)
			lfig = 1;
		else if (!lfig)
			*(p++) = kar;
	}
	while (*--p == ' ');	// Kill terminal spaces
	while (*p == '\n') p--;	// Kill blank lines at end
	*++p = '\0';

	return bodyString;
};

void qwkpack::setBody(int ID, char *btext)
{
	// THIS FUNCTION SHOULD BE ELIMINATED

	ID = ID;		// warning suppression
	btext = btext;
}

int qwkpack::uncompressPacket(const char *packetName)
{
	char fname[255];

	strcpy(fname, mm->resourceObject->get(bwPacketDir));
	strcat(fname, "/");
	strcat(fname, packetName);

	return uncompressFile(mm, fname,
			      (char *) mm->resourceObject->get(bwWorkDir),
			      "*.FTI *.NDX");
};


// opens the control.dat file
void qwkpack::readControlDat(void)
{
	char line[128], *p;
	int c, pers;

	chdir(mm->resourceObject->get(bwWorkDir));
	ctrdatFile = ftryopen("control.dat", "rt");
	if (!ctrdatFile) {
		mm->errorObject->setErrorMsg("could not open control.dat file");
		mm->errorObject->setErrorType(fatal);
		return;
	};

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 1: BBS name

	qwkinfo->bbsname = strdupplus(line);
	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 2: city/state

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 3: phone#

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 4: sysop's name
	int slen = strlen(line);
	if (slen > 6) {
		p = line + slen - 5;
		if (!strcasecmp(p, "Sysop")) {
			if (*--p == ' ')
				p--;
			if (*p == ',')
				*p = '\0';
		}
	}
	qwkinfo->sysop = strdupplus(line);

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 5: doorserno,BBSid

	p = strtok(line, ",");
	p = strtok(NULL, " ");
	qwkinfo->bbsid = strdupplus(p);
	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 6: time&date

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 7: USERNAME

	qwkinfo->username = strdupplus(line);
	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 8: blank/any

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 9: anyth.

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 10: anyth.

	fgets(line, 127, ctrdatFile);
	strtok(line, "\r\n");	// 11: Max conf# - 1!

	maxConf = atoi(line) + 1;

	mm->resourceObject->set(qwkBBSID, (char *) qwkinfo->bbsid);
	mm->resourceObject->set(bwLoginName, (char *) qwkinfo->username);
	mm->resourceObject->set(bwAliasName, (char *) qwkinfo->username);
	mm->resourceObject->set(bwSysOpName, (char *) qwkinfo->sysop);
	mm->resourceObject->set(bwBBSName, (char *) qwkinfo->bbsname);

	pers = openIndex(-1);
	if (pers)
		maxConf++;
	areas = new AREAs[maxConf + 1];
	if (pers) {
		areas[1].num = -1;
		areas[1].name = strdupplus("PERSONAL");
		areas[1].nummsgs = 0;
	}
	for (c = pers + 1; c <= maxConf; c++) {
		fgets(line, 127, ctrdatFile);
		strtok(line, "\r\n");	// conf# 

		areas[c].num = atoi(line);
		fgets(line, 127, ctrdatFile);
		strtok(line, "\r\n");	// conf name

		areas[c].name = strdupplus(line);
		areas[c].nummsgs = 0;
	}

	fclose(ctrdatFile);
};

// Opens the messages.dat file
void qwkpack::initMessagesDat(void)
{
	chdir(mm->resourceObject->get(bwWorkDir));

	if (!(msgdatFile = ftryopen("messages.dat", "rb"))) {
		mm->errorObject->setErrorMsg(
			"could not open messages.dat file");
		mm->errorObject->setErrorType(fatal);
	};
};
