/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <dirent.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#include "resource.h"

// ------------------------------------------------------------------------
// packet_list functions
// ------------------------------------------------------------------------

packet_list::packet_list(mmail *mmA)
{
	mm = mmA;
	initPackets((char *) mm->resourceObject->get(bwPacketDir));
	psort();
};

packet_list::~packet_list()
{
	for (int c = 1; c <= noOfPackets; c++)
		delete packets[c];
	delete packets;
};

void packet_list::initPackets(char *bwDirName)
{
	DIR *bwDir;
	struct dirent *entry;
	struct stat fileStat;

	if (!(bwDir = opendir(bwDirName)))
		fatalError("There is no Packet Dir!\n");

	chdir(bwDirName);

	// Lame, but I don't like lists 
	noOfPackets = 0;
	while ((entry = readdir(bwDir)))
		if (!(stat(entry->d_name, &fileStat)))
			if ((!access(entry->d_name, R_OK)) &&
			    (entry->d_name[0] != '.'))
				noOfPackets++;

	rewinddir(bwDir);
	packets = new packet_header *[noOfPackets + 1];

	int c = 1;
	while ((entry = readdir(bwDir)))
		if (!(stat(entry->d_name, &fileStat)))
			if ((!access(entry->d_name, R_OK)) &&
			    (entry->d_name[0] != '.'))
				packets[c++] = new packet_header(mm,
				       entry->d_name, 0, 0, 0,
					fileStat.st_mtime, fileStat.st_size);

	closedir(bwDir);
};

void packet_list::pswap(int a, int b)
{
	packet_header *ph;
	ph = packets[a];
	packets[a] = packets[b];
	packets[b] = ph;
}

void packet_list::packqsort(int left, int right)
{
	int lower, upper, d, t;
	packet_header *pivot;

	lower = left;
	upper = right;
	pivot = packets[((left + right) >> 1)];
	do {
		do {
			d = strcasecmp(packets[lower]->getName(),
				pivot->getName());
			t = (d < 0);
			if (t)
				lower++;
		} while (t);
		do {
			d = strcasecmp(packets[upper]->getName(),
				pivot->getName());
			t = (d > 0);
			if (t)
				upper--;
		} while (t);
		if (lower <= upper) {
			if (lower != upper)
				pswap(lower, upper);
			lower++;
			upper--;
		}
	} while (lower < upper);
	if (left < upper)
		packqsort(left, upper);
	if (lower < right)
		packqsort(lower, right);
}

void packet_list::psort()
{
	if (noOfPackets > 1)
		packqsort(1, noOfPackets);
}

int packet_list::getNoOfPackets()
{
	return noOfPackets;
};

int packet_list::gotoPacket(int packetNo)
{
	if ((packetNo < 1) || (packetNo > noOfPackets))
		return -1;
	activePacket = packetNo;
	return 0;
};

char *packet_list::getName()
{
	if (noOfPackets)
		return packets[activePacket]->getName();
	else
		return NULL;
}

time_t packet_list::getDate()
{
	if (noOfPackets)
		return packets[activePacket]->getDate();
	else
		return 0;
};

off_t packet_list::getSize()
{
	if (noOfPackets)
		return packets[activePacket]->getSize();
	else
		return 0;
};

int packet_list::getNoOfLetters()
{
	if (noOfPackets)
		return packets[activePacket]->getNoOfLetters();
	else
		return -1;
}

int packet_list::getNoOfUnread()
{
	if (noOfPackets)
		return packets[activePacket]->getNoOfUnread();
	else
		return -1;
};

int packet_list::getNoOfPersonal()
{
	if (noOfPackets)
		return packets[activePacket]->getNoOfPersonal();
	else
		return -1;
};



// --------------------------------------------------------------------------
// packet_header methods
// --------------------------------------------------------------------------
packet_header::packet_header(mmail *mmA, char *nameA, int noOfLettersA,
	      int noOfUnreadA, int noOfPersonalA, time_t dateA, off_t sizeA)
{
	mm = mmA;
	name = strdupplus(nameA);
	noOfLetters = noOfLettersA;
	noOfPersonal = noOfPersonalA;
	noOfUnread = noOfUnreadA;
	date = dateA;
	size = sizeA;
}

packet_header::~packet_header()
{
	delete name;
};

char *packet_header::getName()
{
	return name;
}

time_t packet_header::getDate()
{
	return date;
};

off_t packet_header::getSize()
{
	return size;
}

int packet_header::getNoOfLetters()
{
	return noOfLetters;
}

int packet_header::getNoOfUnread()
{
	return noOfUnread;
};

int packet_header::getNoOfPersonal()
{
	return noOfPersonal;
};
