/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
   The first element of each array is 0
   The caller deletes the objects
   The areas are continually numbered from 1k
 */

#include "bw.h"
#include "bwreply.h"
#include "misc.h"
#include "mmail.h"

mmail::mmail()
{
	errorObject = new error(this);
	resourceObject = new resource(this);
};

mmail::~mmail()
{
	delete errorObject;
	delete resourceObject;
	if (areaList)
		delete areaList;
	if (driverList)
		delete driverList;
	delete errorObject;
	delete resourceObject;
};

packet_list *mmail::getPacketList()
{
	if (packetList)
		delete packetList;
	packetList = new packet_list(this);
	return packetList;
};

void mmail::selectPacket(char *packetName)
{
	if (areaList)
		delete areaList;
	if (driverList)
		delete driverList;
	resourceObject->set(bwPacketName, packetName);
	driverList = new driver_list(this);
	areaList = new area_list(this);
};

void mmail::saveRead()
{
	if (driverList)
		driverList->getReadObject(driverList->getDriver(2))->saveAll();
};
