/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <ctype.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "isoconvtab.h"
#include "misc.h"
#include "mmail.h"

char *cropesp(char *st)  // takes off the spaces from the end of a string
{
	char *p;

	for (p = &st[strlen(st) - 1]; (p > st) && (*p == ' '); p--);
	*++p = '\0';
	return st;
}

char *strdupplus(const char *original)
{
	char *tmp;

	tmp = strdup(original);
	if (!tmp)
		cerr << " SSSUUUUXXXX out of memory";
	return tmp;
};

int numcmp(const char *first, const char *second)
{
	int c;

	for (c = 0; c < 6; c++)
		if (toupper(first[c]) != toupper(second[c]))
			return 1;
		else if (!first[c] && !second[c])
			return 0;

	return 0;
};

char *findBaseName(const char *fileName)
{
	int c, d;
	char *tmp;

	for (c = 0; (fileName[c] != '.') && (fileName[c]); c++);
	tmp = new char[c + 1];

	for (d = 0; d < c; d++)
		tmp[d] = toupper(fileName[d]);
	tmp[d] = '\0';

	return tmp;
};

long getFileLen(char *fileName)
{
	FILE *file;
	long fileLen;

	file = ftryopen(fileName, "r");		// !! check it !

	fseek(file, 0, SEEK_END);
	fileLen = ftell(file);

	fclose(file);
	return fileLen;
};

void fatalError(char *description)
{
	cerr << "\n\nfatal error:\n" << description << "\n\n";
	exit(-1);
};

const char *month_abbr[] =
{"Jan", "Feb", "Mar", "Apr", "Mar", "Jun",
 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

int monthval(char *abbr)
{
	int c;

	for (c = 0; c < 12; c++)
		if (!strcmp(month_abbr[c], abbr))
			return c + 1;

	return 1;
}

void strupr(char *st)
{
	for (; *st; st++)
		*st = toupper(*st);
}

void strlwr(char *st)
{
	for (; *st; st++)
		*st = tolower(*st);
}

FILE *ftryopen(const char *fname, const char *mode)
{
	FILE *g;
	char *fn, *p, *q = NULL;

	if ((g = fopen(fname, mode)))
		return g;

	fn = strdupplus(fname);
	for (p = &fn[strlen(fn) - 1]; (*p != '/') && p > fn; p--)
		if ((*p == '.') && !q)
			q = p + 1;
	if (*p == '/')
		p++;

	strlwr(p);		// Lowercase name after path

	if ((g = fopen(fn, mode))) {
		free(fn);
		return g;
	}
	if (q) {		// Uppercase extension only, if found
		strupr(q);
		if ((g = fopen(fn, mode))) {
			free(fn);
			return g;
		}
	}
	strupr(p);		// Uppercase name after path

	if ((g = fopen(fn, mode))) {
		free(fn);
		return g;
	}
	if (q) {		// Lowercase extension, if found
		strlwr(q);
		if ((g = fopen(fn, mode))) {
			free(fn);
			return g;
		}
	}
	free(fn);
	return NULL;
}

char *charconv(char *buf, int cdir)
{
	char *p;
	const char *ct;
	switch (cdir) {
	case CC_ISOTO437:
		ct = iso2dostab;
		break;
	case CC_437TOISO:
		ct = dos2isotab;
		break;
	default:
		return buf;
	}

	for (p = buf; *p; p++)
		*p = ct[*((unsigned char *) p)];

	return buf;
}

int todos(const char *org, const char *dest)
{
	FILE *orgfile, *destfile;
	int c;

	if (!(orgfile = ftryopen(org, "r")))
		return 1;
	if (!(destfile = fopen(dest, "w")))
		return 1;

	while ((c = fgetc(orgfile)) != EOF) {
		if (c == '\n')
			fputc('\r', destfile);
		fputc(c, destfile);
	}

	fclose(destfile);
	fclose(orgfile);

	return 0;
}

int fromdos(const char *org, const char *dest)
{
	FILE *orgfile, *destfile;
	int c;

	if (!(orgfile = ftryopen(org, "r")))
		return 1;
	if (!(destfile = fopen(dest, "w")))
		return 1;

	while ((c = fgetc(orgfile)) != EOF) {
		if (c != '\r')
			fputc(c, destfile);
	}

	fclose(destfile);
	fclose(orgfile);

	return 0;
}

char *stripre(char *subject)
{
        if (!strncasecmp(subject, "re: ", 4))
                subject += 4;
	return subject;
}
