/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef INTERNAL_DRIVER_H
#define INTERNAL_DRIVER_H

#include "mmail.h"

class net_address;
class area_header;
class letter_header;
class mmail;

class specific_driver
{
public:
	virtual ~specific_driver(){};
	virtual int getNoOfAreas()=0;
	virtual void resetAll()=0;
	virtual area_header *getNextArea()=0;
	virtual void selectArea(int ID)=0;
	virtual int getNoOfLetters()=0;
	virtual void resetLetters()=0;
	virtual letter_header *getNextLetter()=0;
	virtual char *getBody(int ID)=0;
	virtual void setBody(int ID, char *btext)=0; // csak reply-nel megy majd
};

class reply_driver : public specific_driver
{
public:	
	virtual ~reply_driver(){};
	virtual void enterLetter(letter_header *newLetter,
			char *newLetterFileName)=0;
	virtual void enterNetDest(net_address netAdress)=0;
	virtual void killLetter(int letterNo)=0;
	virtual area_header *refreshArea()=0;
	virtual void makeReply()=0;
};

	
#endif
