/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "bw.h"
#include "bwreply.h"
#include "misc.h"
#include "mmail.h"
#include "qwk.h"
#include "qwkreply.h"

// ---------------------------------------------------------------------------
// DriverList methods
// ---------------------------------------------------------------------------

driver_list::driver_list(mmail *mmA)
{
	mm = mmA;
	int qwkmode;

	qwkmode = (mm->resourceObject->getValue(packMode) == PM_QWK);

	if (!qwkmode)
		driverList[2].driver = new bluewave(mm);
	else
		driverList[2].driver = new qwkpack(mm);

	driverList[2].read = new bw_read_class(mm, driverList[2].driver);
	driverList[2].offset = 1;
	driverList[2].noOfAreas = driverList[2].driver->getNoOfAreas();
	driverList[2].type = bw;	// what? argh

	if (!qwkmode)
		driverList[1].driver = new bwreply(mm);
	else
		driverList[1].driver = new qwkreply(mm);

	driverList[1].read = new dummy_read_class(mm, driverList[1].driver);
	driverList[1].offset = 0;
	driverList[1].noOfAreas = driverList[1].driver->getNoOfAreas();
	driverList[1].type = bwrep;

	noOfDrivers = 2;
};

driver_list::~driver_list()
{
	//for(int c=1; c<=noOfDrivers; c++)
	//	delete driverList[c].driver;
	delete driverList[1].read;
	delete driverList[1].driver;
	delete driverList[2].read;
	delete driverList[2].driver;
};

int driver_list::getNoOfDrivers()
{
	return noOfDrivers;
};

specific_driver *driver_list::getDriver(int areaNo)
{
	for (int c = 1; c <= noOfDrivers; c++)
		if ((areaNo > driverList[c].offset) &&
		    (areaNo <= driverList[c].offset + driverList[c].noOfAreas))
			return driverList[c].driver;
	fatalError("fatal error in: getDriver: areano:");
	return NULL;	// Never reached -- warning suppression
};

reply_driver *driver_list::getReplyDriver(int areaNo)
{
	if (!((areaNo >= 1) && (areaNo <= driverList[2].noOfAreas +
			      driverList[2].offset)))
		fatalError("You can not reply there(int. error) ");
	return (reply_driver *) driverList[1].driver;
};

read_class *driver_list::getReadObject(specific_driver *driver)
{
	for (int c = 1; c <= noOfDrivers; c++)
		if (driver == driverList[c].driver)
			return driverList[c].read;
	return NULL;
};

int driver_list::getOffset(specific_driver *driver)
{
	for (int c = 1; c <= noOfDrivers; c++)
		if (driver == driverList[c].driver)
			return driverList[c].offset;
	fatalError("in driver_list::getOffset() : no appr. driver reg'd!");
	return -1;
};
