/*
 * MultiMail offline mail reader
 * 

 Written by John Zero <john@graphisoft.hu>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <unistd.h>

#include "compress.h"
#include "misc.h"
#include "mmail.h"
#include "../interface/mysystem.h"

int lastAType = 0;	// saves&stores last arch type for compress routine

int getArchiveType(mmail *mm, char *fname)
{
	FILE *f;
	unsigned magic;
	int tip;

	if (!(f = fopen(fname, "rb"))) {
		mm->errorObject->setErrorMsg(
				  "could not open packet to uncompress");
		mm->errorObject->setErrorType(fatal);
		return -1;
	};
	magic = 256 * fgetc(f);
	magic += fgetc(f);

	tip = A_UNKNOWN;
	switch (magic) {
	case 0x60EA:
		tip = A_ARJ;

	case 0x504B:		// PK - check for ZIP
		if (3 == fgetc(f))
			if (4 == fgetc(f))
				tip = A_ZIP;

	default:		// can be LHA - check 3. and 4. bytes
		if ('-' == fgetc(f))
			if ('l' == fgetc(f))
				tip = A_LHA;
	// we should check another byte (l/z) but i'm lazy
	}
	fclose(f);

	return tip;
}


// clears the working directory and uncompresses the packet into it.
int uncompressFile(mmail *mm, char *fname, char *todir, char *delstr)
{
	char command[255];
	int at;

	chdir(todir);
	if (delstr) {
		sprintf(command, "rm -f %s", delstr);
		mysystem(command);
	}
	at = getArchiveType(mm, fname);
	lastAType = at;
	switch (at) {
	case A_ARJ:
		sprintf(command, "%s %s",
		   mm->resourceObject->get(arjUncompressCommand), fname);
		break;
	case A_ZIP:
		sprintf(command, "%s %s",
		   mm->resourceObject->get(zipUncompressCommand), fname);
		break;
	case A_LHA:
		sprintf(command, "%s %s",
		   mm->resourceObject->get(lhaUncompressCommand), fname);
		break;
	case A_UNKNOWN:
		sprintf(command, "%s %s",
		   mm->resourceObject->get(unknownUncompressCommand), fname);
		break;
	}

	if (mysystem(command)) {
		mm->errorObject->setErrorMsg("could not uncompress packet");
		mm->errorObject->setErrorType(fatal);
		return -1;
	};

	return 0;
};


void compressAddFile(mmail *mm, char *arcdir, char *arcfile, char *addfname)
{
	char tmp[255];
	const char *cm;
	char *sa = NULL;	// to suppress warning message

	const char *lhax = "lhatemp.lzh";
	const char *lhab = "lhatemp.bak";

	switch (lastAType) {
	case A_ARJ:
		cm = (char *) mm->resourceObject->get(arjCompressCommand);
		break;
	case A_ZIP:
		cm = (char *) mm->resourceObject->get(zipCompressCommand);
		break;
	case A_LHA:		// cause of LHA's "feature" we need to:
		sprintf(tmp, "cp %s/%s %s/%s", arcdir, arcfile, arcdir, lhax);
		mysystem(tmp);
		sa = arcfile;
		arcfile = (char *) lhax;
		cm = (char *) mm->resourceObject->get(lhaCompressCommand);
		break;
	default:
		cm = (char *) mm->resourceObject->get(unknownCompressCommand);
	}
	sprintf(tmp, "%s %s/%s %s", cm, arcdir, arcfile, addfname);
	mysystem(tmp);

	if (lastAType == A_LHA) {	// then the fixup
		sprintf(tmp, "cp %s/%s %s/%s", arcdir, lhax, arcdir, sa);
		mysystem(tmp);
		sprintf(tmp, "rm -f %s/%s", arcdir, lhax);
		mysystem(tmp);
		// meg bak is van!
		sprintf(tmp, "rm -f %s/%s", arcdir, lhab);
		mysystem(tmp);
	}
};
