/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef REPLY_H
#define REPLY_H

#undef BIG_ENDIAN
#include "bluewave.h"
#include "internal.h"
#include "mmail.h"

class bwreply : virtual public reply_driver
{
private:

	struct upl_list {
		UPL_REC uplRec;
		upl_list *nextRecord;
		char fname[50];
	};
	
	mmail *mm;
	area_header *replyAreaHeader;
	int currentLetter;
	int noOfLetters;
	char *replyPacketName;
	int replyExists;
	char *replyText;
	net_address netAddr;
	
	FILE *uplFile;
	FILE *currentMsgFile;

	UPL_HEADER *uplHeader;
	
	struct upl_list *uplListHead;
	struct upl_list *uplListCurrent;
	
	void init();
	void cleanup();
	int uncompress();
	int getNew1(FILE *uplFile, upl_list *l, int recnum);
	void readUpl();
	void addNew1(FILE *uplFile, upl_list *l);
	char *newFileName(const char *bwFileName);
	char *freeFileName();

public:
	bwreply(mmail *mmA);
	~bwreply();
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int ID);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char *getBody(int ID);
	void setBody(int ID, char *btext);
	void enterLetter(letter_header *newLetter, char *newLetterFileName);
	void enterNetDest(net_address netAddress);
	void killLetter(int letterNo);
	area_header *refreshArea();
	void makeReply();
};

#endif
