/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/utsname.h>

#include "bwreply.h"
#include "compress.h"
#include "misc.h"
#include "resource.h"
#include "../interface/mysystem.h"

// current
bwreply::bwreply(mmail *mmA)
{
	mm = mmA;
	init();
};

bwreply::~bwreply()
{
	if (replyExists)
		cleanup();
};

void bwreply::init()
{
	uplHeader = new UPL_HEADER;
	replyText = new char[1];
	replyPacketName = newFileName(mm->resourceObject->get(bwPacketName));
	chdir(mm->resourceObject->get(bwReplyDir));

	if (access(replyPacketName, W_OK) == 0)
		replyExists = 1;
	else
		replyExists = 0;

	//if exists, read the letters

	if (replyExists) {
		uncompress();
		readUpl();
		currentLetter = 1;
	} else {
		uplListHead = NULL;
		noOfLetters = 0;
		currentLetter = 0;
	};
};

void bwreply::cleanup()
{
	upl_list *curr, *next;

	delete uplHeader;
	delete replyText;
	delete replyPacketName;

	curr = uplListHead;

	for (int c = 0; c < noOfLetters; c++) {
		remove(curr->fname);
		next = curr->nextRecord;
		delete curr;
		curr = next;
	};
};

char *bwreply::newFileName(const char *bwFile)
{
	int c;
	char *tmp;
	char suffix[5];

	if (tolower(bwFile[0]) == bwFile[0])	// lower-case
		strcpy(suffix, ".new");
	else
		strcpy(suffix, ".NEW");

	for (c = 0; bwFile[c] != '.'; c++);
	tmp = new char[c + 5];
	for (int d = 0; d < c; tmp[d] = bwFile[d++]);
	strcpy(tmp + c, suffix);

	return tmp;
};

int bwreply::uncompress()
{
	char fname[255];

	strcpy(fname, mm->resourceObject->get(bwReplyDir));
	strcat(fname, "/");
	strcat(fname, replyPacketName);
	return uncompressFile(mm, fname, (char *) mm->resourceObject->
	    get(bwUpWorkDir), "*" /* this is dangerous!!! (rm -f *) */ );
};

int bwreply::getNew1(FILE *uplFile, upl_list *l, int recnum)
{
	int *broaf;

	fseek(uplFile, uplHeader->upl_header_len + recnum * uplHeader->
		upl_rec_len, SEEK_SET);
	if (fread(&(l->uplRec), sizeof(UPL_REC), 1, uplFile) <= 0)
		return -1;

	tmpnam(l->fname);
	fromdos((char *) l->uplRec.filename, l->fname);
	remove((char *) l->uplRec.filename);

	broaf = (int *) (l->uplRec.user_area);
	*broaf = (int) getFileLen((char *) l->fname);

	return 0;
}

void bwreply::readUpl()
{
	char uplName[14], *tmp;
	int uplLength;
	upl_list *prevUplList, *currUplList;

	chdir(mm->resourceObject->get(bwUpWorkDir));
	tmp = findBaseName(replyPacketName);
	strcpy(uplName, tmp);
	strcat(uplName, ".UPL");
	delete tmp;

	if (!(uplFile = ftryopen(uplName, "rw")))
		fatalError("error opening UPL");

	if (!fread(uplHeader, sizeof(UPL_HEADER), 1, uplFile))
		fatalError("error reading UPL file");

	fseek(uplFile, 0, SEEK_END);
	uplLength = ftell(uplFile);

	noOfLetters = (int)
	    ((uplLength - uplHeader->upl_header_len) / uplHeader->upl_rec_len);

	uplListHead = new upl_list;
	getNew1(uplFile, uplListHead, 0);	// check!
	prevUplList = uplListHead;
	uplListHead->nextRecord = NULL;

	for (int c = 1; c <= noOfLetters - 1; c++) {
		currUplList = new upl_list;
                if (getNew1(uplFile, currUplList, c)) {    // ha eof/error
                        delete currUplList;
                        break;
                }
		prevUplList->nextRecord = currUplList;
		prevUplList = currUplList;
		currUplList->nextRecord = NULL;
	};
	fclose(uplFile);
	remove(uplName);
};

int bwreply::getNoOfAreas()
{
	return 1;
};

void bwreply::resetAll()
{
	cleanup();
	init();
};

area_header *bwreply::getNextArea()
{
	resetLetters();
	replyAreaHeader = new area_header(mm, 1, "REPLY", "REPLIES",
		     "Letters written by You", bwrep, noOfLetters, 0, 0, 0);
	return replyAreaHeader;
};

void bwreply::selectArea(int ID)
{
	if (ID == 1)
		resetLetters();
};

void bwreply::resetLetters()
{
	currentLetter = 1;
	uplListCurrent = uplListHead;
};

int bwreply::getNoOfLetters()
{
	return noOfLetters;
};

letter_header *bwreply::getNextLetter()
{
	int areaNo;
	time_t unixTime;
	char *date;
	letter_header *newLetter;

	unixTime = uplListCurrent->uplRec.unix_date;

	date = ctime(&unixTime);
	date[strlen(date) - 1] = '\0';

	areaNo = 1;
	for (int c = 1; c <= mm->areaList->noOfAreas(); c++)
		if (!strcmp(mm->areaList->getName(c),
			    (char *) uplListCurrent->uplRec.echotag))
			areaNo = c;

	newLetter = new letter_header(mm, (char *) uplListCurrent->uplRec.subj,
				      (char *) uplListCurrent->uplRec.to,
			      (char *) uplListCurrent->uplRec.from, date,
				      0, 0, currentLetter, areaNo, 0, 0,
			 (uplListCurrent->uplRec.msg_attr & UPL_PRIVATE),
				      0, 0, 0,
		      *(int *) (uplListCurrent->uplRec.user_area), this);

	uplListCurrent = uplListCurrent->nextRecord;

	currentLetter++;
	return newLetter;
};

char *bwreply::getBody(int ID)
{
	FILE *replyFile;
	upl_list *actUplList;

	delete replyText;

	actUplList = uplListHead;
	for (int c = 1; c <= ID - 1; c++)
		actUplList = actUplList->nextRecord;

	replyFile = ftryopen(actUplList->fname, "r");
	// !! check it !

	replyText = new char[(*(int *) (actUplList->uplRec.user_area)) + 1];
	fread(replyText, *(int *) (actUplList->uplRec.user_area), 1, replyFile);
	replyText[*(int *) (actUplList->uplRec.user_area)] = '\0';
	fclose(replyFile);
	return replyText;
};

void bwreply::setBody(int ID, char *btext)
{
	FILE *replyFile;
	upl_list *actUplList;
	int *len;

	actUplList = uplListHead;
	for (int c = 1; c <= ID - 1; c++)
		actUplList = actUplList->nextRecord;

	//chdir(mm->resourceObject->get(bwUpWorkDir));

	replyFile = ftryopen(actUplList->fname, "w");
	// !! check it !
	len = (int *) (actUplList->uplRec.user_area);
	*len = strlen(btext);
	fwrite(btext, *(int *) (actUplList->uplRec.user_area), 1, replyFile);
	fclose(replyFile);
};

void bwreply::enterLetter(letter_header *newLetter, char *newLetterFileName)
{
	int *broaf;
	upl_list *workList, *newList;

	workList = uplListHead;

	for (int c = 1; c < noOfLetters; c++)	//go to last elem
		workList = workList->nextRecord;

	newList = new upl_list;

	memset((void *) &(newList->uplRec), 0, sizeof(UPL_REC));

	// fill the fields of UPL_REC
	strncpy((char *) newList->uplRec.from, newLetter->getFrom(), 36);
	strncpy((char *) newList->uplRec.to, newLetter->getTo(), 36);
	strncpy((char *) newList->uplRec.echotag,
		mm->resourceObject->get(bwEchoTag), 21);
	strcpy(newList->fname, newLetterFileName);
	newList->uplRec.unix_date = (long) time(NULL);
	if (netAddr.zone) {
		newList->uplRec.msg_attr |= UPL_NETMAIL;
		newList->uplRec.destzone = netAddr.zone;
		newList->uplRec.destnet = netAddr.net;
		newList->uplRec.destnode = netAddr.node;
		newList->uplRec.destpoint = netAddr.point;
		netAddr.zone = 0;
	};

	if (newLetter->getPrivate())
		newList->uplRec.msg_attr |= UPL_PRIVATE;

	newList->uplRec.replyto = (unsigned long) newLetter->getReplyTo();
	if (newList->uplRec.replyto)
		newList->uplRec.msg_attr |= UPL_IS_REPLY;

	// Hard-wired subject length 72? The door will probably take care of
	// that, but it *should* be based on the INF_HEADER's subject_len...
	// which is not accessible here. Redesign needed.

	if (newList->uplRec.replyto && (strlen(newLetter->getSubject()) < 69)) {
		strcpy((char *) newList->uplRec.subj, "Re: ");
		strncat((char *) newList->uplRec.subj,
			newLetter->getSubject(), 68);
	}
	else
		strncpy((char *) newList->uplRec.subj,
			newLetter->getSubject(), 72);

	broaf = (int *) (newList->uplRec.user_area);
	*broaf = (int) getFileLen(newList->fname);

	if (!workList)
		uplListHead = newList;
	else
		workList->nextRecord = newList;

	newList->nextRecord = NULL;
	noOfLetters++;
	replyExists = 1;
};

void bwreply::enterNetDest(net_address netAddress)
{
	netAddr = netAddress;
};

void bwreply::killLetter(int letterNo)
{
	upl_list *actUplList, *tmpUplList;

	if ((noOfLetters == 0) || (letterNo < 1) || (letterNo > noOfLetters))
		fatalError(
		" bwreply::killLetter ::fukka ! roszzat akarsz torolni!: ");

	// deleting the 1st letter
	if (letterNo == 1) {
		tmpUplList = uplListHead;
		uplListHead = uplListHead->nextRecord;
	} else {
		actUplList = uplListHead;
		for (int c = 1; c <= letterNo - 2; c++)
			actUplList = actUplList->nextRecord;

		tmpUplList = actUplList->nextRecord;

		//deleting the last letter
		if (letterNo == noOfLetters)
			actUplList->nextRecord = NULL;
		else	// deleting from the middle
			actUplList->nextRecord =
			    actUplList->nextRecord->nextRecord;
	}
	noOfLetters--;
	remove(tmpUplList->fname);
	delete tmpUplList;
	resetLetters();
};

area_header *bwreply::refreshArea()
{
	replyAreaHeader = new area_header(mm, 1, "REPLY", "REPLIES",
		     "Letters written by you", bwrep, noOfLetters, 0, 0, 0);
	resetLetters();
	return replyAreaHeader;
};

void bwreply::addNew1(FILE *uplFile, upl_list *l)
{
	strcpy((char *) l->uplRec.filename, freeFileName());
	todos(l->fname, (char *) l->uplRec.filename);
	fwrite(&(l->uplRec), sizeof(UPL_REC), 1, uplFile);
}

void bwreply::makeReply()
{
	upl_list *actUplList;
	UPL_HEADER newUplHeader;
	FILE *uplFile;
	char uplFileName[13], *tmp, tmp1[255];

	// cd to upload dir
	if (chdir(mm->resourceObject->get(bwUpWorkDir)))
		fatalError(
		"\n Could not cd to bwupworkdir in bwreply::makeReply\n\n");

	// Delete old file -- hmm, could trash old replies if the pack fails
	strcpy(tmp1, mm->resourceObject->get(bwReplyDir));
	strcat(tmp1, "/");
	strcat(tmp1, replyPacketName);
	remove(tmp1);

	if (!noOfLetters)
		return;

	// fill the UPL_HEADER struct
	memset(&newUplHeader, 0, sizeof(UPL_HEADER));
	newUplHeader.reader_major = MM_MAJOR;
	newUplHeader.reader_minor = MM_MINOR;
	sprintf((char *) newUplHeader.vernum, "%d.%d", MM_MAJOR, MM_MINOR);
	for (int c = 0; newUplHeader.vernum[c]; newUplHeader.vernum[c++] -= 10);
	struct utsname buf;
	uname(&buf);
	sprintf((char *) newUplHeader.reader_name, "%s/%s", MM_NAME,
		buf.sysname);
	newUplHeader.upl_header_len = sizeof(UPL_HEADER);
	newUplHeader.upl_rec_len = sizeof(UPL_REC);
	strncpy((char *) newUplHeader.loginname,
		mm->resourceObject->get(bwLoginName), 44);
	strncpy((char *) newUplHeader.aliasname,
		mm->resourceObject->get(bwAliasName), 44);
	if (strlen(buf.sysname) + strlen(MM_NAME) < 17)
		sprintf((char *) newUplHeader.reader_tear, "%s/%s", MM_NAME,
			buf.sysname);
	else
		strncpy((char *) newUplHeader.reader_tear, MM_NAME, 16);

	// find out the name of the upl file
	tmp = findBaseName(mm->resourceObject->get(bwPacketName));
	strcpy(uplFileName, tmp);
	strcat(uplFileName, ".UPL");
	delete tmp;

	// create the new UPL file
	uplFile = fopen(uplFileName, "w");
	//!! no check yet
	fwrite(&newUplHeader, sizeof(UPL_HEADER), 1, uplFile);

	actUplList = uplListHead;

	for (int c = 0; c < noOfLetters; c++) {
		addNew1(uplFile, actUplList);
		actUplList = actUplList->nextRecord;
	};

	fclose(uplFile);

	//pack the files

	char *tmplist = new char[80];
	sprintf(tmplist, "%s *.MSG", uplFileName);

	compressAddFile(mm, (char *) mm->resourceObject->get(bwReplyDir),
			replyPacketName, tmplist);

	delete tmplist;

	// clean up the work area
	//!! danger !!
	mysystem("rm *");
};

char *bwreply::freeFileName()
{
	char testFileName[255];

	for (long c = 0; c <= 99999; c++) {
		sprintf(testFileName, "%05ld.MSG", c);
		if (access(testFileName, R_OK) == -1)
			return strdupplus(testFileName);
	}
	fatalError("No more than 99999 replies allowed in a packet !");
	return NULL;	// Never reached -- warning suppression
};
