/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef BW_H
#define BW_H

#include <stdio.h>

#undef BIG_ENDIAN
#include "bluewave.h"
#include "internal.h"

struct bodytype
{
	long pointer;
	long msgLength;
};

class bluewave : public specific_driver
{
private:
	mmail		*mm;
	char		*packetBaseName;
	char		*bwDirName;
	char		*packetName;
	INF_HEADER	*infoHeader;
	MIX_REC		*mixRecord;
	int		currentAreaID;
	int		currentLetter;
	
	FILE		*infFile;
	FILE		*mixFile;
	FILE		*ftiFile;
	FILE		*datFile;

	struct bodytype	**body;
	char		*bodyString;

	int	infoHeaderLen, infoAreainfoLen, mixStructLen, ftiStructLen;
	int	noOfInfRecs;
	int	noOfMixRecs;

	int	areaSerial;
	int	ID;

	int 	uncompressPacket(const char *packetName);
	void	initInf(const char *packetBaseName);
	void	readMixRec(const char *packetBaseName);
	void	initFti(const char *packetBaseName);
	void	initDat(const char *packetBaseName);

	void	init();
	void	cleanup();

	
public:
	bluewave(mmail *mmA);
	~bluewave();
	int getNoOfAreas();
	void resetAll();
	area_header *getNextArea();
	void selectArea(int ID);
	int getNoOfLetters();
	void resetLetters();
	letter_header *getNextLetter();
	char* getBody(int ID);
	void setBody(int ID, char *btext );
};

#endif  
