/*
 * MultiMail offline mail reader
 * 

 Written by Toth Istvan <stoty@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "bw.h"
#include "bwreply.h"
#include "misc.h"
#include "mmail.h"

// ---------------------------------------------------------------------------
// Area header methods
// ---------------------------------------------------------------------------

area_header::area_header(mmail *mmA, int numA, const char *shortNameA,
	    const char *nameA, const char *descriptionA,
	    areatype typeA, int noOfLettersA, int noOfUnreadA,
	    int noOfPersonalA, int useAliasA)
{
	mm = mmA;
	shortName = strdupplus(shortNameA);
	name = strdupplus(nameA);
	description = strdupplus(descriptionA);
	type = typeA;
	num = numA;
	noOfLetters = noOfLettersA;
	noOfPersonal = noOfPersonalA;
	noOfUnread = noOfUnreadA;	//supress warning, unneccessary ?
	useAlias = useAliasA;

	ID = 0;			//not ready

	driver = mm->driverList->getDriver(num);
};

area_header::~area_header()
{
	delete shortName;
	delete name;
	delete description;
};

const char *area_header::getName()
{
	return name;
};

const char *area_header::getShortName()
{
	return shortName;
};

const char *area_header::getDescription()
{
	return description;
};

const enum areatype area_header::getType()
{
	return type;
};

const int area_header::getNoOfLetters()
{
	return noOfLetters;
};

const int area_header::getNoOfUnread()
{
	return (mm->driverList->getReadObject(driver))->getNoOfUnread(num -
				      mm->driverList->getOffset(driver));
};

const int area_header::getNoOfPersonal()
{
	return noOfPersonal;
};

const int area_header::getID()
{
	return ID;
};

const int area_header::getNum()
{
	return num;
};

const int area_header::getUseAlias()
{
	return useAlias;
};


// ---------------------------------------------------------------------------
// Arealist methods
// ---------------------------------------------------------------------------

area_list::area_list(mmail *mmA)
{
	mm = mmA;
	int c;

	no = 0;
	c = 1;

	actLetterList = NULL;
	actDriver = NULL;


	do {
		no += mm->driverList->getDriver(no + 1)->getNoOfAreas();
		c++;
	} while (c <= mm->driverList->getNoOfDrivers());

	areaHeader = new area_header *[no + 1];

	for (c = 1; c <= no; c++) {
		actDriver = mm->driverList->getDriver(c);
		areaHeader[c] = actDriver->getNextArea();
	};

	current = 1;

	// 1. Find out what types of areas we have (i.e. qwk, usent... )        
	// 2. Create the appropriate driver objects
	// 3. Find out the number of areas for each type
	// 4. allocate the memory for the area_header descriptoirs
	// 5. Fill the area headers

};

area_list::~area_list()
{
	if (actLetterList)
		delete actLetterList;
	for (int c = 1; c <= no; c++)
		delete areaHeader[c];
	delete areaHeader;
};

const char *area_list::getShortName()
{
	return areaHeader[current]->getShortName();
};

const char *area_list::getName()
{
	return areaHeader[current]->getName();
};

const char *area_list::getName(int area)
{
	if ((area < 1) || (area > no))
		fatalError("\n Internal error in getName\n");
	return areaHeader[area]->getName();
};

// This routine is ugly... find a better way to do it:

const char *area_list::getXName(int area)
{
	for (int c = 2; c <= no; c++)
		if ((atoi(areaHeader[c]->getShortName()) == area) &&	//ick!
		     strcmp(areaHeader[c]->getShortName(), "PERS"))
			return areaHeader[c]->getName();
	return NULL;		// if no match found

};

const int area_list::getXNum(int area)
{
	for (int c = 2; c <= no; c++)
		if ((atoi(areaHeader[c]->getShortName()) == area) &&	//ick!
		     strcmp(areaHeader[c]->getShortName(), "PERS"))
			return areaHeader[c]->getNum();
	return 0;		// if no match found

}

const char *area_list::getDescription()
{
	return areaHeader[current]->getDescription();
}

const char *area_list::getDescription(int area)
{
        if ((area < 1) || (area > no))
                fatalError("\n Internal error in getDescription\n");
        return areaHeader[area]->getDescription();
};

const int area_list::getNoOfLetters()
{
	return areaHeader[current]->getNoOfLetters();
};

const int area_list::getNoOfUnread()
{
	return areaHeader[current]->getNoOfUnread();
};

const int area_list::getNoOfPersonal()
{
	return areaHeader[current]->getNoOfPersonal();
};

const enum areatype area_list::getType()
{
	return areaHeader[current]->getType();
};

letter_list *area_list::getLetterList()
{
	if (actLetterList)
		delete actLetterList;

	actLetterList = new letter_list(mm, current);

	return actLetterList;
};

int area_list::noOfAreas()
{
	return no;
};

int area_list::gotoArea(int currentA)
{
	if ((currentA <= 0) || (currentA > no))
		return -1;
	current = currentA;
	return 0;
};

int area_list::getAreaNo()
{
	//if (current != areaHeader[current]->getNum())
	//	cerr << " areaHeader.getnum consistency failure, vagymi";
	return current;
};

int area_list::getID()
{
	return areaHeader[current]->getID();
};

char *area_list::getOperatorName()
{
	//!!
	return (char *) mm->resourceObject->get(bwSysOpName);
};

char *area_list::getProviderName()
{
	return (char *) mm->resourceObject->get(bwBBSName);
};

void area_list::enterLetter(int areaNo, char *from, char *to, char *subject,
			int replyTo, int privat, net_address *netAddress,
			char *filename)
{
	net_address dummy_address;
	dummy_address.zone = 0;
	letter_header *newLetter;
	reply_driver *replyDriver;

	if (netAddress)
		((reply_driver *) mm->driverList->getDriver(1))->
		    enterNetDest(*netAddress);
	else
		((reply_driver *) mm->driverList->getDriver(1))->
		    enterNetDest(dummy_address);

	mm->areaList->gotoArea(areaNo);
	mm->resourceObject->set(bwEchoTag, mm->areaList->getName());

	replyDriver = mm->driverList->getReplyDriver(areaNo);

	newLetter = new letter_header(mm, subject, to, from, "", replyTo,
				      0, 0, areaNo, 1, 0, privat, 0, 0,
			       atoi(areaHeader[current]->getShortName()),
				      0, replyDriver);	// it ain't pretty

	// atoi(.. is a kludge to pass the QWK area num in OriginalID.
	// This is ugly... needs a major rewrite.

	replyDriver->enterLetter(newLetter, filename);

	refreshArea(1);
};

void area_list::killLetter(int letterNo)
{
	//!!
	((reply_driver *) (mm->driverList->getDriver(1)))->killLetter(letterNo);
	refreshArea(1);
};

void area_list::makeReply(int areaNo)
{
	if (areaNo != 1)
		fatalError("\ncannot make reply packet from: \n\n");
	((reply_driver *) (mm->driverList->getDriver(areaNo)))->makeReply();
};

void area_list::refreshArea(int areaNo)
{
	if (areaNo != 1)	//!!
		fatalError(" refresharea: can't refresh this");;
	delete areaHeader[areaNo];

	areaHeader[areaNo] =
	    ((reply_driver *) mm->driverList->getDriver(areaNo))->
	    refreshArea();
	if (current == 1)
		actLetterList->rrefresh();
}

int area_list::getUseAlias()
{
	return areaHeader[current]->getUseAlias();
};
