/*
 * MultiMail offline mail reader
 * 

 Written by Kolossvary Tamas <thomas@vma.bme.hu>
 Modified by John Zero <john@graphisoft.hu>,
             William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "interface.h"
#include "mysystem.h"

void Welcome::ReDraw()
{
	touchwin(window);
	wnoutrefresh(window);
}

void Welcome::MakeActive(void)
{
	window = makeWindow(7, 58, 2, COLS / 2 - 29, COLOR_PAIR(9) | A_BOLD);
	mvwaddstr(window, 1, 8, "Welcome to " MM_NAME " Blue Wave/QWK reader!");
	wattrset(window, COLOR_PAIR(10) | A_BOLD);
	mvwaddstr(window, 3, 2,
		"maintained by:    William McBrine <wmcbrine@clark.net>");
	mvwaddstr(window, 4, 2,
		"original authors: Kolossvary Tamas, Toth Istvan, and");
	mvwaddstr(window, 5, 20, "John Zero");
	wnoutrefresh(window);
}

void Welcome::Delete(void)
{
	delwin(window);
	touchwin(screen);
	wnoutrefresh(screen);
}
