/*
 * MultiMail offline mail reader
 * 

 Written by Kolossvary Tamas <thomas@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <ctype.h>
#include <unistd.h>

#include "interface.h"
#include "mysystem.h"

extern mmail		mm;
extern packet_list	*packetList;
extern HelpWindow	helpwindow;

PacketListWindow::PacketListWindow(void)
{
	packetList = mm.getPacketList();
}

void PacketListWindow::PrintCurrentMode(void)
{
	char buf[100];

	wattrset(list, C_PMODESTAT);
	switch (mm.resourceObject->getValue(packMode)) {
	case PM_QWK:
		strcpy(buf, "(QWK)      ");
		break;
	case PM_BW:
		strcpy(buf, "(Blue Wave)");
		break;
	case PM_UNDEF:
		strcpy(buf, "(Unknown)  ");
	}
	mvwaddstr(list, 1, 10, buf);
}

void PacketListWindow::MakeActive(void)
{
	list_max_y = LINES - 18;
	list = makeWindow(LINES - 16, 60, 10, COLS / 2 - 30, C_PBBACK);
	wattrset(list, C_PHEADTEXT);
	mvwaddstr(list, 1, 3, "Packet                Size    Date");
	PrintCurrentMode();
	helpwindow.packetlist();
	Draw();
#ifdef SOUND_EFFECTS
	mysystem("zcat /var/lib/mmail/select.packet.au.gz >/dev/audio &");
#endif
}

void PacketListWindow::switchMode(void)
{
	int cmod;

	cmod = !(mm.resourceObject->getValue(packMode));
	mm.resourceObject->setValue(packMode, cmod);
	PrintCurrentMode();
	wnoutrefresh(list);
}

int PacketListWindow::NumOfItems(void)
{
	return packetList->getNoOfPackets();
}

void PacketListWindow::Delete(void)
{
	delwin(list);
	helpwindow.Delete();
	touchwin(screen);
	wnoutrefresh(screen);
}

void PacketListWindow::Draw(void)
{
	int i, j;
	char tmp1[13], tmp2[13], tmpdate[30];
	time_t tmpt;

	if (NumOfItems()) {
		for (i = 1; i < list_max_y; i++) {
			packetList->gotoPacket(position + i);

			strcpy(tmp1, "            ");
			strcpy(tmp2, packetList->getName());
			j = 0;
			while ((tmp2[j] != '.') && (j < 8))
				tmp1[j] = tmp2[j++];
			strncpy(&tmp1[8], &tmp2[j], 4);

			// Set packet mode automatically
			if (position + i - 1 == active) {
				switch (toupper(tmp1[9])) {
				case 'Q':
					mm.resourceObject->setValue(
						packMode, PM_QWK);
					break;
				case 'S': case 'M': case 'T': case 'W':
				case 'F': case '0': case '1': case '2':
				case '3': case '4': case '5': case '6':
				case '7': case '8': case '9':
					mm.resourceObject->setValue(
						packMode, PM_BW);
					break;
				default:
					mm.resourceObject->setValue(
						packMode, PM_UNDEF);
				}
				PrintCurrentMode();
			}

			wattrset(list, C_PLINES);
			if (position + i - 1 == active)
				wstandout(list);
			mvwprintw(list, i + 1, 1, "  %s", tmp1);
			//mvwprintw(list, i+1, 15, "       %5d",
			//	packetList->getNoOfLetters());
			//mvwprintw(list, i+1, 27, "       %5d",
			//	packetList->getNoOfPersonal());
			//mvwprintw(list, i+1, 41, "       %5d      ",
			//	packetList->getNoOfUnread());

			mvwprintw(list, i+1, 15, "%16u",
				(unsigned) packetList->getSize());

			tmpt = packetList->getDate();
			strcpy(tmpdate, ctime(&tmpt));
			tmpdate[strlen(tmpdate) - 1] = '\0';
			mvwprintw(list, i + 1, 31, "  %s  ",
				tmpdate);

			if ((position + i) == NumOfItems())
				i = list_max_y;
		}
		packetList->gotoPacket(active + 1);
	} else {
		wattrset(list, C_PLINES);
		mvwaddstr(list, 3, 12, "It seems we don't have packets.");
		wrefresh(list);
		sleep(2);
		ungetch('Y');
		ungetch('Q');
	}
	wnoutrefresh(list);
}

void PacketListWindow::ReList(void)
{
	if (position > 1) {
		if (active > 1)
			active--;
		position--;
	}
	packetList = mm.getPacketList();
	Draw();
}
