/*
 * MultiMail offline mail reader
 *

 Written by John Zero <john@graphisoft.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "interface.h"

/* All color initialization should be done here, to avoid conflicts
   and redefinitions.

   I may replace everything below with a simple 8x8 color table (all
   possible combinations). In that case, I'll expand the #defines in
   mmcolor.h, and use them exclusively throughout the rest of the
   program. - WJM3 */

struct c_tab {
	int id;
	char *desc;
	int fg, bg;
};

struct c_tab coltab[] =
{
	{0, "no color", 0, 0},
	{1, "Start screen/background", COLOR_WHITE, COLOR_BLACK},
	{2, "Start screen/border", COLOR_BLUE, COLOR_BLACK},
	{3, "Start screen/bottom sep. line", COLOR_MAGENTA, COLOR_BLACK},
	{14, "Address book/background", COLOR_WHITE, COLOR_GREEN},
	{13, "Address book/headers", COLOR_GREEN, COLOR_GREEN},
	{6, "Address book/text", COLOR_RED, COLOR_GREEN},
	{15, "Tagline/error2", COLOR_RED, COLOR_YELLOW},
	{59, "Warning/text", COLOR_WHITE, COLOR_RED},
	{60, "Warning/hilightext", COLOR_YELLOW, COLOR_RED},
	{32, "Letter/border?", COLOR_BLUE, COLOR_BLACK},
	{34, "Letter/bottom statline", COLOR_MAGENTA, COLOR_WHITE},
	{36, "Letter/text", COLOR_WHITE, COLOR_BLUE},
	{33, "Letter/quoted text", COLOR_WHITE, COLOR_BLUE},
	{37, "Letter/tagline", COLOR_CYAN, COLOR_BLUE},
	{35, "Letter/tearline", COLOR_BLUE, COLOR_BLUE},
	{38, "Letter/origin line", COLOR_BLUE, COLOR_BLUE},
	{39, "Letter/header text", COLOR_BLUE, COLOR_CYAN},
	{40, "Letter/header msgnum", COLOR_WHITE, COLOR_CYAN},
	{41, "Letter/header from", COLOR_GREEN, COLOR_CYAN},
	{42, "Letter/header to", COLOR_WHITE, COLOR_CYAN},
	{43, "Letter/header subject", COLOR_BLUE, COLOR_CYAN},
	{44, "Letter/header date", COLOR_WHITE, COLOR_CYAN},
	{45, "Letter/header border", COLOR_BLUE, COLOR_CYAN},
	{46, "Letter/header flags", COLOR_WHITE, COLOR_CYAN},
	{47, "Letter/header flags highlited", COLOR_YELLOW, COLOR_CYAN},
	{48, "General MM top line", COLOR_MAGENTA, COLOR_YELLOW},
	{49, "Packet/header border+background", COLOR_YELLOW, COLOR_BLUE},
	{50, "Packet/header bw/qwk mode disp.", COLOR_RED, COLOR_BLUE},
	{51, "Packet/header line text", COLOR_GREEN, COLOR_BLUE},
	{52, "Packet/lines", COLOR_CYAN, COLOR_BLUE},
	{53, "Little area list/border+backg.+text", COLOR_WHITE, COLOR_BLUE},
	{54, "Little area list/line text", COLOR_WHITE, COLOR_BLUE},
	{55, "Area list/reply area line", COLOR_YELLOW, COLOR_BLUE},
	{56, "Area list/packet area line", COLOR_CYAN, COLOR_BLUE},
	{57, "Area list/info win. text", COLOR_YELLOW, COLOR_BLUE},
	{58, "Area list/info win. filled text", COLOR_WHITE, COLOR_BLUE},
	{61, "Area list/border texts", COLOR_GREEN, COLOR_BLUE},
	{62, "Area list/border+background", COLOR_YELLOW, COLOR_BLUE},
	{63, "Area list/top header text", COLOR_MAGENTA, COLOR_BLUE},
	{32, "Letter/enter bord+backg.+text", COLOR_WHITE, COLOR_BLUE},
	{31, "Letter/enter get1", COLOR_CYAN, COLOR_BLUE},
	{30, "Letter/enter get2", COLOR_GREEN, COLOR_BLUE},
	{29, "Letter list+Letter/save box+text+get/2", COLOR_WHITE, COLOR_RED},
	{28, "Letter list+Letter/save get", COLOR_YELLOW, COLOR_RED},
	{27, "Letter list/back+border", COLOR_YELLOW, COLOR_BLUE},
	{26, "Letter list/top text1", COLOR_WHITE, COLOR_BLUE},
	{25, "Letter list/top text2 (areaname)", COLOR_GREEN, COLOR_BLUE},
	{24, "Letter list/headers", COLOR_YELLOW, COLOR_BLUE},
	{23, "Letter list/lines", COLOR_WHITE, COLOR_BLUE},
	{22, "Tagline/border+bg?", COLOR_YELLOW, COLOR_YELLOW},
	{21, "Tagline/text", COLOR_WHITE, COLOR_YELLOW},
	{20, "Tagline/key select text", COLOR_GREEN, COLOR_YELLOW},
	{19, "Tagline/enter text", COLOR_GREEN, COLOR_YELLOW},
	{18, "Tagline/enter get", COLOR_MAGENTA, COLOR_YELLOW},
	{17, "Tagline/lines", COLOR_MAGENTA, COLOR_YELLOW},
	{16, "Tagline/error1", COLOR_BLUE, COLOR_YELLOW},
	{4, "Help keys", COLOR_YELLOW, COLOR_BLACK},
	{5, "Help descriptions", COLOR_WHITE, COLOR_BLACK},
	{7, "Help 2 border", COLOR_WHITE, COLOR_BLUE},
	{8, "Help 2 text", COLOR_YELLOW, COLOR_BLUE},
	{9, "Welcome border", COLOR_YELLOW, COLOR_BLUE},
	{10, "Welcome names", COLOR_CYAN, COLOR_BLUE},
/*      {,"",COLOR_,COLOR_},
	{,"",COLOR_,COLOR_},
	{,"",COLOR_,COLOR_},
*/
	{0, NULL, 0, 0}		// Terminator rec.
};

void init_colors(void)
{
	int c;

	for (c = 1; coltab[c].desc; c++)
		init_pair(coltab[c].id, coltab[c].fg, coltab[c].bg);
}
