/*
 * MultiMail offline mail reader
 * 

 Written by Kolossvary Tamas <thomas@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <ctype.h>

#include "interface.h"
#include "mysystem.h"

mmail			mm;
packet_list		*packetList;
letter_list		*letterList;
Welcome			welcome;
PacketListWindow	packets;
AreaListWindow		areas;
LetterListWindow	letters;
LetterWindow		letterwindow;
HelpWindow		helpwindow;
Interface		*interface;
LittleAreaListWindow	*littleareas;
AddressBook		addresses;
int			getstring(WINDOW *, int, int, char *, int, int, int);
int			isoconvert;

WINDOW *screen;

void screen_init(int mode)	//mode = 1 ->background, mode = 0 ->no bkgd
{
	typedef int line[24];
	typedef line pattern[5];

	initscr();
	start_color();
	init_colors();
	cbreak();
	noecho();
	screen = newwin(0, 0, 0, 0);
	leaveok(screen, TRUE);
	keypad(screen, TRUE);
	wattrset(screen, C_SBACK);	//COLOR_PAIR(50));

	if (mode)
		for (int i = 0; i < COLS * (LINES - 5); i++)
			waddch(screen, ACS_BOARD);
	// wbkgdset(screen, C_SBACK | ACS_BOARD);
	// werase(screen);
	wattrset(screen, C_SBORDER | A_BOLD);
	box(screen, 0, 0);
	mvwaddch(screen, 0, 2, ACS_RTEE);
	wattrset(screen, C_SBACK | A_BOLD);
	wprintw(screen, MM_TOPHEADER, MM_NAME, MM_MAJOR, MM_MINOR);
	wattrset(screen, C_SBORDER | A_BOLD);
	waddch(screen, ACS_LTEE);
	wattrset(screen, C_SSEPBOTT);
	wmove(screen, LINES - 5, 1);
	whline(screen, ACS_HLINE, COLS - 2);

	wnoutrefresh(screen);
}

void mvwaddchar(WINDOW *window, int y, int x, char c)
{
	char tmp[2];

	tmp[0] = c;
	tmp[1] = '\0';
	mvwaddstr(window, y, x, tmp);
}

WINDOW *makeWindow(int y1, int x1, int y2, int x2, chtype backg)
{
	WINDOW *winptr;

	winptr = newwin(y1, x1, y2, x2);
	if (winptr) {
		wbkgdset(winptr, backg);
		werase(winptr);
		wbkgdset(winptr, 0);
		wattrset(winptr, backg);
		box(winptr, 0, 0);
	}
	return winptr;
}

int getstring(WINDOW *window, int y, int x, char *string, int n,
	      int bg_color, int fg_color)
{
	int i;
	int c = 0;
	char *tmp, *tmp2;

	tmp = new char[n];
	tmp2 = new char[n];

	while (string[strlen(string) - 1] == ' ')
		string[strlen(string) - 1] = '\0';

	strcpy(tmp2, string);
	wattrset(window, fg_color);
	for (i = 0; i < n; i++) {
		mvwaddch(window, y, x + i, ACS_BOARD);
		tmp[i] = '\0';
		string[i] = '\0';
	}
	strcpy(string, tmp2);
	mvwaddstr(window, y, x, string);
	leaveok(window, FALSE);
	keypad(window, TRUE);
	nodelay(window, FALSE);
	wrefresh(window);	//to have cursor

	i = 0;
	int escd = 0;
	while ((c != '\n') && (!escd) && (c != ERR)) {
		int j;

		c = wgetch(window);
		switch (c) {
		case ERR:
			break;
		case '\n':
			break;
		case '\033':
			escd = 1;
			break;
		case KEY_LEFT:
			if (tmp[0] == '\0') {
				strcpy(tmp, string);
				i = strlen(string) + 1;
				i--;
			}
			if (i > 0)
				i--;
			break;
		case KEY_RIGHT:
			if ((i < n - 1) && (tmp[i] != '\0'))
				i++;
			break;
		case KEY_DC:	// Delete key 
			strncpy(&tmp[i], &tmp[i + 1], n - i - 1);
			tmp[n - 1] = '\0';
			break;
		case 8:	// Ctrl-H
		case KEY_BACKSPACE:
			if (i > 0) {
				strncpy(&tmp[i - 1], &tmp[i], n - i - 1);
				tmp[n - 1] = '\0';
				i--;
			}
			break;
		case 127:
			if (i >= 0) {
				if (i > 0)
					i--;
				strncpy(&tmp[i], &tmp[i + 1], n - i - 1);
				tmp[n - 1] = '\0';
			}
			break;
		default:
			for (j = n - 1; j > i; j--)
				tmp[j] = tmp[j - 1];
			tmp[i] = c;
			if (i < n - 1)
				i++;
		}
		if (c != ERR) {
			for (j = 0; j < n; j++)
				if (tmp[j])
					mvwaddchar(window, y, x + j, tmp[j]);
				else
					mvwaddch(window, y, x + j, ACS_BOARD);
			wmove(window, y, x + i);
			wrefresh(window);
		}
	}
	if (c != ERR) {
		if (tmp[0])
			strcpy(string, tmp);
		wattrset(window, bg_color);
		for (i = 0; i < n; i++)
			if (string[i])
				mvwaddchar(window, y, x + i, string[i]);
			else
				mvwaddch(window, y, x + i, ' ');
		wmove(window, y, x + i);
		wrefresh(window);
	}
	leaveok(window, TRUE);

	delete tmp2;
	delete tmp;

	if ((c == ERR) || escd)
		return 0;
	else
		return 1;
}

char *charconv_in(char *buf)
{
	if (isoconvert)
		return charconv(buf, CC_437TOISO);
	else
		return buf;
}

char *charconv_out(char *buf)
{
	if (isoconvert)
		return charconv(buf, CC_ISOTO437);
	else
		return buf;
}

int WarningWindow(char *warning, char *yes, char *no)
{
	WINDOW *warnwin;
	int x, c;
	int def_val = 1;	//possible values: 1 or 0

	int result = 0;

	x = strlen(warning) + 4;
	warnwin = makeWindow(7, x, LINES / 2 - 4, (COLS - x) / 2, C_WTEXT
		| A_BOLD);
	keypad(warnwin, TRUE);
	mvwaddstr(warnwin, 2, 2, warning);
	mvwprintw(warnwin, 4, x / 3 - 1, "  %s ", &yes[1]);
	mvwprintw(warnwin, 4, 2 * x / 3 - strlen(no) - 1, "  %s ", &no[1]);
	wattrset(warnwin, C_WTEXTHI | A_BOLD);
	mvwaddch(warnwin, 4, x / 3, yes[0]);
	mvwaddch(warnwin, 4, 2 * x / 3 - strlen(no), no[0]);

	while (!result) {
		mvwaddch(warnwin, 4, x / 3 - 1, def_val ? '[' : ' ');
		mvwaddch(warnwin, 4, x / 3 + strlen(yes), def_val ? ']' : ' ');
		mvwaddch(warnwin, 4, 2 * x / 3 - strlen(no) - 1, def_val
			? ' ' : '[');
		mvwaddch(warnwin, 4, 2 * x / 3, def_val ? ' ' : ']');
		wrefresh(warnwin);

		c = wgetch(warnwin);
		if ((c == tolower(yes[0])) || (c == toupper(yes[0]))) {
			def_val = 1;
			result = 1;
		} else if ((c == tolower(no[0])) || (c == toupper(no[0]))) {
			def_val = 0;
			result = 1;
		} else
			switch (c) {
			case KEY_LEFT:
			case KEY_RIGHT:
			case 9:
				def_val = !def_val;
				break;
			case '\n':
				result = 1;
			}
	}
	delwin(warnwin);
	return def_val;
}

int parsecommand(int argc, char *argv[])  // returns color(1)/mono(0) setting
{
	int c;
	char *p;
	int col = 1;

	mm.resourceObject->setValue(packMode, PM_UNDEF);
	for (c = 1; c < argc; c++) {
		p = argv[c];
		if (*p == '-')
			p++;
		switch (*p) {
		case 'm':
			col = 0;
		}
	}
	return col;
}

int main(int argc, char *argv[])
{
	int end = 0;
	int c, col;

	isoconvert = 1;
	col = parsecommand(argc, argv);
	interface = new Interface(col);

	while (!end) {
		c = wgetch(screen);
		switch (c) {
		case 'q':
		case 'Q':
		case '\033':	//the escape key

		case KEY_BACKSPACE:
			end = interface->back();
			break;
		case '\n':
			interface->select();
			break;
		case '/':
			interface->search();
			break;
		case KEY_DOWN:
			interface->ikeypad(DOWN);
			break;
		case KEY_UP:
			interface->ikeypad(UP);
			break;
		case KEY_HOME:
			interface->ikeypad(HOME);
			break;
		case KEY_END:
			interface->ikeypad(END);
			break;
		case 'b':
		case 'B':
		case KEY_PPAGE:
			interface->ikeypad(PGUP);
			break;
		case 'f':
		case 'F':
		case KEY_NPAGE:
			interface->ikeypad(PGDN);
			break;
		case '+':
		case KEY_RIGHT:
			interface->RIGHT_ARROW();
			break;
		case '-':
		case KEY_LEFT:
			interface->LEFT_ARROW();
			break;
		case '?':
		case KEY_F(1):
			interface->help();
			break;
		case 's':
		case 'S':
			interface->save();
			break;
		case 'k':
		case 'K':
			interface->kill();
			break;
		case 'a':
		case 'A':
			interface->addressbook();
			break;
		case KEY_F(2):
			interface->ReplyPacket();
			break;
		case 'c':
		case 'C':
			isoconvert = !isoconvert;
			interface->redraw();
			break;
		default:
			interface->enterletter(toupper(c));
		}
		if (!end)
			doupdate();
	}

	delwin(screen);
	touchwin(stdscr);
	refresh();
	leaveok(screen, FALSE);
	echo();
	endwin();
	return 0;
}
