/*
 * MultiMail offline mail reader
 * 

 Written by Kolossvary Tamas <thomas@tvnet.hu>
 Modified by John Zero <john@graphisoft.hu>,
             William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef INTERFACE_H
#define INTERFACE_H

#define REPLY_AREA 1

//#define SOUND_EFFECTS

#include <stdio.h>
#include <string.h>

#include CURS_INC

#include "mmcolor.h"
#include "tagline.h"
#include "../mmail/mmail.h"

enum direction { UP, DOWN, PGUP, PGDN, HOME, END };
enum statetype { packetlist, arealist, threadlist, letterlist, letter, 
		 letter_help, littlearealist};
extern int WarningWindow(char *, char *, char *);
extern void screen_init(int);
extern WINDOW *makeWindow(int y1, int x1, int y2, int x2, chtype backg);

extern char *charconv_in( char *buf );
extern char *charconv_out( char *buf );

extern int isoconvert;	// ISO8859-1 <--> CP437 (DOS) conversion?

class ListWindow
{
 public:
 	ListWindow();
 	virtual void MakeActive(void){};
	virtual void Delete(void){};	
	virtual	void Draw(void){};	//refreshes the window
	virtual void ReDraw(void);	//apply touchwin on the windoz
	void Move(direction);	//scrolloz
 protected:
  	int	list_max_y;
	int	list_max_x;
	virtual int	NumOfItems(void){return 0;};
	WINDOW 	*list;
	int	position;	//the first element in the window
	int	active;		//this is the highlited	
};

class Interface
{
 public:
 	Interface(int);
	void init(void);
 	void select(void);
 	int back(void);  //returns 1 if we have to quit the program
	void RIGHT_ARROW(void);
 	void LEFT_ARROW(void);
	void ikeypad(direction dir); //handle various keypad keys
	void redraw(void);
	void help(void);
 	void search(void);
	void ANY_KEY(void);
	void enterletter(char);
	void save(void);
	void kill(void);
	void reedit(void);
	void change_prop(void);
	void addressbook(void);
	void ReplyPacket(void);  	//warns & call create_reply_packet
	void create_reply_packet();	//do the job
	statetype active(void);
	void set_dontcallEnterLetter(void);
 private:
 	statetype 	state;	
	int		unsaved_reply;
	int		any_read;
	int		dontcallEnterLetter; 
	char		Key;
	void		kill_letter(void);
	void		kill_packet(void);
};

class Welcome
{
 public:
 	void MakeActive(void);
 	void Delete(void);
	void ReDraw(void);
 private:
 	WINDOW *window;
};

class Person
{
 public:
	Person(void);
 	char 		name[30];
 	net_address 	netmail_addr;
 	Person		*next;
};

class AddressBook : public ListWindow
{
 public:
	AddressBook(void);
	void MakeActive(int NOENTER = 0);
 private:
	void AddressFromLetter(void);
	void Draw(void);
  	int NumOfItems(void);
 	void ReadFile(void);
 	void DestroyChain(void);
 	void SetLetterThings(void);

	Person 	head;
	Person	*curr;
	int	NumOfPersons;
	Person  *highlighted;
};

class TaglineWindow : public ListWindow
{
 public:
 	TaglineWindow( int no_draw = 0 );
 	virtual ~TaglineWindow(void);
 	int EnterTagline( char *tag = NULL );
 private:
	void ReadFile(void);
	void DestroyChain(void);
 	void Draw(void);	
	void RandomTagline(void);
 	int NumOfItems(void);
  	char *getTextOf(int); 
  	int nodraw;	

  	int NumOfTaglines;
	tagline head;
};

class LittleAreaListWindow : public ListWindow
{
 public:
 	LittleAreaListWindow(char);
 	virtual ~LittleAreaListWindow(void);
 	void Draw(void);
	int NumOfItems(void);
 private:
 	char key;
};

class AreaListWindow : public ListWindow
{
 public:
 	void MakeActive(void); 
 	void Delete(void);
 	void Draw(void);
	void ReDraw();
	void FirstUnread();
 	int NumOfItems(void);
 	void Reset_areaList(void);
 private:
 	WINDOW 	*info;
};

class PacketListWindow : public ListWindow
{
 public:
	PacketListWindow(void);
 	void MakeActive(void);
 	void Delete(void);
 	void Draw(void);
	void ReList(void);
	void switchMode(void); // QWK/BW mode switch
	int NumOfItems(void);
 private:
	void PrintCurrentMode(void);
};

class LetterListWindow : public ListWindow
{
 public:
 	LetterListWindow(void);
	void MakeActive(void);
	void Delete(void);
	void Draw(void);
	void Save(void);
	void FirstUnread(void);
	void NextUnread(void);
	void PrevUnread(void);
	void SetCurrent(void);
	int NumOfItems(void);
};

class Line
{
 public:
 	Line(void);	
	char *text;
	Line *next;
};

class LetterWindow
{
 public:
 	void MakeActive(void);
 	void Delete(void);
 	void Draw(void);
 	void DrawHeader(void);
 	void DrawBody(void);
	void ReDraw(void);
	void Next(void);
	void Previous(void);
	void Move(direction);
	void NextDown(void);
	void Save(void);
	void EnterLetter(void);
	void MarkToggle(void);
	void ReadToggle(void);
	void MakeChain(void);
	net_address PickNetAddr(void);
	void DestroyChain(void);
	void write_to_file(FILE *, int NEED_HEADER = 1);
	void ansi_dump(void);
	void set_Letter_Params(int, char);
	void set_Letter_Params(net_address *, char[30]);
	void set_Tagline(char *);	
	void set_columns(int);
	
	int GetTagline(void);
	void EditBody(void);
 private:	
 	WINDOW	*header;
 	WINDOW	*text;
 	Line 	head;
 	Line	*curr;
 	int 	letter_in_chain; //0 = no letter in chain
	int	position; //which row is the first in the text window
	int	NumOfLines;
	int	dont_inc_pos;
	int	x, y; //dimensions of the window, set by MakeActive
	int 	replyto_area;
	char 	key;
	int	columns;
	char 	tagline[82];
	net_address NM;
	char	To[30];
};

class HelpWindow
{
 public:
	HelpWindow(void);
	void packetlist(void);
 	void arealist(void);
 	void threadlist(void);
 	void letterlist(void);
 	void reply_area_letterlist(void);
 	void letter(void);
 	void reply_area_letter(void);
 	void Delete(void);
 	void redraw(void);
 private:
 	WINDOW 	*menu;
	int 	active;
};

extern WINDOW *screen; 

#endif
