/*
 * MultiMail offline mail reader
 * 

 Written by Kolossvary Tamas <thomas@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "interface.h"

extern mmail		mm;
extern AreaListWindow	areas;


HelpWindow::HelpWindow(void)
{
	active = 0;
}

void HelpWindow::redraw(void)
{
	if (active) {
		touchwin(menu);
		wnoutrefresh(menu);
	}
}

void HelpWindow::packetlist(void)
{
	menu = newwin(3, COLS - 4, LINES - 4, 2);
	wattrset(menu, COLOR_PAIR(4) | A_BOLD);
	mvwaddstr(menu, 0, 0, "Q");
	mvwaddstr(menu, 0, 22, "Enter");
	mvwaddstr(menu, 0, 53, "A");
	mvwaddstr(menu, 1, 0, "M");
	mvwaddstr(menu, 1, 19, "Space, F");
	mvwaddstr(menu, 1, 53, "B");
	mvwaddstr(menu, 2, 0, "K");
	mvwaddstr(menu, 2, 26, "+");
	mvwaddstr(menu, 2, 53, "-");
	wattrset(menu, COLOR_PAIR(5) | A_BOLD);
	mvwaddstr(menu, 0, 1, ": Quit");
	mvwaddstr(menu, 0, 27, ": Select packet");
	mvwaddstr(menu, 0, 54, ": Addressbook");
	mvwaddstr(menu, 1, 1, ": QWK/BW mode");
	mvwaddstr(menu, 1, 27, ": aliases for PgDn");
	mvwaddstr(menu, 1, 54, ": alias for PgUp");
	mvwaddstr(menu, 2, 1, ": Kill packet");
	mvwaddstr(menu, 2, 27, ": alias for Right");
	mvwaddstr(menu, 2, 54, ": alias for Left");
	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::arealist(void)
{
	menu = newwin(3, COLS - 4, LINES - 4, 2);
	wattrset(menu, COLOR_PAIR(4) | A_BOLD);
	mvwaddch(menu, 0, 0, 'Q');
	mvwaddstr(menu, 0, 29, "Enter");
	mvwaddch(menu, 0, 57, 'A');
	mvwaddch(menu, 1, 0, 'E');
	mvwaddstr(menu, 1, 29, "Right");
	mvwaddstr(menu, 1, 54, "Left");

	mm.areaList->gotoArea(REPLY_AREA);
	if (mm.areaList->getNoOfLetters() > 0)
		mvwaddstr(menu, 2, 32, "F2");

	wattrset(menu, COLOR_PAIR(5) | A_BOLD);
	mvwaddstr(menu, 0, 1, ": Go to Packet Selection");
	mvwaddstr(menu, 0, 34, ": Select area");
	mvwaddstr(menu, 0, 58, ": Addressbook");
	mvwaddstr(menu, 1, 1, ": Enter letter to area");
	mvwaddstr(menu, 1, 34, ": Next non-empty");
	mvwaddstr(menu, 1, 58, ": Prev non-empty");

	if (mm.areaList->getNoOfLetters() > 0)
		mvwaddstr(menu, 2, 34, ": Make reply packet");
	areas.Reset_areaList();

	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::letterlist(void)
{
	reply_area_letterlist();
	mvwaddstr(menu, 1, 1, ": Enter letter in area");
	mvwaddstr(menu, 1, 50, ": Mark/unmark");
	mvwaddstr(menu, 2, 1, ": Unread/read toggle");
	mvwaddstr(menu, 2, 31, ": Next unread");
	mvwaddstr(menu, 2, 50, ": Previous unread");
	wattrset(menu, COLOR_PAIR(4) | A_BOLD);
	mvwaddch(menu, 1, 0, 'E');
	mvwaddch(menu, 1, 49, 'M');
	mvwaddch(menu, 2, 0, 'U');
	mvwaddstr(menu, 2, 26, "Right");
	mvwaddstr(menu, 2, 46, "Left");
	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::reply_area_letterlist(void)
{
	menu = newwin(3, COLS - 4, LINES - 4, 2);
	wattrset(menu, COLOR_PAIR(4) | A_BOLD);
	mvwaddch(menu, 0, 0, 'Q');
	mvwaddstr(menu, 0, 26, "Enter");
	mvwaddch(menu, 0, 49, 'S');
	mvwaddch(menu, 1, 30, 'A');
	mvwaddch(menu, 1, 0, 'K');
	wattrset(menu, COLOR_PAIR(5) | A_BOLD);
	mvwaddstr(menu, 0, 1, ": Back to arealist");
	mvwaddstr(menu, 0, 31, ": Read letter");
	mvwaddstr(menu, 0, 50, ": Save all letters in area");
	mvwaddstr(menu, 1, 31, ": Addressbook");
	mvwaddstr(menu, 1, 1, ": Kill letter");

	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::letter(void)
{
	menu = makeWindow(19, 50, LINES / 2 - 10, COLS / 2 - 25, COLOR_PAIR(7)
		| A_BOLD);
	wattrset(menu, COLOR_PAIR(8) | A_BOLD);
	mvwaddstr(menu, 1, 2, "S - Save letter");
	mvwaddstr(menu, 2, 2, "R - Reply to letter");
	mvwaddstr(menu, 3, 2, "O - reply to Original sender");
	mvwaddstr(menu, 4, 2, "E - Enter letter");
	mvwaddstr(menu, 5, 2, "N - Netmail reply");
	mvwaddstr(menu, 6, 2, "T - Take tagline");
	mvwaddstr(menu, 7, 2, "A - Addressbook");
	mvwaddstr(menu, 8, 2, "M - Mark/unmark letter");
	mvwaddstr(menu, 9, 2, "U - Unread/read toggle");
	mvwaddstr(menu, 10, 2, "C - toggle Character set translation");
	mvwaddstr(menu, 11, 2, "^A - ANSI viewer");
	mvwaddstr(menu, 12, 2, "Left - Previous letter");
	mvwaddstr(menu, 13, 2, "Right, Enter - Next letter");
	mvwaddstr(menu, 14, 2, "Space - Page through area");
	mvwaddstr(menu, 15, 2, "Q - Go back to index");
	mvwaddstr(menu, 17, 2, "Plus the standard up/down and PgUp/PgDn keys");
	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::reply_area_letter(void)
{
	menu = makeWindow(12, 50, LINES / 2 - 4, COLS / 2 - 25, COLOR_PAIR(7)
		| A_BOLD);
	wattrset(menu, COLOR_PAIR(8) | A_BOLD);
	mvwaddstr(menu, 1, 2, "K - Kill letter");
	mvwaddstr(menu, 2, 2, "E - Edit letter text");
	mvwaddstr(menu, 3, 2, "S - Save letter");
	mvwaddstr(menu, 4, 2, "A - Addressbook");
	mvwaddstr(menu, 5, 2, "Left - Previous letter");
	mvwaddstr(menu, 6, 2, "Right, Enter - Next letter");
	mvwaddstr(menu, 7, 2, "Space - Page through area");
	mvwaddstr(menu, 8, 2, "Q - Go back to index");
	mvwaddstr(menu, 10, 2, "Plus the standard up/down and PgUp/PgDn keys");
	wnoutrefresh(menu);
	active = 1;
}

void HelpWindow::Delete(void)
{
	delwin(menu);
	active = 0;
}
