/*
 * MultiMail offline mail reader
 * 

 Written by Kolossvary Tamas <thomas@vma.bme.hu>
 Modified by William McBrine <wmcbrine@clark.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "interface.h"

extern mmail		mm;
extern packet_list	*packetList;
extern letter_list	*letterList;
extern AreaListWindow	areas;
extern LetterListWindow	letters;
extern LetterWindow	letterwindow;
extern HelpWindow	helpwindow;
extern Interface	interface;
extern AddressBook	addresses;
extern int		getstring(WINDOW *, int, int, char *, int, int, int);

//**************        LittleAreaListWindow    *****************

LittleAreaListWindow::LittleAreaListWindow(char param_key)
{
	key = param_key;
	list_max_y = LINES - 9;
	list = makeWindow(LINES - 6, 25, 2, 30, C_LALBTEXT);
	areas.Reset_areaList();
	if ((mm.resourceObject->getValue(packMode) == PM_QWK) &&
	    !strcmp(mm.areaList->getShortName(), "PERS")) {
		int dest = mm.areaList->
		getXNum(letterList->getOriginalID()) - 2;
		while (active != dest)
			Move(DOWN);
	} else
		while (active != mm.areaList->getAreaNo() - 2)
			Move(DOWN);
	mvwaddstr(list, 1, 2, "Reply goes to area:");
	Draw();
}

LittleAreaListWindow::~LittleAreaListWindow(void)
{
	mm.areaList->gotoArea(active + 2);
	letterwindow.set_Letter_Params(active + 2, key);
	delwin(list);
	letterwindow.ReDraw();
}

void LittleAreaListWindow::Draw(void)
{
	int i;

	for (i = 1; i < list_max_y; i++) {
		mm.areaList->gotoArea(position + i + 1);
		wattrset(list, C_LALLINES);
		if (position + i - 1 == active)
			wstandout(list);
		mvwprintw(list, i + 2, 2, "%-21.21s",
			mm.areaList->getDescription());
		if (position + i == NumOfItems())
			i = list_max_y;
	}
	wnoutrefresh(list);
}

int LittleAreaListWindow::NumOfItems(void)
{
	return mm.areaList->noOfAreas() - 1;	//-1 is the reply area
}

//*************         AreaListWindow          ******************


void AreaListWindow::ReDraw(void)
{
	touchwin(list);
	wnoutrefresh(list);
	touchwin(info);
	wnoutrefresh(info);
}

void AreaListWindow::FirstUnread(void)
{
	int i;

	position = 0;
	active = 0;
	list_max_y = LINES - 14;
	for (i = 0; i < NumOfItems(); i++) {
		mm.areaList->gotoArea(i + 1);
		if (!mm.areaList->getNoOfUnread()) {
			Move(DOWN);
			// These lines make it scroll when rereading
			// a packet. Looks nice, can be very slow.
			//Draw();
			//doupdate();

		} else
			i = NumOfItems();
	}
	Draw();
}

void AreaListWindow::Reset_areaList(void)
{
	mm.areaList->gotoArea(active + 1);
}

int AreaListWindow::NumOfItems(void)
{
	return mm.areaList->noOfAreas();
}

void AreaListWindow::Draw(void)
{
	int i;
	char tmp[21];

	for (i = 1; i < list_max_y; i++) {
		mm.areaList->gotoArea(position + i);
		wattrset(list, (mm.areaList->getType() == bwrep) ?
			 C_ALREPLINE : C_ALPACKETLINE);
		if (mm.areaList->getNoOfUnread() > 0)
			wattron(list, A_BOLD);
		if (position + i - 1 == active)
			wstandout(list);

		mvwprintw(list, i + 1, 1, " %6s ",
			mm.areaList->getShortName());
		mvwprintw(list, i + 1, 9, " %-31.31s",
			mm.areaList->getDescription());
		if (mm.areaList->getNoOfLetters())
			wprintw(list, "  %5d", mm.areaList->getNoOfLetters());
		else
			wprintw(list, "      .");
		if (mm.areaList->getNoOfUnread())
			wprintw(list, "    %5d", mm.areaList->getNoOfUnread());
		else
			wprintw(list, "        .");
		if (mm.resourceObject->getValue(packMode) != PM_QWK)
			if (mm.areaList->getNoOfPersonal())
				wprintw(list, "      %5d    ",
					mm.areaList->getNoOfPersonal());
			else
				wprintw(list, "          .    ");
		else
			wprintw(list, "  ");

		if ((position + i) == NumOfItems())
			i = list_max_y;
	}
	wnoutrefresh(list);

	mm.areaList->gotoArea(active + 1);
	wattrset(info, C_ALINFOTEXT);
	mvwaddstr(info, 1, 2, " BBS:                        Sysop: ");
	mvwaddstr(info, 2, 2, "Type:                       Packet: ");
	mvwaddstr(info, 3, 2, "Area description: ");
	wattrset(info, C_ALINFOTEXT2);
	strncpy(tmp, mm.areaList->getProviderName(), 20);
	tmp[20] = '\0';
	mvwaddstr(info, 1, 8, tmp);
	mvwprintw(info, 1, 38, "%-20s", mm.areaList->getOperatorName());

/* Restore this later -- after adding support for "qwkrep" throughout:

   switch(mm.areaList->getType())
   {
   case bw:
   case bwrep:
   mvwprintw(info, 2, 8, "Bluewave");
   break;
   case qwk:
   mvwprintw(info, 2, 8, "QWK");
   break;
   // not yet!: case qwkrep: break;

   case mail:
   case usenet: break;
   }

   Meanwhile, substitute the following: */

	mvwprintw(info, 2, 8, (mm.resourceObject->getValue(packMode) == PM_QWK)
		? "QWK" : "Bluewave");

	mvwprintw(info, 2, 38, packetList->getName());
	mvwprintw(info, 3, 20, "%-53s", mm.areaList->getDescription());

	touchwin(info);
	wnoutrefresh(info);
}

void AreaListWindow::MakeActive(void)
{
	list_max_y = LINES - 14;
	list = makeWindow(LINES - 12, COLS - 4, 2, 2, C_ALBORDER);
	mvwaddch(list, 0, 2, ACS_RTEE);
	wattrset(list, C_ALBTEXT);
	wprintw(list, "Message Areas (%d)", mm.areaList->noOfAreas());
	wattrset(list, C_ALBORDER);
	waddch(list, ACS_LTEE);

	wattrset(list, C_ALHEADTEXT);
	mvwaddstr(list, 1, 3,
	   "Area#  Description                       Total     Unread");
	if (mm.resourceObject->getValue(packMode) != PM_QWK)
		mvwaddstr(list, 1, 65, "Personal");
	info = newwin(5, COLS - 4, LINES - 11, 2);
	wbkgdset(info, C_ALBTEXT);
	werase(info);
	wbkgdset(info, 0);
	wattrset(info, C_ALBORDER);
	wborder(info, 0, 0, 0, 0, ACS_LTEE, ACS_RTEE, 0, 0);
	wmove(info, 0, 2);
	waddch(info, ACS_RTEE);
	wattrset(info, C_ALBTEXT);
	waddstr(info, "Info On The Specified Area");
	wattrset(info, C_ALBORDER);
	waddch(info, ACS_LTEE);

	Draw();
	helpwindow.arealist();
}

void AreaListWindow::Delete(void)
{
	delwin(list);
	delwin(info);
	helpwindow.Delete();
	touchwin(screen);
	wnoutrefresh(screen);
}
