/*
 * MultiMail offline mail reader
 * 

 Written by Kolossvary Tamas <thomas@vma.bme.hu>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "interface.h"

extern letter_list	*letterList;
extern LetterWindow	letterwindow;
extern Interface	*interface;
extern Welcome		welcome;
extern PacketListWindow	packets;
extern AreaListWindow	areas;
extern LetterListWindow letters;
extern HelpWindow	helpwindow;
extern mmail		mm;

Person::Person(void)
{
	next = NULL;
	netmail_addr.point = 0;
}

AddressBook::AddressBook(void)
{
	NumOfPersons = 0;
}

void AddressBook::MakeActive(int NOENTER)
{
	int end = 0;
	position = 0;
	active = 0;

	list_max_y = LINES - 11;
	list_max_x = COLS - 6;

	list = makeWindow(LINES - 5, COLS - 4, 2, 2, COLOR_PAIR(14) | A_BOLD);

	mvwaddch(list, 0, 2, ACS_RTEE);
	mvwaddch(list, 0, 14, ACS_LTEE);
	mvwaddstr(list, list_max_y + 2, 2, "A, Q");
	if (((interface->active() == letter) ||
	     (interface->active() == littlearealist)) &&
	    (mm.areaList->getType() != bwrep))
		mvwaddch(list, list_max_y + 2, 30, 'L');
	wattrset(list, COLOR_PAIR(13) | A_BOLD);
	mvwaddstr(list, 0, 3, "Addressbook");
	mvwaddstr(list, 1, 2,
		"Name                            Netmail address");
	wmove(list, list_max_y + 1, 1);
	whline(list, ACS_HLINE, list_max_x);
	mvwaddstr(list, list_max_y + 2, 6, ": Leave Addressbook");
	if (((interface->active() == letter) ||
	     (interface->active() == littlearealist)) &&
	    (mm.areaList->getType() != bwrep))
		mvwaddstr(list, list_max_y + 2, 31,
			  ": Pick sender name & NM address from letter");
	// read file
	ReadFile();
	Draw();

	// handle keyboard
	while (!end) {
		switch (wgetch(screen)) {
		case 'q':
		case 'Q':
		case 'a':
		case 'A':
		case '\033':
			end = 1;
			if (!NOENTER)
				interface->set_dontcallEnterLetter();
			break;
		case '\n':
			if (!NOENTER) {
				SetLetterThings();
				end = 1;
			}
			break;

		case KEY_DOWN:
			Move(DOWN);
			Draw();
			break;
		case KEY_RIGHT:
			Move(DOWN);
			Draw();
			break;
		case KEY_UP:
			Move(UP);
			Draw();
			break;
		case KEY_LEFT:
			Move(UP);
			Draw();
			break;
		case KEY_NPAGE:
			Move(PGDN);
			Draw();
			break;
		case KEY_PPAGE:
			Move(PGUP);
			Draw();
			break;
		case KEY_HOME:
			Move(HOME);
			Draw();
			break;
		case KEY_END:
			Move(END);
			Draw();
			break;
		case 'L':
		case 'l':
			if (((interface->active() == letter) ||
			     (interface->active() == littlearealist)) &&
			    (mm.areaList->getType() != bwrep))
				AddressFromLetter();
			break;
		}
	}

	// set NM address if enter pressed
	// call DestroyChain
	DestroyChain();

	// delete window
	delwin(list);
	touchwin(screen);
	wnoutrefresh(screen);
	switch (interface->active()) {
	case packetlist:
		welcome.ReDraw();
		packets.ReDraw();
		break;
	case arealist:
		areas.ReDraw();
		break;
	case letterlist:
		letters.ReDraw();
	case threadlist:
		break;
	case letter:
	case letter_help:
		letterwindow.ReDraw();
	case littlearealist:
		break;
	}
	helpwindow.redraw();
}

void AddressBook::SetLetterThings(void)
{
	letterwindow.set_Letter_Params(&(highlighted->netmail_addr),
				       highlighted->name);
}

void AddressBook::AddressFromLetter(void)
{
	net_address Address;
	FILE *fd;

	Address = letterwindow.PickNetAddr();
	fd = fopen(mm.resourceObject->get(bwAddressBook), "a");
	fprintf(fd, "%s\n%d:%d/%d.%d\n\n", letterList->getFrom(),
		Address.zone,
		Address.net,
		Address.node,
		Address.point);
	fclose(fd);
	ReadFile();
	Draw();
}

void AddressBook::Draw(void)
{
	int i;
	int y, x;

	wattrset(list, COLOR_PAIR(6));
	if (NumOfPersons == 0)
		mvwaddstr(list, 5, 20, "It seems we don't have addressbook.");
	else {
		mvwaddstr(list, 5, 20, "                                   ");
		curr = head.next;
		for (i = 0; i < position; i++)
			curr = curr->next;
		for (i = 1; i < list_max_y; i++) {
			if (position + i - 1 == active) {
				wattron(list, A_REVERSE);
				highlighted = curr;
			} else
				wattroff(list, A_REVERSE);
			mvwprintw(list, i + 1, 1, " %-31s",
				  curr->name);
			if (curr->netmail_addr.point > 0)
				wprintw(list, " %d:%d/%d.%d",
					curr->netmail_addr.zone,
					curr->netmail_addr.net,
					curr->netmail_addr.node,
					curr->netmail_addr.point);
			else
				wprintw(list, " %d:%d/%d",
					curr->netmail_addr.zone,
					curr->netmail_addr.net,
					curr->netmail_addr.node);
			getyx(list, y, x);
			while (x <= list_max_x)
				mvwaddch(list, y, x++, ' ');
			curr = curr->next;
			if (position + i == NumOfPersons)
				i = list_max_y;
		}
	}
	wrefresh(list);
}

int AddressBook::NumOfItems(void)
{
	return NumOfPersons;
}

void AddressBook::ReadFile(void)
{
	FILE *fd;
	int end = 0;
	char name[255];
	char nmaddr[255];
	char other[255];

	if ((fd = fopen(mm.resourceObject->get(bwAddressBook), "r"))) {
		DestroyChain();
		curr = &head;
		while (!end) {
			do
				if (fgets(name, 254, fd) == NULL)
					end = 1;
			while (name[0] == '\n' && !end);
			if (fgets(nmaddr, 254, fd) == NULL)
				end = 1;
			else {
				curr->next = new Person;
				curr = curr->next;
				name[strlen(name) - 1] = '\0';
				name[29] = '\0';
				strcpy(curr->name, name);
				sscanf(nmaddr, "%d:%d/%d.%d",
					&curr->netmail_addr.zone,
					&curr->netmail_addr.net,
					&curr->netmail_addr.node,
					&curr->netmail_addr.point);
				NumOfPersons++;
			}
			do
				if (fgets(other, 254, fd) == NULL)
					end = 1;
			while (other[0] != '\n' && !end);
		}
		fclose(fd);
	}
}

void AddressBook::DestroyChain(void)
{
	Person *tmp;

	curr = head.next;
	while (curr) {
		tmp = curr;
		curr = curr->next;
		delete tmp;
	}
	head.next = NULL;
	NumOfPersons = 0;
}
