{$R-,S-,I-,D-,F+,V-,B-,N-,L+}
Unit Types230;

Interface
Const
  Ver           = '2.304';
  Date          = '12/23/94';
  CopyrightYear = '1994';
  SoftName      = 'Oblivion/2';
  MaxMesLines   = 150;
  NumPrompts    = 171;
  NumNodes      = 15;
  NumLast       = 20;

Type
  Lstr = String[80];
  MStr = String[35];
  SStr = String[15];
  Str8 = String[8];

  FDesAttrType = (Del,Reg,Last,FIDL);

  FDescRec = Record
    Attr : FDesAttrType;
    FDes : String[45];
  End;

  EMessageRec = Record
    T         : Array[1..MaxMesLines] Of LStr;
    Numlines  : Integer;
    SentBy    : Mstr;
    SentTo    : Mstr;
    Anon      : Boolean;
    Title     : Mstr;
    AutoSigOn : Boolean;
  End;

  UserRec = Record
    Handle,
    RealName,
    PhoneNum,
    Address,
    Location,
    Password,
    UserNote     : MStr;
    BirthDay     : Str8;
    Infoforms    : Array[1..5] Of Integer;
    Level,
    Flevel       : Integer;
    LastFiles,
    LastPosts,
    LastCall     : LongInt;
    LastLevel,
    LastFLevel   : Integer;
    OFilePoints  : Integer;
    UpK,
    DnK          : LongInt;
    UDR,
    UDKR         : Byte;
    DnKPerDay,
    DnKToday,
    Uploads,
    Downloads,
    Posts,
    Calls,
    TimeLeft,
    TimeLimit    : Word;
    RegColor,
    PromptColor,
    InputColor,
    InverseColor,
    StatColor,
    BoxColor,
    PCR,
    Unused3,
    Unused4,
    PromptSel,
    MenuSel,
    StatusSel    : Byte;
    Ansi,
    Avatar,
    vt100        : Boolean;
    FlConfig     : Array[1..10] Of Boolean;
    NuvVotesYes,
    NuvVotesNo   : Byte;
    UVotingYes   : Array[1..30] Of Word;
    UVotingNo    : Array[1..30] Of Word;
    ExtraMes     : Integer;
    Reserved     : Array[0..186] Of Word;
    LastRepDate  : LongInt;
    ScrollFL,
    Rip          : Boolean;
    CallsToday,
    NewLevel,
    CSPassChange : Word;
    CurArchiver  : Byte;
    ReDisMes     : Boolean;
    CFlags       : Array[1..26] Of Boolean;
    Unused32     : Set Of Byte;
    AverageUpCPS,
    AverageDnCPS : Word;
    Wanted       : Boolean;
    AutoSig      : Array[1..5] Of LStr;
    UseFSE       : Boolean;
    HeaderType,
    LastMesConf,
    LastFileConf : Byte;
    ReplyReading : Boolean;
    NetMailB     : Word;
    AnsiAbort    : Boolean;
    ExpDate      : LongInt;
    IsMale       : Boolean;
    FirstOn      : LongInt;
    YesNoBars    : Boolean;
    HackAttempts : Word;
    VotingRec    : Array[1..35] Of Byte;
    NUVComments  : Array[1..10] Of LStr;
    TimeBank     : Word;
    PageLen      : Byte;
    DoPause      : Boolean;
    TimeDesT     : Word;
    FilePoints   : LongInt;
    UInfoN       : Array[1..5] Of SStr;
    Flags2       : Array[1..26] Of Boolean;
    Unused       : Array[1..84] Of Byte;
  End;

  MenuOpt = Record
    Acs,
    OptName    : MStr;
    Hidden     : Boolean;
    CKeys      : String[2];
    Keys       : Sstr;
    CString    : MStr;
    PulldownID : Word;
  End;

  MenuInfo = Record
    Name,
    Password     : Mstr;
    FallBack,
    HelpID       : Sstr;
    ACS          : MStr;
    NameInPrompt : MStr;
    MenuTitle    : MStr;
    PulldownFN   : MStr;
  End;

  FileArea = Record
    Name,
    UploadACS,
    DownloadACS,
    ListACS,
    AccessACS,
    Sponsor,
    Password     : MStr;
    AreaFName    : SStr;
    Path         : LStr;
    Reserved1,
    Reserved2,
    Reserved3    : LStr;
    DefSort      : Char;
    FileAreaMult : Byte;
    FreeArea     : Boolean;
    A4,
    A5,
    A6,
    A7           : Byte;
  End;

  FRec = Record
    FileName,
    Password    : SStr;
    SendTo,
    Path,
    Uploader    : MStr;
    WhenUp,
    WhenValid,
    LineSrt     : LongInt;
    FID         : String[45];
    DescLines   : Byte;
    NewF,
    ResumeLater : Boolean;
    FileSize    : LongInt;
    Points      : Integer;
    TimesDLed   : Byte;
    Offline,
    FreeFile    : Boolean;
    Reserved    : Array[1..6] Of Byte;
  End;

  OldFRec = Record
    FileName,
    Password    : SStr;
    SendTo,
    Path,
    Uploader    : MStr;
    WhenUp,
    WhenValid   : LongInt;
    Desc        : Array[1..8] Of String[45];
    NewF,
    ResumeLater : Boolean;
    FileSize    : LongInt;
    Points      : Integer;
    TimesDLed   : Byte;
    Offline,
    FreeFile    : Boolean;
    Reserved    : Array[1..6] Of Byte;
  End;

  ProtoRec=Record
    Key      : Char;
    Desc     : String[30];
    ProgName : String[12];
    Cline    : String[60];
  End;

  BaseRec=Record
    BaseName  : MStr;
    BaseFName : SStr;
    AccessACS,
    PostACS   : MStr;
    AllowAnon : Boolean;
    Sponsor   : MStr;
    OrigDesc  : LStr;
    Node      : SStr;
    NetMail   : Boolean;
    Unused    : Byte;
    ImExDir   : LStr;
    RealNames : Boolean;
    AutoDel   : Word;
    QwkName   : SStr;
    Reserved  : Array[1..3] Of Mstr;
    LastD,
    NewscanID : Word;
    Mandatory,
    AllowPriv : Boolean;
    LastMesID : Word;
  End;

  MesHRec=Record
    LeftBy,
    SentTo,
    Title,
    RealName,
    Comment   : MStr;
    DateP     : LongInt;
    Anonymous,
    Received,
    Tossed,
    Scanned   : Boolean;
    TextLoc   : Integer;
    OZone,
    ONet,
    ONode,
    DZone,
    DNet,
    DNode,
    ID,
    ReplyID   : Word;
    NumRep    : Byte;
    Deleted   : Boolean;
    Private   : Boolean;
    Reserved  : Array[1..6] Of Byte;
  End;

  EMailRec=Record
    LeftBy,
    SentTo,
    Title,
    Comment   : MStr;
    DateP     : LongInt;
    Alloc,
    FileMail,
    Certified,
    FMPurged,
    FMDled,
    Read      : Boolean;
    TextLoc   : Integer;
    FN        : SStr;
    FileDesc  : MStr;
    ETag      : Byte;
    Reserved  : Array[1..6] Of Byte;
  End;

  NoticeRec=Record
    NotType : Byte;
    Seen    : Boolean;
    When    : LongInt;
    ToU,
    Inf1,
    Inf2    : MStr;
  End;

  ConfRec=Record
    Description,
    ACS         : MStr;
    Password    : SStr;
    CPoint      : Byte;
  End;

  GroupRec=Record
    Name        : MStr;
    NumMems     : Byte;
    Creator     : MStr;
    MemsUseOnly : Boolean;
    CreatorOnly : Boolean;
    Members     : Array[1..15] Of MStr;
  End;

  DataRec=Record
    Data     : Array[1..590] Of Char;
    Sent     : Boolean;
    Reserved : Array[1..9] Of Byte;
    Adder    : MStr;
    Anon     : Boolean;
    StorMes  : Integer;
    When     : LongInt;
  End;

  DataAreaRec=Record
    AreaName    : LStr;
    AccessACS,
    AddACS      : MStr;
    ListAnsi,
    ShowAnsi,
    AddAnsi     : SStr;
    Sponsor     : MStr;
    AllowAnon   : Boolean;
    StorMessage : Boolean;
    DataAreaFN  : String[12];
    AutoD       : Word;
    U,
    NumOpts     : Byte;
    Recs        :
      Array[1..15] Of
        Record
          OName   : MStr;
          StrnLen : Byte;
          MciC    : String[2];
        End;
    ImExDir     : LStr;
    NodeNum     : SStr;
    ForceDesc   : Boolean;
    Reserved    : Array[1..102] Of Byte;
  End;

  MenuPrompt = Record
    Name : MStr;
    Data : Array[1..3] Of LStr;
  End;

  TextPrompt = Record
    Desc   : LStr;
    Prompt : LStr;
  End;

  EventType = (UserACS,ErrorLevel,CodeExec,ChatAvailableEvent);

  EventRec = Record
    StartingTime,
    EndingTime    : Word;
    LimitUserTime,
    LockOutput    : Boolean;
    ET            : EventType;
    EL            : Byte;
    UserACS       : MStr;
    NodeNum       : Byte;
    NumCodes      : Byte;
    CodesToExec   : Array[1..15] Of
                      Record
                        Keys    : String[2];
                        CString : MStr;
                      End;
    TurnOn        : Boolean;
  End;

  QuestionRec = Record
    VotingID   : Byte;
    Question   : LStr;
    Mandatory,
    AddAnswers : Boolean;
    AddACS     : MStr;
    NumAnswers : Byte;
    Answers    :
      Array[1..15] Of Record
        Answer   : MStr;
        NumVotes : Integer;
      End;
  End;

  HardCodeRec = Record
    ID          : Sstr;
    StartBlock,
    NumBlock,
    TotBytes    : Word;
  End;

  SetRec = Record
    Name : LStr;
    FN   : Lstr;
  End;

  NodeActivity = (
     InMatrix,LoggingIn,Transferring,InMessageEditor,InMultiChat,
     WaitingforCall,NotAvailableForChat,AvailableForChat
                 );

  NodeStatusRec = Record
     OnlineUser  : MStr;
     Activity    : NodeActivity;
     ChatChannel : Byte;
   End;

   LastCallerRec = Record
     Handle   : MStr;
     BaudRate : Word;
     TimeOn   : LongInt;
   End;

  DailyLogRec = Record
    Day      : SStr;
    Posts    : Word;
    Files    : Word;
    Calls    : Word;
    TimeUsed : Word;
    NewUsers : Word;
  End;

  UserLevelRec = Record
    ULevel     : Integer;
    PCR,
    TimeLimit,
    UDR,
    UDKR,
    DnKPerDay,
    ExpDays,
    NewLevel   : Word;
  End;

  ArchiverType = Record
    ArcID          : Byte;
    ArchiverName   : MStr;
    ArcExtension   : String[3];
    MaxCRCLevel    : Byte;
    CantBeDefault  : Boolean;
    Reserved       : Array[1..9] Of Byte;
    ListPre        : Char;
    UseZipView,
    DoSwap         : Boolean;
    CompressCom,
    ExtractCom,
    ViewCom,
    DelFilesCom,
    TestCom,
    AddCommentCom,
    AddFilesCom    : LStr;
    SigStr         : SStr;
    StartS         : Integer;
  End;

  DeletedListRec = Record
    Handle   : MStr;
    DispFile : String[13];
    MesLoc   : Integer;
    ExpDate  : LongInt;
    ExpType  : (UseDate,Immediate,Never)
  End;

  FileCatalogRec = Record
    FileName : SStr;
    FConf    : Byte;
    FAreaN   : Word;
  End;

  CheckType =
    (CRCCheck,Unzip,RunScan,DateCheck,GetDIZ,DeletedFiles,AddAd,AddComment,
      RunMaintain);

  CheckSet = Set Of CheckType;

Var
  Local,
  Online,
  ForceOff : Boolean;
  Unum     : Word;
  FailFlag : Boolean;
  ExitSave : Pointer;

Implementation

End.