# ---------------------------------------------------------------------------
# Liquid: Fixed!@$!@$!@$
# ---------------------------------------------------------------------------

Uses USER
Uses CFG

# Constants
Var Bar       String    # Big long bar
Var File1     String    # lQ-WEB.DAT
Var File2     String    # lQ-WEB.TMP

# Various string variables =)
var a char
Var Inpt      String
Var ShowLine1 String
Var ShowLine2 String
Var ShowLine3 String
Var ShowLine4 String
Var ShowLine5 String
Var ShowLine6 String
Var Count     Byte
Var NOS       Byte
Var Done      Boolean
Var fpos      longint
Var Entry     LongInt
Var Temp      Integer
Var strInvalid String
Var SavedX    Byte
Var More      Boolean

# Record Variables
Var User  String
Var Title String
Var Page  String
Var Desc1 String
Var Desc2 String
Var Desc3 String

# B E G I N  C O D E

### Show version information
Proc ShowInfo
  Cls
  WriteLn('|CR|05W|13ebpage Lister v1.00 by Liquid')
  WriteLn('|08--|13|05-|CR')
PEnd ShowInfo

### Display Website Info (long)
Proc ShowLine
  Writeln(Showline1+User)
  WriteLn(ShowLine6+Title)
  writeln(ShowLine2+Page)
  writeln(ShowLine3+Desc1)
  writeln(ShowLine4+Desc2)
  WriteLn(ShowLine5+Desc3)
PEnd ShowLine

### Display Website Info (short)
Proc ShortLine
  WriteLn(ShowLine6+Title)
  WriteLn(ShowLine2+Page)
PEnd ShortLine

### More [Yn] Prompt
Proc MoreYN
  SavedX := WhereX
  Write('|05m|13ore? |08[|13Y|05n|08] ')
  Inpt := ReadKey
  If Upper(inpt) = 'N' then
    More := False
  Else
    More := True
  EndIf
  MoveX(SavedX)
  Write('           ')
  MoveX(SavedX)
PEnd MoreYN

### Add website procedure
Proc AddWeb
  If InputNY('|CR|05d|13o you want to add a website|08? ')
    Cls
    WriteLn('|05e|13nter the title now')
    Write('|08: |05')
    Title := Input(70,70,1,'')
    If Title <> ''
      If fExist(file1)
          FOpen(1, Bin, Append, file1)
        Else
          FOpen(1, Bin, Rewrite, file1)
      EndIf
    WriteLn('|05e|13nter the address now')
    Write('|08: |05')
    Page := Input(70, 70, 1, '')
    WriteLn('|05e|13nter the description now. 3 lines max')
    Write('|08: |05')
    Desc1 := Input(70,70,1,'')
    Write('|08: |05')
    Desc2 := Input(70,70,1,'')
    EndIf
    Write('|08: |05')
    Desc3 := Input(70,70,1,'')
      ### Write the Webpage to file
      user := lower(useralias)
      fwriterec(1,user,30)
      fWriteRec(1,Title,70)
      fwriterec(1,Page,70)
      fwriterec(1,Desc1,70)
      fwriterec(1,Desc2,70)
      fwriterec(1,Desc3,70)
      FClose(1)
    EndIf 
  EndIf
PEnd AddWeb

### View Webpages (long)
Proc vLong
  If InputNY('|CR|05d|13o you want to view the web entries|08? ')
    ShowInfo
    ### If lQ-WEB.DAT doesn't exist then there are no records
    If Not FExist(file1)
        WriteLn('|05n|13o entries available')
        Write('|CR|PA')
      Else # lQ-WEB.DAT found
        Count := 0
        FOpen(1, Bin, Reset, file1)
        More := True
        Repeat
          If Count = 0
              WriteLn(Bar)
              NOS := NOS + 1
              If NOS = 3  # Display 2 entries at a time
                  NOS := 1
                  MoreYN  # prompt user to continue
              EndIf
            ### Display the Webpage(s)
            ElseIf Count = 1
              FReadRec(1, User, 30)
              fReadRec(1,Title,70)
              FReadRec(1, Page, 70)
              fReadRec(1,Desc1,70)
              fReadRec(1,Desc2,70)
              fReadRec(1,Desc3,70)
              ShowLine
          EndIf
          Count := Count + 1
          If Count = 2 Count := 0 EndIf
        Until EOF(1) or More=False
        FClose(1)
        If More=True Then WriteLn(Bar) EndIf
        Write('|CR|PA')
    EndIf
  EndIf
PEnd vLong

### View Webpages (short)
Proc vShort
  If InputNY('|CR|05d|13o you want to view the web entries|08? ')
    ShowInfo
    ### If lQ-WEB.DAT doesn't exist then there are no entries.
    If Not FExist(file1)
        WriteLn('|05n|13o entries available')
        Write('|CR|PA')
      Else
        Count := 0
        FOpen(1, Bin, Reset, file1)
        More := True
        Repeat
          If Count = 0
             WriteLn(Bar)
              NOS := NOS + 1
              If NOS = 6 # display 5 entries
                  NOS := 1
                  MoreYN
              EndIf
            ### Display the SHORT list
            ElseIf Count = 1
              FReadRec(1, User, 30)
              fReadRec(1,Title,70)
              FReadRec(1, Page, 70)
              fReadRec(1,Desc1,70)
              fReadRec(1,Desc2,70)
              fReadRec(1,Desc3,70)
            ShortLine # ShowLine for long version
          EndIf
          Count := Count + 1
          If Count = 2 Count := 0 EndIf
        Until EOF(1) or More=False
        FClose(1)
        If More=True Then WriteLn(Bar) EndIf
        Write('|CR|PA')
    EndIf
  EndIf
PEnd vShort

Var FO Boolean

### Review entries
Proc Remove
    FO := False
  Entry := 1
  Repeat
    Done := False
    ShowInfo
    WriteLn('|05r|13eview entries|CR')
        WriteLn(bar)
    If Not FExist(file1) # If lQ-WEB.DAT doesn't exist then no entries
        WriteLn('|05n|13o entries available')
        WriteLn(bar)
        Write('|CR|PA')
        Done := True
      Else
        If Not FO
            If Not FCopy(File1, File2)
                Repeat
                  Delay(10)
                Until FCopy(File2, File1)
            EndIf
            FOpen(2, Bin, Reset, cfgdatapath+'lQ-web.tmp')
            FO := True
        EndIf
        If EOF(2)
            FSeek(2,0)
        EndIf
        entry := filepos(2)/380 +1
        nos := filesize(2)/380
        WriteLn('|05e|13ntry|08: |05'+Entry+'|13/|05'+nos)
        FReadRec(2, User, 30)
        fReadRec(2,Title,70)
        FReadRec(2, Page, 70)
        fReadRec(2,Desc1,70)
        fReadRec(2,Desc2,70)
        fReadRec(2,Desc3,70)
        ShowLine
        WriteLn(bar)
        FSeek(2, FilePos(2)-380)
        WriteLn('|CR|13[|05 back  |13]|05 foward  |13d|05 delete  |13e|05 edit  |13j|05 jump  |13q|05 quit')
        Inpt := ReadKey
        If Upper(Inpt) = '['
            fpos:=filepos(2)-392
            if fpos<0
              FSeek(2, 0)
            else
              fseek(2, fpos)
            endif
          Elseif Upper(Inpt) = ']'
            FPos:=FilePos(2)+380
            If FPos=FileSize(2)
                FSeek(2, 0)
              Else
                FSeek(2, FPos)
            EndIf
          Elseif Upper(Inpt) = 'J'
            Write('|CR|05j|13ump to entry |08: |05')
            Inpt := Input(3, 3, 1, '')
            Temp := Str2Int(Inpt)
            NOS := FileSize(2) / 380 +1
            If Temp > 0 Then
              temp:=temp-1
              If Temp < NOS Then
                temp:=temp*386
                FSeek(2, Temp)# if on last entry and "]" is pressed
                                          # again then go back to first entry
              EndIf
            EndIf
          Elseif Upper(Inpt) = 'E'
            Write('|CR'+ShowLine1)
            User := Input(30, 30, 1, User)
            Write('|CR'+ShowLine6)
            Title := Input(70,70,1,Title)
            Write('|CR'+ShowLine2)
            Page := Input(70, 70, 1, Page)
            Write('|CR'+ShowLine3)
            Desc1:=Input(70,70,1,Desc1)
            Write('|CR'+ShowLine4)
            Desc2:=Input(70,70,1,Desc2)
            Write('|CR'+ShowLine5)
            Desc3:=Input(70,70,1,Desc3)
            If Page <> '' and User <> '' and Desc1 <> '' and Desc2 <> '' and Desc3 <> ''
                FSeek(2, FilePos(2))
                FWriteRec(2, User, 30)
                fWriteRec(2,Title,70)
                FWriteRec(2, Page, 70)
                fwriterec(2, Desc1, 70)
                fwriterec(2,Desc2,70)
                fwriterec(2,Desc3,70)
            EndIf
            FSeek(2, FilePos(2) - 380)
          Elseif Upper(Inpt) = 'D'
            If Not InputNY('|CR|05d|13elete entry|08? ')
              Else
                fpos := filepos(2)
                fopen(3,bin,rewrite,'lQ-web.del')
                fseek(2,0)
                count := 0
                if entry = 1
                    writeln('|CR|05c|13annot delete last entry.  purge instead.')
                    Write('|CR|PA')
                  else
                    repeat
                      freadrec(2, User, 30)
                      fReadRec(2,Title,70)
                      freadrec(2,Page, 70)  
                      freadrec(2,Desc1,70)
                      freadrec(2,Desc2,70)
                      freadrec(2,Desc3,70)
                      count := count + 1
                      if count = entry
                        else
                          fwriterec(3, User, 30)
                          fWriteRec(3, Title,70)
                          fwriterec(3, Page, 70)
                          fwriterec(3, Desc1,70)
                          fwriterec(3, Desc2,70)
                          fwriterec(3, Desc3,70)
                      endif
                    until eof(2)
                    fclose(3)
                    fclose(2)
                    If Not FCopy('lQ-web.del', File2)
                        Repeat
                          Delay(10)
                        Until FCopy(File2, File1)
                    EndIf
                    fopen(2, bin, reset, file2)
                    fseek(2, fpos-392)
                EndIf
            endif
          ElseIf Upper(Inpt) = 'Q'         
            Done := True
            fclose(2)
            If InputYN('|CR|05s|13ave before quitting|08? ')
              If Not FCopy(File2, File1)
                  Repeat
                    Delay(10)
                  Until FCopy(File2, File1)
              EndIf
            EndIf
          Else
            WriteLn(strInvalid)
            Delay(100)
        EndIf
    EndIf
  Until Done
  Done := False
  ferase(File2)
PEnd Remove

### SysOp menu
Proc SMenu
  Repeat
  Done := False
  NOS := 0
CLS
  WriteLn('|05[|13p|05]|07urge database')
  WriteLn('|05[|13r|05]|07eview entries')
  Writeln('|05[|13v|05]|07iew entries')
  WriteLn('|05[|13q|05]|07uit')
  WriteLn('')
  write('|05Y|13our Command |08: |05(|13'+ strRep(' ', 1) + '|05)'+strRep(chr(8),2))
  Inpt := ReadKey
  If Upper(Inpt) = 'Q'
      Done := True
    Elseif Upper(Inpt) = 'P'
      If InputNY('|CR|05d|13o you want to purge the database|08? ')
        FErase(File1)
        Else
      EndIf
    Elseif Upper(Inpt) = 'R'
      Remove
    Elseif Upper(Inpt) = 'V'
      vLong
  EndIf
  Until Done
PEnd SMenu

### Main menu
Proc Menu
  NOS := 0
CLS
  if acs('s255') # SysOp Main Menu
WriteLn('|08[|15a|08]|07dd webpage')
WriteLn('|08[|15l|08]|07ong webpage listings')
WriteLn('|08[|15s|08]|07hort webpage listings')
WriteLn('|08[|15*|08]|07 sysop menu')
WriteLn('|08[|15q|08]|07uit')
WriteLn('')
  elseif acs('!s255') # user is NOT a sysop
  ### if not sysop then this
  WriteLn('|08[|15a|08]|07dd webpage')
  Writeln('|08[|15l|08]|07ong webpage listings')
  Writeln('|08[|15s|08]|07hort webpage listings')
  WriteLn('|08[|15q|08]|07uit')
  WritelN('')
  endif
  write('|05Y|13our Command |08: |05(|13'+ strRep(' ', 1) + '|05)'+strRep(chr(8),2))
  Inpt := ReadKey
  If Upper(Inpt) = 'Q'
    If InputYN('|CR|05d|13o you want to exit|08? ') Then
        SysOpLog('::: '+UserAlias+' exited lQ-WEB')
        Halt
    EndIf
    Elseif Upper(Inpt) = 'A'
      AddWeb
     If InputNY('Add another website? ')
      AddWeb
     EndIf
    ElseIf Upper(Inpt) = 'L'
      vLong
    Elseif Upper(Inpt) = 'S'
      vShort
    Elseif Upper(Inpt) = '*'
      SMenu 
  EndIf
PEnd Menu

# Setup variables
GetCFG

File1 := cfgdatapath+'lQ-web.dat'
File2 := cfgdatapath+'lQ-web.tmp'

ShowLine1 := '|05u|13ser  |08: |05'
ShowLine6 := '|05t|13itle |08: |05'
ShowLine2 := '|05p|13age  |08: |05'
ShowLine3 := '|05d|13esc  |08: |05'
ShowLine4 := '|05        '
ShowLine5 := '|05        '
strInvalid:= '|05i|13nvalid command|CR'
Bar       := '|08|$D79'
NOS := 0

GetThisUser
SysOpLog('::: '+UserAlias+' entered lQ-Webpage Lister')

# Main loop
Repeat
  Menu
Until Inpt = 'Q'
### E N D  P R O G R A M
