# .------------------------------------------------------------------------.
# | GO-FCHG.MPS  : lightbar file base selector                             |
# +------------------------------------------------------------------------+
# |                                                                        |
# | You may modify this program for your own needs, but you CANNOT release |
# | it to the public.  If you feel you've made changes that are useful to  |
# | many people, either send the code to me and I may give you PERMISSION  |
# | to release it, or suggest those features to me and I may take your     |
# | suggestions and implement them.                                        |
# |                                                                        |
# | You can contact me at mysticbbs@geocities.com                          |
# `------------------------------------------------------------------------'

Uses CFG
Uses FBASE

Var TotalAreas Byte
Var Temp       Byte
Var Temp2      Byte  
Var Area       String Array(1..100)
Var Idx        Byte   Array(1..100)
Var TopPage    Byte
Var BarPos     Byte
Var Done       Boolean
Var Ch         Char
Var Ch2        Char
Var More       Byte
Var LastMore   Byte

Proc BarON
  GotoXY (21, 9 + BarPos - TopPage)
  Write ('|09|17 ' + PadRT(StripMCI(Area(BarPos)), 39, ' ') + '|16')
Pend BarON

Proc BarOFF
  GotoXY (21, 9 + BarPos - TopPage)
  Write ('|03 ' + PadRT(Area(BarPos), 39, ' '))
  Write (StrREP(' ', 61 - WhereX))
Pend BarOFF

Proc DrawPage
  Temp2 := BarPos
  For Temp := 0 to 11 
    BarPos := TopPage + Temp
    BarOFF
  Fend
  BarPos := Temp2
  BarON
Pend DrawPage

########################
## MAIN PROGRAM BLOCK ##
########################

If Graphics = 0 Then
  MenuCmd ('FA', '')
  Halt
EndIf

TotalAreas := 0
Temp       := 1

While GetFBase(Temp) And TotalAreas < 100
  If Acs(FBACS) Then
    TotalAreas        := TotalAreas + 1
    Area (TotalAreas) := FBName
    Idx  (TotalAreas) := Temp
  EndIf
  Temp := Temp + 1    
Wend

If TotalAreas = 0 Then
  WriteLn (GetPrompt(37))
  Halt
EndIf

If TotalAreas = 100 Then
  MenuCmd('FA', '')
  Halt
EndIf

GetCFG
DispFile (CfgTextPath + 'GO-FCHG')

TopPage  := 1
BarPos   := 1
Done     := False
More     := 0
LastMore := 0

DrawPage

Repeat
  More := 0
  Ch   := ' '
  Ch2  := ' '

  If TopPage > 1 Then
    More := 1
    Ch   := Chr(24)
  EndIf

  If TopPage + 11 < TotalAreas Then
    Ch2  := Chr(25)
    More := More + 2
  EndIf

  If More <> LastMore Then
    LastMore := More
    GotoXY (35, 21)
    Write (' |08(|07' + Ch + Ch2 + ' |15m|07ore|08) ')
  EndIf

  Ch := ReadKey
  If IsArrow Then
    If Ch = Chr(72) Then
      If BarPos > TopPage Then
        BarOFF
        BarPos := BarPos - 1
        BarON
      ElseIf TopPage > 1 Then
        TopPage := TopPage - 1
        BarPos  := BarPos  - 1
        DrawPage
      EndIf
    ElseIf Ch = Chr(73) Then
      If TopPage - 12 > 0 Then
        TopPage := TopPage - 12
        BarPos  := BarPos  - 12
        DrawPage
      Else
        TopPage := 1
        BarPos  := 1
        DrawPage
      EndIf    
    ElseIf Ch = Chr(80) Then
      If BarPos < TotalAreas Then
        If BarPos < TopPage + 11 Then
          BarOFF
          BarPos := BarPos + 1
          BarON
        ElseIf BarPos < TotalAreas Then
          TopPage := TopPage + 1
          BarPos  := BarPos  + 1
          DrawPage
        EndIf
      EndIf        
    ElseIf Ch = Chr(81) Then
      If TotalAreas > 12 Then
        If TopPage + 12 < TotalAreas - 12 Then
          TopPage := TopPage + 12
          BarPos  := BarPos  + 12
          DrawPage
        Else
          TopPage := TotalAreas - 11
          BarPos  := TotalAreas
          DrawPage
        EndIf
      Else
        BarOFF
        BarPos := TotalAreas
        BarON
      EndIf
    EndIf    
  ElseIf Ch = Chr(26) Then
    DispFile('GO-FCHGH')
    If Not IsNoFile Then
      Ch := ReadKey
      DrawPage
    EndIf
  ElseIf Ch = Chr(13) or Ch = Chr(27) Then
    Done := True
  EndIf
Until Done

GotoXY (1, 23)

If Ch = Chr(13) Then
  MenuCmd ('FA', Int2Str(Idx(BarPos)))
EndIf
