# ---------------------------------------------------------------------------
# ANIPAUSE.MPS v1.0b2: Animated pause engine for Mystic BBS v1.05.     
# ---------------------------------------------------------------------------
# Read ANIPAUSE.DOC for other information
# ---------------------------------------------------------------------------
# Another FREEWARE Mystic BBS modification.


Var FN            String     # Holds the file name 
Var ANILocation   String     # Holds the file path
Var MPEpos        integer    # Postion of ANIPAUSE.MPE in ANILocation

Var Int           Integer                # Holds Random Seed
Var Counter       Byte                   # Used for several loops
Var RandomFileExt Integer                # Generates 000 - 999

Var OptF          String array (1..4)    # ANIPAUSE.CFG Configuration file

Var Ext           String                 # Holds ANIMATED PROMPT Extension
Var AnimateFile   String array (1..50)   # ANIPXXXX.xxx animated text file
                                         # XXXX is ANSI or ASCII xxx 0 - 999
                                         # Line 1 is the delay time for the
                                         # animation, Lines 2..50 are each                                         
                                         # frame of animation 

Var DelayTime     Integer                # Delay before the next frame
Var TxtMax        Byte                   # Line 50 reached start line 2
   
Var tStart        LongInt                # Holds instant time
Var tNow          LongInt                # Holds the current time
Var TimeOut       LongInt                # Holds timeout delay

var SavedX        Byte                   # Holds X frame postion
var SavedY        Byte                   # Holds Y frame postion

#==========================================================================#
Proc Path_Get
#Begin
   #Holds the location of ANIPAUSE.MPE
   ANILocation := ParamStr(0)              

   #Returns the starting postion of ANIPAUSE in ANILocation
   MPEpos := Length(ANILocation) - Pos('.', ANILocation) - 8

   #Copies ANIPAUSE.MPE from ANILocation starting at MPEpos
   ANILocation := Copy(ANILocation, 1, MPEpos)
#End
PEnd Path_Get

#--------------------------------------------------------------------------#
Proc Exist_Config_File
  FN     := ANILocation + 'ANIPAUSE.CFG'
  If Not fExist(FN)
    WriteLn ('|CR|04ERROR: |07ANIPAUSE Configuration File not found.')
    Halt
  EndIf
Pend Exist_Config_File

#--------------------------------------------------------------------------#
Proc Read_Config_File
#Begin
  fOpen (1, Text, Reset, FN + Ext)

  fReadLn (1, OptF(1))    # Location of your ANIMATED prompts
  fReadLn (1, OptF(2))    # Inactive timer
  fReadLn (1, OptF(3))    # Total number of AsCII ANIMATED prompts
  fReadLn (1, OptF(4))    # Total number of  ANSi ANIMATED prompts

  fClose (1)
#End
Pend Read_config_File

#--------------------------------------------------------------------------#
Proc Get_File_Name  
#Begin 
  Repeat
    if Graphics = 0 then 
     #Begin
       FN := OptF(1) + 'ANIPTEXT.'
       Int := Str2Int (OptF(3))
       RandomFileExt := Random(Int)        
       If RandomFileExt = 0        then Ext := '000'
         ElseIf RandomFileExt > 99 then Ext := Int2Str(RandomFileExt)
         ElseIf RandomFileExt > 9  then Ext :=  '0' + Int2Str(RandomFileExt)
         Else                           Ext := '00' + Int2Str(RandomFileExt)
       EndIf
     #End
    else 
     #Begin
       FN := OptF(1) + 'ANIPANSI.'
       Int := Str2Int (OptF(4))
       RandomFileExt := Random(Int)        
       If RandomFileExt = 0        then Ext := '000'
         ElseIf RandomFileExt > 99 then Ext := Int2Str(RandomFileExt)
         ElseIf RandomFileExt > 9  then Ext := '0' + Int2Str(RandomFileExt)
         Else                           Ext := '00' + Int2Str(RandomFileExt)
       EndIf
    EndIf
  Until fExist(FN + Ext)
#End
Pend Get_File_Name

#--------------------------------------------------------------------------#
Proc Read_Text_Animation
#Begin

  fOpen (1, Text, Reset, FN + Ext)
  fReadLn (1, AnimateFile(1))
  DelayTime := Str2Int(AnimateFile(1))
 
  Counter := 1
  While Not Eof(1) and Counter < 50
    fReadLn (1, AnimateFile(Counter))
    Counter := Counter + 1
  Wend

  fClose (1)
  TxtMax := Counter - 1
#End
Pend Read_Text_Animation

#--------------------------------------------------------------------------#
Proc CheckTimeOut

#Begin
  tNow := Timer - tStart
  TimeOut := Str2Int(OptF(2))
  If tNow > TimeOut
    WriteLn ('')
    WriteLn ('|12Inactive timeout.')
    SysopLog ('ANIPAUSE: Timeout')
    Hangup
  EndIf
#End
PEnd CheckTimeOut


#--------------------------------------------------------------------------#
Proc Do_Pause
#Begin
  Counter := 1
  SavedX := WhereX
  Repeat
    CheckTimeOut 
    SavedY := WhereY
    MoveX (SavedX)
    Write (AnimateFile(Counter))
    If Counter = TxtMax Then
      Counter := 1
    Else
      Counter := Counter + 1
    EndIf  
   Delay (DelayTime)
 Until KeyPressed
 GotoXY(SavedX, SavedY)
 Write('                                                                                 ')
#End
PEnd Do_Pause

###############################
# START of main program block #
###############################
#Begin
tStart := Timer 

Path_Get
Exist_Config_File
Read_Config_File
Get_File_Name  
Read_Text_Animation
Do_Pause
#End

